/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.profile.server.wst.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.internal.launcher.HyadesTraceUIExtensionSupportUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop;
import org.eclipse.tptp.platform.profile.server.core.internal.IProfileServerConstants;
import org.eclipse.tptp.platform.profile.server.wst.internal.ProfileOnServerOptionWizard;
import org.eclipse.tptp.platform.profile.server.wst.internal.ServerPlugin;
import org.eclipse.tptp.platform.profile.server.wst.internal.ServerProfileExtender;
import org.eclipse.tptp.platform.profile.server.wst.provisional.ServerProfilingUtils;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorBaseLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.IParameterExtractor;
import org.eclipse.ui.IWorkingSet;

public class TPTPServerProfilerDelegate
extends ServerProfilerDelegate {
    private String[] vm_arg;
    private ILaunch launch;
    private IProgressMonitor monitor;

    protected String[] processVMArgs(String[] vmArgs, final ILaunchConfigurationWorkingCopy wc) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TPTPServerProfilerDelegate.this.vm_arg = TPTPServerProfilerDelegate.this.getVMArgsFromUser(wc);
            }
        });
        if (this.vm_arg != null) {
            String[] s = new String[vmArgs.length + this.vm_arg.length];
            System.arraycopy(this.vm_arg, 0, s, 0, this.vm_arg.length);
            System.arraycopy(vmArgs, 0, s, this.vm_arg.length, vmArgs.length);
            return s;
        }
        return vmArgs;
    }

    protected String trimLeadingSpaces(String str) {
        String result = str;
        while (result.startsWith(" ")) {
            result = result.substring(1, result.length());
        }
        return result;
    }

    protected String[] getVMArgsFromUser(ILaunchConfigurationWorkingCopy wc) {
        ProfileOnServerOptionWizard wizard = new ProfileOnServerOptionWizard(wc);
        WizardDialog dialog = new WizardDialog(ServerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        int wizardReturnCode = dialog.getReturnCode();
        wc.setAttribute(IProfileServerConstants.SERVER_DIALOG_STATUS, wizardReturnCode);
        if (wizardReturnCode == 1) {
            return null;
        }
        try {
            String collectorOptions = wc.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, "");
            String[] collectors = collectorOptions.split(";");
            ArrayList list = new ArrayList();
            int i = 0;
            while (i < collectors.length) {
                int idx = collectors[i].indexOf(":");
                if (idx > 0) {
                    List paramList;
                    String collectorID = collectors[i].substring(0, idx);
                    IDataCollectorBaseLauncher delegate = DataCollectorManager.getInstance().getDataCollectorLaunchDelegate(collectorID, wc.getOriginal());
                    if (delegate instanceof IParameterExtractor && (paramList = ((IParameterExtractor)delegate).getProcessParameters(wc.getOriginal()).getExecutableParameters()) != null) {
                        list.addAll(paramList);
                    }
                }
                ++i;
            }
            String[] vmArgStr = new String[list.size()];
            list.toArray(vmArgStr);
            int i2 = 0;
            while (i2 < vmArgStr.length) {
                Pattern p = Pattern.compile("server=controlled");
                Matcher m = p.matcher(vmArgStr[i2]);
                vmArgStr[i2] = m.replaceAll("server=enabled");
                vmArgStr[i2] = vmArgStr[i2].trim();
                ++i2;
            }
            return vmArgStr;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void startAC() {
        if (!AutoStartStop.isIACRunning()) {
            AutoStartStop.startIAC();
        }
    }

    public void process(ILaunch launch, IVMInstall vmInstall, VMRunnerConfiguration vmConfig, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.monitor = monitor;
        String[] vmArgs = vmConfig.getVMArguments();
        String[] envcfg = vmConfig.getEnvironment();
        String[] env = ServerProfilingUtils.getEnvironmentVariables();
        String jvm_version = "1.4.2";
        IVMInstall2 vmInstall2 = (IVMInstall2)vmInstall;
        if (vmInstall2 != null) {
            jvm_version = vmInstall2.getJavaVersion();
        }
        ILaunchConfigurationWorkingCopy wc = launch.getLaunchConfiguration().getWorkingCopy();
        wc.setAttribute(IProfileServerConstants.SERVER_JVM_VERSION, jvm_version);
        wc.doSave();
        this.startAC();
        vmArgs = this.processVMArgs(vmArgs, wc);
        if (wc.getAttribute(IProfileServerConstants.SERVER_DIALOG_STATUS, 1) == 1) {
            throw new CoreException((IStatus)new Status(2, ServerPlugin.getPluginId(), "Profile request is cancelled by user"));
        }
        HyadesTraceUIExtensionSupportUtil.applyExtensionFilterProcessing((ILaunchConfigurationWorkingCopy)wc, (IWorkingSet[])LauncherUtility.getActiveWorkingSets());
        envcfg = ServerProfilingUtils.map2String(ServerProfilingUtils.processEnvironmentVariables(ServerProfilingUtils.String2map(envcfg), ServerProfilingUtils.String2map(env)));
        vmConfig.setVMArguments(vmArgs);
        vmConfig.setEnvironment(envcfg);
        wc.doSave();
        this.postProcess(launch, vmInstall, vmConfig, monitor);
    }

    protected void postProcess(ILaunch launch, IVMInstall vmInstall, VMRunnerConfiguration vmConfig, IProgressMonitor monitor) {
        ServerProfileExtender[] extenders = ServerPlugin.getServerProfileExtenders();
        int i = 0;
        while (i < extenders.length) {
            extenders[i].process(launch, vmInstall, vmConfig, monitor);
            ++i;
        }
    }
}

