/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.instrument;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.probekit.ProbeInstrumenterDriver;
import org.eclipse.hyades.probekit.editor.internal.core.instrument.GenerateOperation;
import org.eclipse.hyades.probekit.editor.internal.core.instrument.JavacOperation;
import org.eclipse.hyades.probekit.editor.internal.core.util.ConversionUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

public class InstrumentOperation
implements IWorkspaceRunnable {
    private final IFile _probeFile;
    private final List _elementsToInstrument;
    private List _uninstrumentedFiles;
    public static final int GENERATE_ERROR = 0;
    public static final int COMPILE_ERROR = 1;
    public static final int INSTRUMENT_ERROR = 2;
    public static final int SETUP_ERROR = 3;

    public InstrumentOperation(IFile probeFile, List elements) {
        this._probeFile = probeFile;
        this._elementsToInstrument = elements;
    }

    public IFile getProbeFile() {
        return this._probeFile;
    }

    public List getElements() {
        return this._elementsToInstrument;
    }

    private IFile[] generate(IProgressMonitor monitor) throws CoreException {
        IFile[] generatedFiles = GenerateOperation.GenerateOperationUtil.getProbekitGeneratedFiles(this.getProbeFile());
        if (GenerateOperation.GenerateOperationUtil.needToGenerateProbe(this.getProbeFile())) {
            try {
                GenerateOperation generateOp = new GenerateOperation(this.getProbeFile());
                generateOp.run(monitor);
                if (GenerateOperation.GenerateOperationUtil.needToGenerateProbe(this.getProbeFile())) {
                    throw this.createGenerateFailedException(generatedFiles);
                }
            }
            catch (CoreException exc) {
                ProbekitUIPlugin.getPlugin().log((Object)exc);
                throw this.createGenerateFailedException(generatedFiles);
            }
        }
        return generatedFiles;
    }

    private CoreException createGenerateFailedException(IFile[] generatedFiles) {
        StringBuffer buffer = new StringBuffer(ConversionUtil.LINE_SEPARATOR);
        int i = 0;
        while (i < generatedFiles.length) {
            buffer.append(generatedFiles[i].getName());
            buffer.append(ConversionUtil.LINE_SEPARATOR);
            ++i;
        }
        buffer.append(NLS.bind((String)ProbekitMessages._98, (Object[])new Object[]{this.getProbeFile().getName()}));
        IStatus status = ResourceUtil.createInitialStatus(4, buffer.toString(), 0, null);
        return new CoreException(status);
    }

    private void compile(IFile[] genFiles, IProgressMonitor monitor) throws CoreException {
        try {
            JavacOperation javacOp = new JavacOperation(this.getProbeFile().getProject());
            javacOp.run(monitor);
        }
        catch (CoreException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
            throw this.createJavacException();
        }
        if (JavacOperation.JavacOperationUtil.hasCompileErrors(genFiles)) {
            throw this.createJavacException();
        }
    }

    private CoreException createJavacException() {
        IStatus status = ResourceUtil.createInitialStatus(4, NLS.bind((String)ProbekitMessages._99, (Object[])new Object[]{this.getProbeFile().getName()}), 1, null);
        return new CoreException(status);
    }

    private void instrument(IFile scriptFile, IProgressMonitor monitor) throws CoreException {
        List elements = this.getElements();
        String[] fileList = InstrumentOperationUtil.toOSStringFromCompound(elements);
        try {
            ProbeInstrumenterDriver driver = new ProbeInstrumenterDriver();
            File localFile = InstrumentOperationUtil.getLocalFileFromResource((IResource)scriptFile);
            int errorCount = driver.instrumentItems(localFile, fileList, true);
            if (errorCount != 0) {
                String[] errors = driver.getErrorStrings();
                int i = 0;
                while (i < errors.length) {
                    String error = errors[i];
                    IStatus status = ResourceUtil.createInitialStatus(4, error);
                    ProbekitUIPlugin.getPlugin().log(status);
                    ++i;
                }
                String uninstrumentedFiles = ConversionUtil.toLineDelimitedString(fileList);
                throw this.createInstrumentException(uninstrumentedFiles);
            }
        }
        catch (ProbeInstrumenterDriver.StaticProbeInstrumenterException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
            String uninstrumentedFiles = ConversionUtil.toLineDelimitedString(fileList);
            throw this.createInstrumentException(uninstrumentedFiles);
        }
    }

    private CoreException createInstrumentException(String uninstrumentedFiles) {
        IStatus status = ResourceUtil.createInitialStatus(4, NLS.bind((String)ProbekitMessages._100, (Object[])new Object[]{uninstrumentedFiles}), 2, null);
        return new CoreException(status);
    }

    private List getUninstrumentedFileNames() {
        if (this._uninstrumentedFiles == null) {
            this._uninstrumentedFiles = new ArrayList();
        }
        return this._uninstrumentedFiles;
    }

    private void validate(IProgressMonitor monitor) throws CoreException {
        List elements = this.getElements();
        for (Object element : elements) {
            IJavaElement jElement;
            String name;
            if (element instanceof IResource) {
                IResource res = (IResource)element;
                if (res.getType() == 1) {
                    name = this.validateFile((IFile)res, monitor);
                    if (name == null) continue;
                    this.getUninstrumentedFileNames().add(name);
                    continue;
                }
                this.getUninstrumentedFileNames().addAll(this.validateContainer((IContainer)res, monitor));
                continue;
            }
            if (!(element instanceof IJavaElement) || (name = this.validateElement(jElement = (IJavaElement)element, monitor)) == null) continue;
            this.getUninstrumentedFileNames().add(name);
        }
        if (this.getUninstrumentedFileNames().size() > 0) {
            throw this.createInstrumentException(ConversionUtil.toLineDelimitedString(this.getUninstrumentedFileNames()));
        }
    }

    private String validateFile(IFile file, IProgressMonitor monitor) throws CoreException {
        if (!InstrumentOperationUtil.canFileBeProbed(file)) {
            return null;
        }
        File localFile = InstrumentOperationUtil.getLocalFileFromResource((IResource)file, ".bak");
        boolean successful = this.validateLocalFile(localFile);
        if (successful) {
            InstrumentOperationUtil.refreshLocalFile(localFile, monitor);
            return null;
        }
        return file.getName();
    }

    private List validateContainer(IContainer container, IProgressMonitor monitor) throws CoreException {
        List filesToProbe = InstrumentOperationUtil.getFilesToProbe(container);
        Iterator iterator = filesToProbe.iterator();
        ArrayList<String> fileNames = new ArrayList<String>();
        while (iterator.hasNext()) {
            IFile file = (IFile)iterator.next();
            String name = this.validateFile(file, monitor);
            if (name == null) continue;
            fileNames.add(name);
        }
        return fileNames;
    }

    private String validateElement(IJavaElement element, IProgressMonitor monitor) throws CoreException {
        if (!InstrumentOperationUtil.canFileBeProbed(element)) {
            return null;
        }
        File localFile = InstrumentOperationUtil.getLocalFileFromElement(element, "bak");
        boolean successful = this.validateLocalFile(localFile);
        if (successful) {
            if (!InstrumentOperationUtil.isExternal(element)) {
                InstrumentOperationUtil.refreshLocalFile(localFile, monitor);
            }
            return null;
        }
        return element.getElementName();
    }

    private boolean validateLocalFile(File localFile) {
        if (!localFile.exists()) {
            return false;
        }
        return localFile.isFile();
    }

    private void setupForExecution(IProgressMonitor monitor) throws CoreException {
        IJavaProject thisProject = JavaCore.create((IProject)this.getProbeFile().getProject());
        IJavaProject jp = null;
        try {
            IJavaProject[] probedProjects = JavaUtil.getJavaProjectsFromCompound(this.getElements());
            IClassFile[] probeClassFiles = GenerateOperation.GenerateOperationUtil.getProbekitGeneratedClassFiles(this.getProbeFile());
            int i = 0;
            while (i < probedProjects.length) {
                jp = probedProjects[i];
                if (!jp.equals(thisProject)) {
                    IPath outputPath = this.getOutputLocation(jp);
                    int j = 0;
                    while (j < probeClassFiles.length) {
                        IResource res;
                        IClassFile cFile = probeClassFiles[j];
                        if (!jp.isOnClasspath((IJavaElement)cFile) && (res = cFile.getResource()) != null && res.isAccessible()) {
                            IPath newResource = outputPath.append(res.getName());
                            IResource existingResource = ResourceUtil.ROOT.findMember(newResource);
                            if (existingResource != null && existingResource.isAccessible()) {
                                existingResource.delete(true, monitor);
                            }
                            res.copy(newResource, true, monitor);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
            throw this.createSetupException(jp);
        }
        catch (CoreException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
            throw this.createSetupException(jp);
        }
    }

    private IPath getOutputLocation(IJavaProject jp) throws JavaModelException, CoreException {
        IPath result = null;
        result = JavaUtil.isBinaryProject(jp) ? JavaUtil.createClassFolder(jp) : jp.getOutputLocation();
        return result;
    }

    private CoreException createSetupException(IJavaProject jp) {
        String outputPathString = InstrumentOperationUtil.toOSStringFromResource((IResource)jp.getProject());
        IStatus status = ResourceUtil.createInitialStatus(4, NLS.bind((String)ProbekitMessages._101, (Object[])new Object[]{outputPathString}), 3, null);
        return new CoreException(status);
    }

    public boolean canRun() {
        String message = this.getErrorMessage();
        return message == null;
    }

    public String getErrorMessage() {
        if (!ProbekitUtil.isSupportedPlatform()) {
            return ProbekitMessages._103;
        }
        if (!this.getProbeFile().isAccessible()) {
            return NLS.bind((String)ProbekitMessages._104, (Object[])new Object[]{this.getProbeFile().getName()});
        }
        boolean valid = true;
        if (this.getElements() == null) {
            valid = false;
        } else if (this.getElements().isEmpty()) {
            valid = false;
        } else {
            for (Object obj : this.getElements()) {
                if (InstrumentOperationUtil.canObjectBeProbed(obj)) continue;
                valid = false;
                break;
            }
        }
        if (!valid) {
            return ProbekitMessages._105;
        }
        return null;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        String runErrorMessage = this.getErrorMessage();
        if (runErrorMessage != null) {
            IStatus status = ResourceUtil.createInitialStatus(4, NLS.bind((String)ProbekitMessages._102, (Object[])new Object[]{runErrorMessage}), 2);
            throw new CoreException(status);
        }
        IFile[] genFiles = this.generate(monitor);
        IFile probeScriptFile = genFiles[0];
        this.compile(genFiles, monitor);
        this.instrument(probeScriptFile, monitor);
        this.validate(monitor);
        InstrumentOperationUtil.refresh(this.getElements(), monitor);
        this.setupForExecution(monitor);
    }

    public static class InstrumentOperationUtil {
        private static final String DOT_PROBEKIT_BACKUP_EXT = ".bak";
        private static final String PROBEKIT_BACKUP_EXT = "bak";
        private static final String DOT = ".";

        static IResource[] getWorkspaceResourcesForLocalFile(File localFile) {
            Path location = new Path(localFile.getAbsolutePath());
            Object[] resources = null;
            resources = localFile.isDirectory() ? ResourceUtil.ROOT.findContainersForLocation((IPath)location) : ResourceUtil.ROOT.findFilesForLocation((IPath)location);
            return resources;
        }

        static String toOSStringFromResource(IResource res) {
            return InstrumentOperationUtil.getLocalFileFromResource(res).getAbsolutePath();
        }

        static String toOSStringFromJavaElement(IJavaElement element) {
            return InstrumentOperationUtil.getLocalFileFromElement(element).getAbsolutePath();
        }

        public static IResource[] getInstrumentedResourcesFromElement(IJavaElement element) {
            File localFile = InstrumentOperationUtil.getLocalFileFromElement(element, PROBEKIT_BACKUP_EXT);
            IResource[] resources = InstrumentOperationUtil.getWorkspaceResourcesForLocalFile(localFile);
            return resources;
        }

        static File getLocalFileFromResource(IResource resource) {
            return new File(resource.getLocation().toOSString());
        }

        static File getLocalFileFromElement(IJavaElement element) {
            IResource res = element.getResource();
            if (res == null) {
                IPath path = element.getPath();
                return path.toFile();
            }
            return InstrumentOperationUtil.getLocalFileFromResource(res);
        }

        static File getLocalFileFromElement(IJavaElement element, String fileExtension) {
            IResource res = element.getResource();
            if (res == null) {
                IPath path = element.getPath();
                path = path.addFileExtension(fileExtension);
                return path.toFile();
            }
            return InstrumentOperationUtil.getLocalFileFromResource(res, DOT + fileExtension);
        }

        static File getLocalFileFromResource(IResource resource, String fileExtension) {
            String osPath = String.valueOf(InstrumentOperationUtil.toOSStringFromResource(resource)) + fileExtension;
            return new File(osPath);
        }

        static boolean isExternal(IJavaElement element) {
            IPackageFragmentRoot root;
            return element.getElementType() == 3 && (root = (IPackageFragmentRoot)element).isExternal();
        }

        private static void refreshResources(IResource[] resources, IProgressMonitor monitor) throws CoreException {
            int i = 0;
            while (i < resources.length) {
                IResource res = resources[i];
                InstrumentOperationUtil.refreshResource(res, monitor);
                ++i;
            }
        }

        static void refreshResource(IResource resource, IProgressMonitor monitor) throws CoreException {
            resource.refreshLocal(2, monitor);
        }

        static void refreshLocalFile(File localFile, IProgressMonitor monitor) throws CoreException {
            IResource[] resources = InstrumentOperationUtil.getWorkspaceResourcesForLocalFile(localFile);
            InstrumentOperationUtil.refreshResources(resources, monitor);
        }

        static void refresh(List elements, IProgressMonitor monitor) throws CoreException {
            IResource[] resources = ConversionUtil.toResourceFromCompounds(elements);
            InstrumentOperationUtil.refreshResources(resources, monitor);
        }

        public static boolean canFileBeProbed(IJavaElement element) {
            if (JavaUtil.isClassFile(element)) {
                return true;
            }
            return JavaUtil.isArchive(element);
        }

        static boolean canFileBeProbed(IFile file) {
            IJavaElement element = JavaCore.create((IFile)file);
            boolean valid = true;
            if (element == null) {
                String fileName = file.getName();
                if (fileName.lastIndexOf(46) != -1) {
                    String fileExtension = fileName.substring(fileName.lastIndexOf(46)).toLowerCase();
                    if (!(fileExtension.equals(".jar") || fileExtension.equals(".war") || fileExtension.equals(".ear"))) {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
            } else {
                valid = InstrumentOperationUtil.canFileBeProbed(element);
            }
            return valid;
        }

        static boolean canResourceBeProbed(IResource resource) {
            if (resource.getType() == 1) {
                return InstrumentOperationUtil.canFileBeProbed((IFile)resource);
            }
            return true;
        }

        static boolean canObjectBeProbed(Object obj) {
            if (obj instanceof IResource) {
                return InstrumentOperationUtil.canResourceBeProbed((IResource)obj);
            }
            if (obj instanceof IJavaElement) {
                return InstrumentOperationUtil.canFileBeProbed((IJavaElement)obj);
            }
            return false;
        }

        static List getFilesToProbe(IContainer container) throws CoreException {
            ArrayList<IResource> files = new ArrayList<IResource>();
            IResource[] children = container.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                if (child.getType() == 1) {
                    if (InstrumentOperationUtil.canFileBeProbed((IFile)child)) {
                        files.add(child);
                    }
                } else {
                    files.addAll(InstrumentOperationUtil.getFilesToProbe((IContainer)child));
                }
                ++i;
            }
            return files;
        }

        static String[] toOSStringFromCompound(List elements) {
            String[] result = new String[elements.size()];
            Iterator iterator = elements.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (element instanceof IResource) {
                    result[count++] = InstrumentOperationUtil.toOSStringFromResource((IResource)element);
                    continue;
                }
                if (!(element instanceof IJavaElement)) continue;
                result[count++] = InstrumentOperationUtil.toOSStringFromJavaElement((IJavaElement)element);
            }
            return result;
        }
    }
}

