/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DataType;
import org.eclipse.hyades.models.internal.probekit.Fragment;
import org.eclipse.hyades.models.internal.probekit.FragmentType;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.impl.DataItemImpl;
import org.eclipse.hyades.models.internal.probekit.impl.FragmentImpl;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.ProbekitTypesSingleton;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.BaseDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.FragmentItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.ui.DataDialog;
import org.eclipse.hyades.probekit.editor.internal.ui.DialogUtil;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class FragmentDetails
extends BaseDetails {
    protected static final EAttribute TYPE = ProbekitPackage.eINSTANCE.getFragment_Type();
    protected CCombo fragmentCombo;
    protected ISourceViewer _methodViewer;
    protected boolean isDisplaying;
    protected Fragment currentSelection;
    protected FragmentItemProvider itemProvider;
    protected ProbekitItemProviderAdapterFactory itemFactory;
    protected ProbekitWidgetFactory widgetFactory;
    protected JavaTextTools _javaTextTools;
    protected JavaSourceViewerConfiguration _methodViewerConfiguration;
    Button _addButton = null;
    Button _editButton = null;
    Button _removeButton = null;
    private Label _errorMessage;
    private Label _codeLabelImage;
    static final String[] COLUMNS = new String[]{ProbekitMessages._40, ProbekitMessages._41};
    TableViewer _tableViewer;
    ComboBoxCellEditor _comboBoxCellEditor;
    TextCellEditor _textCellEditor;

    public FragmentDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this.widgetFactory = factory;
        this.itemFactory = itemFactory;
        this.itemProvider = (FragmentItemProvider)itemFactory.createFragmentAdapter();
        FragmentDetails parent = this;
        this.setLayoutData(GridUtil.createFill());
        this.setLayout((Layout)new GridLayout());
        this.createControl(parent);
    }

    protected void createControl(Composite parent) {
        ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
        sc1.setLayoutData((Object)GridUtil.createFill());
        sc1.setExpandHorizontal(true);
        sc1.setExpandVertical(true);
        Composite page = new Composite((Composite)sc1, 0);
        sc1.setContent((Control)page);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 1;
        page.setLayout((Layout)detailLayout);
        page.setLayoutData((Object)GridUtil.createFill());
        this.createCombo(page);
        this.createTable(page);
        this.createCode(page);
        sc1.setMinSize(page.computeSize(-1, -1));
    }

    protected void createCombo(Composite parent) {
        this.widgetFactory.createLabel(parent, ProbekitMessages._19, 0);
        this.fragmentCombo = this.widgetFactory.createCombo(parent, 776);
        this.fragmentCombo.setLayoutData((Object)new GridData(768));
        List list = FragmentType.VALUES;
        ArrayList<String> fragmentComboLabels = new ArrayList<String>();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                fragmentComboLabels.add(((FragmentType)list.get(i)).getName());
                ++i;
            }
        }
        Collections.sort(fragmentComboLabels);
        ComboSelectionListener listener = new ComboSelectionListener();
        for (String element : fragmentComboLabels) {
            this.fragmentCombo.add(element);
            this.fragmentCombo.addSelectionListener((SelectionListener)listener);
        }
        this.addFocusListenerTo((Control)this.fragmentCombo);
    }

    protected void createCode(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setFont(parent.getFont());
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        page.setLayout((Layout)pageLayout);
        GridData pageData = GridUtil.createFill();
        page.setLayoutData((Object)pageData);
        this._codeLabelImage = new Label(page, 0);
        this._codeLabelImage.setImage(this.getCodeImage());
        this.widgetFactory.createLabel(page, ProbekitMessages._11, 0);
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        this._javaTextTools = new JavaTextTools(store);
        this._methodViewer = new SourceViewer(page, null, null, false, 770);
        this._methodViewerConfiguration = new JavaSourceViewerConfiguration(this._javaTextTools.getColorManager(), store, null, null);
        this._methodViewer.configure((SourceViewerConfiguration)this._methodViewerConfiguration);
        Document document = new Document();
        IDocumentPartitioner partitioner = this._javaTextTools.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        this._methodViewer.setDocument((IDocument)document);
        this._methodViewer.setEditable(true);
        GridData descLayout = new GridData(1808);
        descLayout.horizontalSpan = 2;
        this._methodViewer.getTextWidget().setLayoutData((Object)descLayout);
        this.addFocusListenerTo((Control)this._methodViewer.getTextWidget());
        this._methodViewer.getTextWidget().addModifyListener((ModifyListener)new CodeModifyListener());
    }

    private void createTable(Composite parent) {
        Composite page = new Composite(parent, 2048);
        page.setFont(parent.getFont());
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        page.setLayout((Layout)pageLayout);
        GridData pageData = GridUtil.createHorizontalFill();
        page.setLayoutData((Object)pageData);
        this.createTableTitle(page);
        this.createErrorMessage(page);
        this.createTableViewer(page);
        this.createTableButtons(page);
    }

    private void createTableTitle(Composite page) {
        Label label = this.widgetFactory.createLabel(page, ProbekitMessages._24, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
    }

    private void createErrorMessage(Composite page) {
        this._errorMessage = this.widgetFactory.createLabel(page, "", 64);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this._errorMessage.setLayoutData((Object)data);
        this._errorMessage.setBackground(page.getBackground());
        this._errorMessage.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(3));
        this._errorMessage.setFont(page.getFont());
    }

    protected void setErrorMessage(String message) {
        String text = ResourceUtil.getString(message);
        this._errorMessage.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(3));
        this._errorMessage.setText(text);
        this._errorMessage.pack(true);
    }

    void validate() {
        String errorMessage = null;
        DataItem[] items = (DataItem[])this.currentSelection.getData().toArray((Object[])new DataItem[0]);
        if (!ProbekitTypesSingleton.singleton().isValidDataItemNames(items)) {
            errorMessage = ProbekitMessages._42;
        }
        if (!ProbekitTypesSingleton.singleton().isValidDataItemTypes(items)) {
            errorMessage = ProbekitMessages._43;
        }
        this.setErrorMessage(errorMessage);
    }

    private void createTableViewer(Composite page) {
        this._tableViewer = new TableViewer(page, 68100);
        TableLayout tableLayout = new TableLayout();
        Table table = this._tableViewer.getTable();
        CellEditor[] cellEditors = new CellEditor[COLUMNS.length];
        TableColumn comboCell = new TableColumn(table, 16384);
        comboCell.setText(COLUMNS[0]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        String[] comboboxItems = this.getAvailableDataTypeNames();
        this._comboBoxCellEditor = new ComboBoxCellEditor((Composite)table, comboboxItems);
        cellEditors[0] = this._comboBoxCellEditor;
        TableColumn textCell = new TableColumn(table, 16384);
        textCell.setText(COLUMNS[1]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        this._textCellEditor = new TextCellEditor((Composite)table);
        cellEditors[1] = this._textCellEditor;
        this._tableViewer.setCellEditors(cellEditors);
        this._tableViewer.setCellModifier((ICellModifier)new DataItemCellModifier());
        this._tableViewer.setContentProvider((IContentProvider)new DataItemContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new DataItemColumnLabelProvider());
        this._tableViewer.setColumnProperties(COLUMNS);
        GridData tableData = new GridData(1808);
        table.setLayoutData((Object)tableData);
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(page.getFont());
        table.addSelectionListener((SelectionListener)new ButtonListener());
    }

    private void createTableButtons(Composite page) {
        ButtonListener listener = new ButtonListener();
        Composite buttonGroup = new Composite(page, 0);
        buttonGroup.setFont(page.getFont());
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.makeColumnsEqualWidth = true;
        buttonGroup.setLayout((Layout)buttonLayout);
        GridData buttonData = new GridData();
        buttonGroup.setLayoutData((Object)buttonData);
        this._addButton = new Button(buttonGroup, 8);
        this._addButton.setText(ProbekitMessages._125);
        GridData addData = GridUtil.createHorizontalFill();
        addData.verticalAlignment = 2;
        this._addButton.setLayoutData((Object)addData);
        this._addButton.addSelectionListener((SelectionListener)listener);
        this._editButton = new Button(buttonGroup, 8);
        this._editButton.setText(ProbekitMessages._118);
        GridData editData = GridUtil.createHorizontalFill();
        editData.verticalAlignment = 2;
        this._editButton.setLayoutData((Object)editData);
        this._editButton.addSelectionListener((SelectionListener)listener);
        this._removeButton = new Button(buttonGroup, 8);
        this._removeButton.setText(ProbekitMessages._119);
        GridData removeData = GridUtil.createHorizontalFill();
        removeData.verticalAlignment = 2;
        this._removeButton.setLayoutData((Object)removeData);
        this._removeButton.addSelectionListener((SelectionListener)listener);
        this.refreshButtons();
    }

    private void refreshButtons() {
        DataType[] availableTypes = this.getAvailableDataTypes();
        this._addButton.setEnabled(availableTypes.length > 0);
        DataItem dataItem = this.getSelectedItem();
        boolean enabled = dataItem != null;
        this._editButton.setEnabled(enabled);
        this._removeButton.setEnabled(enabled);
    }

    void refreshCodeLabel() {
        this._codeLabelImage.setImage(this.getCodeImage());
    }

    public void refresh() {
        this.refreshCodeLabel();
        this.refreshTable();
        this.refreshButtons();
        this.validate();
    }

    void refreshTable() {
        this._tableViewer.refresh();
    }

    public void display(Object object) {
        EObject container;
        if (this.fragmentCombo.isFocusControl() || this._methodViewer.getTextWidget().isFocusControl()) {
            this.refreshCodeLabel();
            return;
        }
        Fragment fragment = null;
        if (object instanceof Fragment) {
            fragment = (Fragment)object;
        } else if (object instanceof DataItem && (container = ((DataItem)object).eContainer()) instanceof Fragment) {
            fragment = (Fragment)container;
        }
        if (fragment == null) {
            this.setCurrentSelection(null);
            return;
        }
        this.setCurrentSelection(fragment);
        this.isDisplaying = true;
        FragmentType frag = this.currentSelection.getType();
        if (frag != null) {
            this.fragmentCombo.setText(frag.getName());
        }
        this._methodViewer.getTextWidget().setText(this.currentSelection.getCode() == null ? "" : this.currentSelection.getCode());
        this._methodViewer.getTextWidget().setFocus();
        this.isDisplaying = false;
    }

    private Image getCodeImage() {
        return DialogUtil.getImage((URL)this.itemProvider.getImage(this.currentSelection));
    }

    public void setCurrentSelection(Fragment fragment) {
        this.currentSelection = fragment;
        this._tableViewer.setInput((Object)this.currentSelection.getData());
        this.refresh();
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        this.setCurrentSelection((Fragment)currentSelection);
        this.currentSelection.setType(FragmentType.get((String)this.fragmentCombo.getText().trim()));
        return false;
    }

    public void setFocusToText() {
        this.fragmentCombo.setFocus();
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.fragmentCombo = null;
        this._methodViewer = null;
        this._javaTextTools = null;
        this._methodViewerConfiguration = null;
    }

    public boolean isDetailsFor(Object object) {
        if (object instanceof Fragment || object instanceof FragmentImpl) {
            return true;
        }
        return object instanceof DataItem || object instanceof DataItemImpl;
    }

    public void setFocusTo() {
        this.refreshCodeLabel();
        this.setFocusToText();
    }

    DataItem getSelectedItem() {
        int idx = this._tableViewer.getTable().getSelectionIndex();
        if (idx == -1) {
            return null;
        }
        return (DataItem)this._tableViewer.getElementAt(idx);
    }

    public void createDataItem() {
        DataType[] availableTypes = this.getAvailableDataTypes();
        DataItem item = ProbekitTypesSingleton.singleton().createDataItem(availableTypes, this.currentSelection.getData().size());
        this.itemProvider.addAndNotify(this.currentSelection, item);
    }

    public void updateDataName(DataItem dataItem, String newName) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)dataItem);
        if (domain != null) {
            SetCommand command = new SetCommand(domain, (EObject)dataItem, (EStructuralFeature)ProbekitPackage.eINSTANCE.getDataItem_Name(), (Object)newName);
            domain.getCommandStack().execute((Command)command);
        }
    }

    public void updateDataType(DataItem dataItem, String newType) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)dataItem);
        if (domain != null) {
            DataType type = DataType.get((String)newType);
            SetCommand command = new SetCommand(domain, (EObject)dataItem, (EStructuralFeature)ProbekitPackage.eINSTANCE.getDataItem_Type(), (Object)type);
            domain.getCommandStack().execute((Command)command);
        }
    }

    public void removeDataItem(DataItem item) {
        this.itemProvider.removeAndNotify(this.currentSelection, item);
    }

    public DataType[] getAvailableDataTypes() {
        if (this.currentSelection == null) {
            return new DataType[0];
        }
        return ProbekitTypesSingleton.singleton().getDataTypes(this.currentSelection.getType());
    }

    public String[] getAvailableDataTypeNames() {
        DataType[] allTypes = this.getAvailableDataTypes();
        String[] allTypeNames = new String[allTypes.length];
        int i = 0;
        while (i < allTypes.length) {
            allTypeNames[i] = allTypes[i].getName();
            ++i;
        }
        return allTypeNames;
    }

    private class ButtonListener
    implements SelectionListener {
        private ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.widget.equals(FragmentDetails.this._addButton)) {
                this.add();
            } else if (event.widget.equals(FragmentDetails.this._editButton)) {
                this.edit();
            } else if (event.widget.equals(FragmentDetails.this._removeButton)) {
                this.remove();
            } else if (event.widget.equals(FragmentDetails.this._tableViewer.getTable())) {
                FragmentDetails.this.refresh();
                return;
            }
            FragmentDetails.this.refresh();
        }

        private void add() {
            FragmentDetails.this.createDataItem();
            FragmentDetails.this.refreshTable();
            this.select(FragmentDetails.this._tableViewer.getTable().getItemCount() - 1);
        }

        private void edit() {
            DataItem item = FragmentDetails.this.getSelectedItem();
            if (item != null) {
                String[] allTypeNames = FragmentDetails.this.getAvailableDataTypeNames();
                DataItem updatedItem = ProbekitPackage.eINSTANCE.getProbekitFactory().createDataItem();
                updatedItem.setName(item.getName());
                updatedItem.setType(item.getType());
                DataDialog dialog = new DataDialog(FragmentDetails.this.getShell(), allTypeNames, updatedItem);
                dialog.setBlockOnOpen(true);
                dialog.setTitle(ProbekitMessages._44);
                if (dialog.open() != 0) {
                    return;
                }
                updatedItem = dialog.getResult();
                if (!item.getName().equals(updatedItem.getName())) {
                    FragmentDetails.this.updateDataName(item, updatedItem.getName());
                }
                if (!item.getType().equals((Object)updatedItem.getType())) {
                    FragmentDetails.this.updateDataType(item, updatedItem.getType().getName());
                }
            }
        }

        private void remove() {
            DataItem item = FragmentDetails.this.getSelectedItem();
            int index = FragmentDetails.this._tableViewer.getTable().getSelectionIndex();
            if (item != null) {
                FragmentDetails.this.removeDataItem(item);
                --index;
            }
            FragmentDetails.this.refreshTable();
            this.select(index);
        }

        private void select(int index) {
            FragmentDetails.this._tableViewer.getTable().select(index);
        }
    }

    private class CodeModifyListener
    implements ModifyListener {
        private CodeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String text;
            if (FragmentDetails.this.currentSelection == null) {
                return;
            }
            if (e.getSource() == FragmentDetails.this._methodViewer.getTextWidget() && !(text = FragmentDetails.this._methodViewer.getTextWidget().getText()).equals(FragmentDetails.this.currentSelection.getCode())) {
                if (text.length() == 0 && FragmentDetails.this.currentSelection.getCode() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = FragmentDetails.this.itemProvider.getPropertyDescriptor(FragmentDetails.this.currentSelection, ProbekitPackage.eINSTANCE.getFragment_Code());
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)FragmentDetails.this.currentSelection, (Object)text);
                }
            }
        }
    }

    private class ComboSelectionListener
    implements SelectionListener {
        private ComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String text;
            if (FragmentDetails.this.isDisplaying || FragmentDetails.this.currentSelection == null) {
                return;
            }
            if (e.getSource() == FragmentDetails.this.fragmentCombo && !(text = FragmentDetails.this.fragmentCombo.getText().trim()).equals(FragmentDetails.this.currentSelection.getType().getName())) {
                if (text.length() == 0 && FragmentDetails.this.currentSelection.getType() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = FragmentDetails.this.itemProvider.getPropertyDescriptor(FragmentDetails.this.currentSelection, TYPE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)FragmentDetails.this.currentSelection, (Object)FragmentType.get((String)text));
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    }

    private class DataItemCellModifier
    implements ICellModifier {
        private DataItemCellModifier() {
        }

        public Object getValue(Object element, String property) {
            Object value = null;
            if (element instanceof DataItem) {
                DataItem item = (DataItem)element;
                if (property.equals(COLUMNS[0])) {
                    this.refreshComboBeforeEdit();
                    String typeName = ProbekitUtil.getDataTypeName(item);
                    value = this.getCellIndex(typeName);
                } else if (property.equals(COLUMNS[1])) {
                    value = ProbekitUtil.getDataItemName(item);
                }
            }
            return value;
        }

        private Integer getCellIndex(String dataTypeName) {
            Integer index = null;
            String[] items = FragmentDetails.this._comboBoxCellEditor.getItems();
            int i = 0;
            while (i < items.length) {
                String itemText = items[i];
                if (itemText.equals(dataTypeName)) {
                    index = new Integer(i);
                    break;
                }
                ++i;
            }
            if (index == null) {
                index = new Integer(0);
            }
            return index;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            DataItem dataItem = (DataItem)item.getData();
            if (property.equals(COLUMNS[0])) {
                Integer cellIndex = (Integer)value;
                String[] items = FragmentDetails.this._comboBoxCellEditor.getItems();
                String typeName = items[cellIndex];
                FragmentDetails.this.updateDataType(dataItem, typeName);
            } else if (property.equals(COLUMNS[1])) {
                String itemName = (String)value;
                FragmentDetails.this.updateDataName(dataItem, itemName);
            }
            FragmentDetails.this.refresh();
        }

        private void refreshComboBeforeEdit() {
            FragmentDetails.this._comboBoxCellEditor.setItems(FragmentDetails.this.getAvailableDataTypeNames());
        }
    }

    private class DataItemColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DataItemColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DataItem) {
                DataItem item = (DataItem)element;
                if (columnIndex == 0) {
                    return ProbekitUtil.getDataTypeName(item);
                }
                return ProbekitUtil.getDataItemName(item);
            }
            return "";
        }
    }

    private class DataItemContentProvider
    implements IStructuredContentProvider {
        private DataItemContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return FragmentDetails.this.currentSelection.getData().toArray();
        }
    }
}

