/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.Name;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.impl.NameImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.BaseDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.NameItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NameDetails
extends BaseDetails
implements ModifyListener {
    protected final EAttribute LANGUAGE = ProbekitPackage.eINSTANCE.getName_Lang();
    protected final EAttribute TEXT = ProbekitPackage.eINSTANCE.getName_Text();
    protected Text language;
    protected Text name;
    protected boolean isDisplaying;
    protected Name currentSelection;
    protected NameItemProvider itemProvider;
    protected ProbekitItemProviderAdapterFactory itemFactory;

    public NameDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this.itemFactory = itemFactory;
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 1;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        factory.createLabel(this, ProbekitMessages._14, 0);
        this.language = factory.createText(this, "", 0);
        this.language.setLayoutData((Object)new GridData(768));
        factory.createLabel(this, ProbekitMessages._16, 0);
        this.name = factory.createText(this, "", 0);
        this.name.setLayoutData((Object)new GridData(768));
        this.language.addModifyListener((ModifyListener)this);
        this.name.addModifyListener((ModifyListener)this);
        this.itemProvider = (NameItemProvider)itemFactory.createNameAdapter();
        this.addFocusListenerTo((Control)this.name);
        this.addFocusListenerTo((Control)this.language);
    }

    public void display(Object object) {
        if (this.language.isFocusControl() || this.name.isFocusControl()) {
            return;
        }
        this.currentSelection = (Name)object;
        this.isDisplaying = true;
        this.language.setText(this.currentSelection.getLang() == null ? "" : this.currentSelection.getLang());
        this.name.setText(this.currentSelection.getText() == null ? "" : this.currentSelection.getText());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        this.currentSelection = (Name)currentSelection;
        this.currentSelection.setLang(this.language.getText().trim());
        this.currentSelection.setText(this.name.getText().trim());
        return false;
    }

    public void setFocusToText() {
        this.language.setFocus();
        this.language.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.language) {
            String text2 = this.language.getText().trim();
            if (!text2.equals(this.currentSelection.getLang())) {
                if (text2.length() == 0 && this.currentSelection.getLang() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, this.LANGUAGE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.name && !(text = this.name.getText().trim()).equals(this.currentSelection.getText())) {
            if (text.length() == 0 && this.currentSelection.getText() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, this.TEXT);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.language = null;
        this.name = null;
    }

    public boolean isDetailsFor(Object object) {
        return object instanceof Name || object instanceof NameImpl;
    }

    public void setFocusTo() {
        this.setFocusToText();
    }

    public void refresh() {
    }
}

