/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitEditor;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class ProbekitActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected Action addProbeAction;
    protected IAction showPropertiesViewAction = new Action(ProbekitMessages._31){

        public void run() {
            try {
                ProbekitActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                ProbekitUIPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(ProbekitMessages._32){

        public boolean isEnabled() {
            return ProbekitActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (ProbekitActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)ProbekitActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection createChildActions;
    protected IMenuManager createChildMenuManager;
    protected IMenuManager createSiblingMenuManager;

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("probekit-settings"));
        toolBarManager.add((IContributionItem)new Separator("probekit-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(ProbekitMessages._4, "org.eclipse.hyades.models.probekit.internal.probekitMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(ProbekitMessages._3);
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(ProbekitMessages._2);
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
        submenuManager.updateAll(true);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            if (this.selectionProvider != null) {
                this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                if (this.selectionProvider.getSelection() != null) {
                    this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
                }
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        Collection newChildDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
    }

    protected Collection generateCreateChildActions(Collection descriptors, ISelection selection) {
        ArrayList<CreateChildAction> actions = new ArrayList<CreateChildAction>();
        if (descriptors != null) {
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateChildAction(this.activeEditorPart, selection, i.next()));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
        if (actions != null) {
            for (IAction action : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, action);
                    continue;
                }
                manager.add(action);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        if (this.addProbeAction == null && this.activeEditorPart != null && this.activeEditorPart instanceof ProbekitEditor) {
            this.addProbeAction = new Action(ProbekitMessages._122){

                public void run() {
                    ((ProbekitEditor)ProbekitActionBarContributor.this.activeEditorPart).addProbe();
                }
            };
        }
        if (this.addProbeAction != null && this.selectionProvider != null) {
            ISelection sel = this.selectionProvider.getSelection();
            if (sel == null || sel.isEmpty() || ((IStructuredSelection)sel).getFirstElement() instanceof Probe) {
                menuManager.insertBefore("additions", (IAction)this.addProbeAction);
            }
            menuManager.insertBefore("additions", (IContributionItem)new Separator());
        }
        submenuManager = new MenuManager(ProbekitMessages._3);
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("additions", (IContributionItem)submenuManager);
    }

    public void replaceGlobalActions(IActionBars actionBars, ProbekitEditor.MyActionHandlerListener actionHandlerListener) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
        actionHandlerListener.connectCutCopyPasteActions(actionBars);
        actionBars.updateActionBars();
    }

    public void resetGlobalActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        if (this.activeEditor != null) {
            ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        }
        actionBars.updateActionBars();
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        super.addGlobalActions(menuManager);
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ImageDescriptor id = this.deleteAction.getImageDescriptor();
        this.deleteAction = new DeleteAction(){

            public boolean updateSelection(IStructuredSelection selection) {
                if (selection.getFirstElement() instanceof Probekit) {
                    return false;
                }
                return super.updateSelection(selection);
            }
        };
        this.deleteAction.setImageDescriptor(id);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        id = this.deleteAction.getImageDescriptor();
        this.cutAction = new CutAction(){

            public boolean updateSelection(IStructuredSelection selection) {
                if (selection.getFirstElement() instanceof Probekit) {
                    return false;
                }
                return super.updateSelection(selection);
            }
        };
        this.cutAction.setImageDescriptor(id);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
    }
}

