/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.hyades.probekit.editor.internal.presentation.DetailsContent;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitEditor;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ProbekitDetailsViewer
extends Viewer
implements ISelectionChangedListener {
    protected ProbekitWidgetFactory widgetFactory;
    protected ProbekitItemProviderAdapterFactory factory;
    protected DetailsContent details;
    protected Composite result;

    public ProbekitDetailsViewer(Composite parent, ProbekitItemProviderAdapterFactory factory, ProbekitWidgetFactory widgetFactory) {
        this.factory = factory;
        this.widgetFactory = new ProbekitWidgetFactory();
        this.result = this.widgetFactory.createComposite(parent);
        GridLayout detailLayout = new GridLayout();
        this.result.setLayout((Layout)detailLayout);
        this.result.setLayoutData((Object)GridUtil.createFill());
        this.createHeader(this.result);
        this.details = new DetailsContent(this.widgetFactory, this.factory, this.result, 0);
        this.details.createContent();
        this.widgetFactory.createCompositeSeparator(this.result);
        widgetFactory.paintChildControlsFor(this.result);
    }

    public Control getControl() {
        return this.result;
    }

    public Object getInput() {
        return null;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
        this.details.refresh();
    }

    public void setInput(Object input) {
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() != null && event.getSource() instanceof ProbekitEditor) {
            ISelection selection = event.getSelection();
            this.showSelection(selection);
        }
    }

    private void showSelection(ISelection selection) {
        Object currentSelection = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            currentSelection = ((IStructuredSelection)selection).getFirstElement();
        }
        if (currentSelection instanceof EObject) {
            this.details.showDetailsFor(currentSelection);
        } else if (currentSelection instanceof WrapperItemProvider) {
            Object value = ((WrapperItemProvider)currentSelection).getValue();
            if (value != null && value instanceof FeatureMapUtil.EntryImpl) {
                value = ((FeatureMapUtil.EntryImpl)value).getValue();
            }
            if (value != null && value instanceof EObject) {
                this.details.showDetailsFor(value);
            }
        } else if (currentSelection instanceof EObjectContainmentEList) {
            EObjectContainmentEList list = (EObjectContainmentEList)currentSelection;
            this.details.showDetailsFor(list);
        } else {
            this.details.showDetailsFor(null);
        }
    }

    public void dispose() {
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
        }
        this.widgetFactory = null;
        this.factory = null;
        if (this.details != null) {
            this.details.dispose();
        }
    }

    private void createHeader(Composite content) {
        this.widgetFactory.createCompositeSeparator(content);
    }
}

