/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.provider;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.Fragment;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.JavaSnippet;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;

public class FragmentItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public FragmentItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addCodePropertyDescriptor(object);
            this.addTypePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addCodePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getString("_UI_Fragment_code_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Fragment_code_feature", "_UI_Fragment_type"), (EStructuralFeature)ProbekitPackage.eINSTANCE.getFragment_Code(), true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
    }

    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getString("_UI_Fragment_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Fragment_type_feature", "_UI_Fragment_type"), (EStructuralFeature)ProbekitPackage.eINSTANCE.getFragment_Type(), true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
        }
        return this.childrenFeatures;
    }

    public Object getImage(Object object) {
        URL image = JavaSnippet.getImageURL(object);
        if (image != null) {
            return image;
        }
        return this.getResourceLocator().getImage("full/obj16/Fragment");
    }

    public String getText(Object object) {
        String type = ((Fragment)object).getType().toString();
        return type == null || type.length() == 0 ? this.getString("_UI_Fragment_type") : String.valueOf(this.getString("_UI_Fragment_type")) + " (" + type + ")";
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Fragment.class)) {
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public ResourceLocator getResourceLocator() {
        return ProbekitUIPlugin.INSTANCE;
    }

    public void addAndNotify(Fragment fragment, DataItem item) {
        EditingDomain domain = this.findEditingDomain(fragment);
        if (domain != null) {
            CreateChildCommand command = new CreateChildCommand(domain, (EObject)fragment, (EStructuralFeature)ProbekitPackage.eINSTANCE.getFragment_Data(), (Object)item, (Collection)Collections.EMPTY_LIST);
            this.executeCommand(domain, (Command)command);
        }
    }

    public void removeAndNotify(Fragment fragment, DataItem item) {
        EditingDomain domain = this.findEditingDomain(fragment);
        if (domain != null) {
            RemoveCommand command = new RemoveCommand(domain, (EObject)fragment, (EStructuralFeature)ProbekitPackage.eINSTANCE.getFragment_Data(), (Object)item);
            this.executeCommand(domain, (Command)command);
        }
    }

    public void updateAndNotify(Fragment fragment, int index, DataItem item) {
        EditingDomain domain = this.findEditingDomain(fragment);
        if (domain != null) {
            SetCommand command = new SetCommand(domain, (EObject)fragment, (EStructuralFeature)ProbekitPackage.eINSTANCE.getFragment_Data(), (Object)item, index);
            domain.getCommandStack().execute((Command)command);
        }
    }

    private EditingDomain findEditingDomain(Fragment fragment) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)fragment);
    }

    private void executeCommand(EditingDomain domain, Command command) {
        if (domain != null && command != null) {
            domain.getCommandStack().execute(command);
        }
    }
}

