/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class SelectAnythingValidator
implements ISelectionStatusValidator {
    private List _included;
    protected boolean cont = false;
    protected ArrayList vmLibPath = null;

    public SelectAnythingValidator(List includedResources) {
        this._included = includedResources;
    }

    public IStatus validate(Object[] obj) {
        Object[] res = ResourceUtil.filter(obj, this._included);
        if (res.length >= 1) {
            return this.getVMInstrumentation(obj);
        }
        return this.getChangeNumber();
    }

    protected IStatus getVMInstrumentation(Object[] objects) {
        if (this.vmLibPath == null) {
            this.vmLibPath = new ArrayList();
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstall[] installs = types[i].getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    IVMInstall install = installs[j];
                    this.vmLibPath.add(install.getInstallLocation().toString());
                    ++j;
                }
                ++i;
            }
        }
        String msg = null;
        int idx = 0;
        while (idx < objects.length) {
            if (msg != null) break;
            Object obj = objects[idx];
            if (obj instanceof IPackageFragmentRoot) {
                String path = ((IPackageFragmentRoot)obj).getPath().toOSString();
                int i = 0;
                while (i < this.vmLibPath.size()) {
                    if (path.startsWith(this.vmLibPath.get(i).toString())) {
                        msg = NLS.bind((String)ProbekitMessages._147, (Object)path);
                        break;
                    }
                    ++i;
                }
            }
            ++idx;
        }
        if (msg != null) {
            Status status = new Status(2, ProbekitUIPlugin.getPluginId(), 2, msg, null);
            return status;
        }
        return this.getOK();
    }

    IStatus getOK() {
        IStatus status = ResourceUtil.createInitialStatus(0, ProbekitMessages._87, null);
        return status;
    }

    IStatus getChangeNumber() {
        IStatus status = ResourceUtil.createInitialStatus(4, ProbekitMessages._88, null);
        return status;
    }
}

