/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui.newFile;

import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DataType;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.ProbeFileModel;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;
import org.eclipse.hyades.probekit.editor.internal.ui.DataDialog;
import org.eclipse.hyades.probekit.ui.internal.ContextIds;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class NewProbekitDataPage
extends WizardPage {
    public static final String PAGE_ID = "New Probekit File (Data)";
    ProbeFileModel _model = null;
    Button _addButton = null;
    Button _editButton = null;
    Button _removeButton = null;
    static final String[] COLUMNS = new String[]{ProbekitMessages._40, ProbekitMessages._41};
    TableViewer _tableViewer;
    private Label _explanationTitle;
    private Text _explanationText;
    ComboBoxCellEditor _comboBoxCellEditor;
    TextCellEditor _textCellEditor;
    private Label _generalDataExplanation;

    public NewProbekitDataPage(ProbeFileModel model) {
        super(PAGE_ID);
        this._model = model;
        this.setTitle(ProbekitMessages._38);
        this.setMessage(ProbekitMessages._39);
    }

    ProbeFileModel getModel() {
        return this._model;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.refresh();
        }
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setFont(parent.getFont());
        GridLayout pageLayout = new GridLayout();
        page.setLayout((Layout)pageLayout);
        GridData pageData = new GridData(1808);
        page.setLayoutData((Object)pageData);
        this.createTableDescription(page);
        this.createTable(page);
        this.createExplanationText(page);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)page, ContextIds.PROBEKIT_NEWWIZ_DATA);
        this.setControl((Control)page);
    }

    private void createTableDescription(Composite page) {
        this._generalDataExplanation = new Label(page, 64);
        GridData generalData = new GridData(1808);
        this._generalDataExplanation.setLayoutData((Object)generalData);
    }

    private void createTable(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setFont(parent.getFont());
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        page.setLayout((Layout)pageLayout);
        GridData pageData = new GridData(1808);
        page.setLayoutData((Object)pageData);
        this.createTableViewer(page);
        this.createTableButtons(page);
    }

    private void createTableViewer(Composite page) {
        this._tableViewer = new TableViewer(page, 68100);
        TableLayout tableLayout = new TableLayout();
        Table table = this._tableViewer.getTable();
        CellEditor[] cellEditors = new CellEditor[COLUMNS.length];
        TableColumn comboCell = new TableColumn(table, 16384);
        comboCell.setText(COLUMNS[0]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        String[] comboboxItems = this.getModel().getProbeMetaData().getDataTypeNames(null);
        this._comboBoxCellEditor = new ComboBoxCellEditor((Composite)table, comboboxItems);
        cellEditors[0] = this._comboBoxCellEditor;
        TableColumn textCell = new TableColumn(table, 16384);
        textCell.setText(COLUMNS[1]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        this._textCellEditor = new TextCellEditor((Composite)table);
        cellEditors[1] = this._textCellEditor;
        this._tableViewer.setCellEditors(cellEditors);
        this._tableViewer.setCellModifier((ICellModifier)new DataItemCellModifier());
        this._tableViewer.setContentProvider((IContentProvider)new DataItemContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new DataItemColumnLabelProvider());
        this._tableViewer.setInput((Object)this.getModel().getProbeMetaData().getDataItems());
        this._tableViewer.setColumnProperties(COLUMNS);
        GridData tableData = new GridData(1808);
        table.setLayoutData((Object)tableData);
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(page.getFont());
        table.addSelectionListener((SelectionListener)new PageWidgetListener());
    }

    private void createTableButtons(Composite page) {
        PageWidgetListener listener = new PageWidgetListener();
        Composite buttonGroup = new Composite(page, 0);
        buttonGroup.setFont(page.getFont());
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.makeColumnsEqualWidth = true;
        buttonGroup.setLayout((Layout)buttonLayout);
        GridData buttonData = new GridData();
        buttonGroup.setLayoutData((Object)buttonData);
        this._addButton = new Button(buttonGroup, 8);
        this._addButton.setText(ProbekitMessages._125);
        GridData addData = new GridData(770);
        this._addButton.setLayoutData((Object)addData);
        this._addButton.addSelectionListener((SelectionListener)listener);
        this._editButton = new Button(buttonGroup, 8);
        this._editButton.setText(ProbekitMessages._118);
        GridData editData = new GridData(770);
        this._editButton.setLayoutData((Object)editData);
        this._editButton.addSelectionListener((SelectionListener)listener);
        this._removeButton = new Button(buttonGroup, 8);
        this._removeButton.setText(ProbekitMessages._119);
        GridData removeData = new GridData(770);
        this._removeButton.setLayoutData((Object)removeData);
        this._removeButton.addSelectionListener((SelectionListener)listener);
        this.refreshButtons();
    }

    private void createExplanationText(Composite page) {
        this._explanationTitle = new Label(page, 65);
        GridData explanationTitleData = new GridData(768);
        this._explanationTitle.setLayoutData((Object)explanationTitleData);
        this._explanationTitle.setFont(page.getFont());
        this._explanationTitle.setBackground(page.getBackground());
        this._explanationText = new Text(page, 842);
        GridData explanationData = new GridData(1808);
        this._explanationText.setLayoutData((Object)explanationData);
        this._explanationText.setFont(page.getFont());
        this._explanationText.setBackground(page.getBackground());
    }

    void refresh() {
        this._generalDataExplanation.setText(this.getModel().getDataExplanation());
        this.refreshTable();
        this.refreshExplanation();
        this.refreshButtons();
    }

    private void refreshExplanation() {
        DataItem item = this.getSelectedItem();
        this._explanationTitle.setText(ProbekitUtil.getDataTypeName(item));
        this._explanationText.setText(this.getModel().getProbeMetaData().getDataTypeExplanation(item));
    }

    void refreshTable() {
        this._tableViewer.refresh();
    }

    private void refreshButtons() {
        DataType[] availableTypes = this.getModel().getProbeMetaData().getAvailableDataTypes();
        this._addButton.setEnabled(availableTypes.length > 0);
        DataItem dataItem = this.getSelectedItem();
        boolean enabled = dataItem != null;
        this._editButton.setEnabled(enabled);
        this._removeButton.setEnabled(enabled);
    }

    DataItem getSelectedItem() {
        int idx = this._tableViewer.getTable().getSelectionIndex();
        if (idx == -1) {
            return null;
        }
        return (DataItem)this._tableViewer.getElementAt(idx);
    }

    private DataItem[] getDataItems() {
        TableItem[] tableItems = this._tableViewer.getTable().getItems();
        DataItem[] dataItems = new DataItem[tableItems.length];
        int i = 0;
        while (i < tableItems.length) {
            TableItem tableItem = tableItems[i];
            dataItems[i] = (DataItem)tableItem.getData();
            ++i;
        }
        return dataItems;
    }

    void checkPageComplete() {
        this.getModel().getProbeMetaData().setDataItems(this.getDataItems());
        String errorMessage = null;
        if (!this.getModel().isValidDataItems()) {
            errorMessage = ProbekitMessages._42;
        }
        this.setErrorMessage(errorMessage);
        boolean isComplete = errorMessage == null;
        this.setPageComplete(isComplete);
    }

    private class DataItemCellModifier
    implements ICellModifier {
        private DataItemCellModifier() {
        }

        public Object getValue(Object element, String property) {
            Object value = null;
            if (element instanceof DataItem) {
                DataItem item = (DataItem)element;
                if (property.equals(COLUMNS[0])) {
                    this.refreshComboBeforeEdit();
                    String typeName = ProbekitUtil.getDataTypeName(item);
                    value = this.getCellIndex(typeName);
                } else if (property.equals(COLUMNS[1])) {
                    value = ProbekitUtil.getDataItemName(item);
                }
            }
            return value;
        }

        private Integer getCellIndex(String dataTypeName) {
            Integer index = null;
            String[] items = NewProbekitDataPage.this._comboBoxCellEditor.getItems();
            int i = 0;
            while (i < items.length) {
                String itemText = items[i];
                if (itemText.equals(dataTypeName)) {
                    index = new Integer(i);
                    break;
                }
                ++i;
            }
            if (index == null) {
                index = new Integer(0);
            }
            return index;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            DataItem dataItem = (DataItem)item.getData();
            if (property.equals(COLUMNS[0])) {
                Integer cellIndex = (Integer)value;
                String[] items = NewProbekitDataPage.this._comboBoxCellEditor.getItems();
                String typeName = items[cellIndex];
                DataType type = DataType.get((String)typeName);
                dataItem.setType(type);
            } else if (property.equals(COLUMNS[1])) {
                String itemName = (String)value;
                dataItem.setName(itemName);
            }
            NewProbekitDataPage.this.refresh();
            NewProbekitDataPage.this.checkPageComplete();
        }

        private void refreshComboBeforeEdit() {
            NewProbekitDataPage.this._comboBoxCellEditor.setItems(NewProbekitDataPage.this.getModel().getProbeMetaData().getDataTypeNames(NewProbekitDataPage.this.getSelectedItem()));
        }
    }

    private class DataItemColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DataItemColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DataItem) {
                DataItem item = (DataItem)element;
                if (columnIndex == 0) {
                    return ProbekitUtil.getDataTypeName(item);
                }
                return ProbekitUtil.getDataItemName(item);
            }
            return "";
        }
    }

    private class DataItemContentProvider
    implements IStructuredContentProvider {
        private DataItemContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return NewProbekitDataPage.this.getModel().getProbeMetaData().getDataItems();
        }
    }

    private class PageWidgetListener
    implements SelectionListener {
        private PageWidgetListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.widget.equals(NewProbekitDataPage.this._addButton)) {
                this.add();
            } else if (event.widget.equals(NewProbekitDataPage.this._editButton)) {
                this.edit();
            } else if (event.widget.equals(NewProbekitDataPage.this._removeButton)) {
                this.remove();
            }
            NewProbekitDataPage.this.refresh();
            NewProbekitDataPage.this.checkPageComplete();
        }

        private void add() {
            NewProbekitDataPage.this.getModel().createDataItem();
            NewProbekitDataPage.this.refreshTable();
            this.select(NewProbekitDataPage.this._tableViewer.getTable().getItemCount() - 1);
        }

        private void edit() {
            DataItem item = NewProbekitDataPage.this.getSelectedItem();
            if (item != null) {
                DataDialog dialog = new DataDialog(NewProbekitDataPage.this.getContainer().getShell(), NewProbekitDataPage.this.getModel().getProbeMetaData().getDataTypeNames(item), item);
                dialog.setBlockOnOpen(true);
                dialog.setTitle(ProbekitMessages._44);
                dialog.open();
                int index = NewProbekitDataPage.this._tableViewer.getTable().getSelectionIndex();
                DataItem updatedItem = dialog.getResult();
                NewProbekitDataPage.this.getModel().getProbeMetaData().setDataItem(index, updatedItem);
                NewProbekitDataPage.this.refreshTable();
                this.select(index);
            }
        }

        private void remove() {
            DataItem item = NewProbekitDataPage.this.getSelectedItem();
            int index = NewProbekitDataPage.this._tableViewer.getTable().getSelectionIndex();
            if (item != null) {
                NewProbekitDataPage.this.getModel().getProbeMetaData().removeDataItem(item);
                --index;
            }
            NewProbekitDataPage.this.refreshTable();
            this.select(index);
        }

        private void select(int index) {
            NewProbekitDataPage.this._tableViewer.getTable().select(index);
        }
    }
}

