/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.probekit.ProbekitPlugin;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.ui.internal.AddProbeNatureOperation;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchImages;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.tptp.platform.probekit.launch.internal.config.ProbePropertiesUI;
import org.eclipse.tptp.platform.probekit.launch.internal.config.ProbekitLaunchMessages;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistry;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;
import org.eclipse.tptp.platform.probekit.util.InvalidProbeBundleException;
import org.eclipse.tptp.platform.probekit.util.ProbeLaunchConfigString;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProbekitLaunchUI
implements SelectionListener {
    private int numProbesSelectedinUI = 0;
    private Composite _form;
    private Table _tblProbeSets;
    private Button _refreshData;
    private ProbePropertiesUI _propertiesUI;
    private String _warning;
    private Text _lblTitle;
    private TabFolder _folder;
    private ProfilingSetsManagerCopy _managerCopy;
    private ProbeRegistry _registry;
    private IDialogSettings _settings;
    private String _description = "";
    protected HashMap _mapProbeFilters;
    protected Map _filterSetsCopy;
    private Vector selectedProbes = new Vector();
    private static final int PROBE_NAME_INDEX = 0;
    private static final int PROBE_PREFILTERED_INDEX = 1;
    private static final int PROBE_IMPORTED_INDEX = 2;
    private static final int PROBE_ID_INDEX = 3;
    public static final String PROBE_LAUNCH_SELECTION_ATTRIBUTE_STRING = "org.eclipse.tptp.platform.probekit.launch.internal.PROBEUI";
    public static final String PROBE_LAUNCH_SETOPTION_ATTRIBUTE_PREFIX = "SETOPTION_";
    public final String PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX = "PROBEUI";

    public ProbekitLaunchUI() {
        this._registry = ProbeRegistry.getRegistry();
        ProbekitLaunchPlugin plugin = ProbekitLaunchPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("ProbeLaunchDialog");
        if (section == null) {
            section = workbenchSettings.addNewSection("ProbeLaunchDialog");
        }
        this._settings = section;
        this._mapProbeFilters = new HashMap();
        this._filterSetsCopy = new HashMap();
        this._warning = new String(ProbekitLaunchMessages._18);
    }

    public Composite CreateControl(Composite parent, ProfilingSetsManagerCopy config, boolean enabled) {
        ProbeRegistryEntry entry;
        FontData[] fonts;
        this._form = new Composite(parent, 0);
        GridData data = GridUtil.createFill();
        this._form.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this._form.setLayout((Layout)layout);
        this._lblTitle = new Text(this._form, 16392);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this._lblTitle.setLayoutData((Object)gd);
        Composite childTop = new Composite(this._form, 0);
        data = GridUtil.createVerticalFill();
        data.widthHint = 200;
        childTop.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        childTop.setLayout((Layout)layout);
        Font font = this._lblTitle.getFont();
        if (font != null && (fonts = font.getFontData()) != null && fonts.length >= 1) {
            this._lblTitle.setFont(new Font((Device)Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, 1));
        }
        this._lblTitle.setText(ProbekitLaunchMessages._25);
        this._tblProbeSets = new Table(childTop, 68388);
        data = GridUtil.createFill();
        this._tblProbeSets.setLayoutData((Object)data);
        this._refreshData = new Button(childTop, 8);
        this._refreshData.setText(ProbekitLaunchMessages._1);
        this._refreshData.addSelectionListener((SelectionListener)this);
        TableLayout layoutTable = new TableLayout();
        layoutTable.addColumnData((ColumnLayoutData)new ColumnPixelData(170, true));
        this._tblProbeSets.setLayout((Layout)layoutTable);
        this._tblProbeSets.setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(this._tblProbeSets, 16384);
        tc1.setText(ProbekitLaunchMessages._21);
        this.populateTableFromRegistry();
        this._tblProbeSets.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ProbeRegistryEntry entry;
                if (event.item instanceof TableItem && (entry = (ProbeRegistryEntry)event.item.getData()) != null) {
                    ProbekitLaunchUI.this._propertiesUI.updateWidgetValues(entry);
                    int index = ProbekitLaunchUI.this._tblProbeSets.indexOf((TableItem)event.item);
                    ProbekitLaunchUI.this._tblProbeSets.setSelection(index);
                }
            }
        });
        Composite childBottom = new Composite(this._form, 0);
        data = GridUtil.createFill();
        childBottom.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        childBottom.setLayout((Layout)layout);
        this._folder = new TabFolder(childBottom, 128);
        data = GridUtil.createFill();
        data.heightHint = 320;
        data.grabExcessHorizontalSpace = true;
        this._folder.setLayoutData((Object)data);
        TabItem item = new TabItem(this._folder, 0);
        item.setText(ProbekitLaunchMessages._20);
        this._propertiesUI = new ProbePropertiesUI();
        item.setControl((Control)this._propertiesUI.createControl((Composite)this._folder));
        if (this._tblProbeSets.getItemCount() == 0) {
            this._propertiesUI.showHint(true);
        }
        item.setImage(ProbekitLaunchImages.INSTANCE.getImage("properties.gif"));
        this._folder.setSelection(0);
        this._managerCopy = config != null ? config : new ProfilingSetsManagerCopy();
        this.initializeValues(config);
        int sel = this._tblProbeSets.getSelectionIndex();
        if (sel != -1 && (entry = (ProbeRegistryEntry)this._tblProbeSets.getItem(sel).getData()) != null) {
            this._propertiesUI.updateWidgetValues(entry);
        }
        this._tblProbeSets.setFocus();
        return this._form;
    }

    protected void initializeValues(ProfilingSetsManagerCopy config) {
        int iNumProbeSets = this._tblProbeSets.getItemCount();
        TableItem[] items = this._tblProbeSets.getItems();
        if (!this.selectedProbes.isEmpty()) {
            int i = 0;
            while (i < this.selectedProbes.size()) {
                String probeName = (String)this.selectedProbes.get(i);
                ProbeLaunchConfigString probeConfig = ProbeLaunchConfigString.fromString((String)probeName);
                if (probeConfig != null) {
                    this.restoreSelections(probeConfig, iNumProbeSets, items);
                }
                ++i;
            }
        } else {
            Map configAttributes = config.getDefaultSet().getAttributes();
            int index = 0;
            String strName = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec.PROBEUI" + index;
            ProfilingAttribute attribute = (ProfilingAttribute)configAttributes.get(strName);
            while (attribute != null) {
                String strValue = attribute.getValue();
                ProbeLaunchConfigString probeConfig = ProbeLaunchConfigString.fromString((String)strValue);
                this.restoreSelections(probeConfig, iNumProbeSets, items);
                strName = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec.PROBEUI" + ++index;
                attribute = (ProfilingAttribute)configAttributes.get(strName);
            }
        }
    }

    public void restoreSelections(ProbeLaunchConfigString probeConfig, int iNumProbeSets, TableItem[] items) {
        if (probeConfig != null) {
            String strProbeKitID = probeConfig.getRegistryId();
            int j = 0;
            while (j < iNumProbeSets) {
                String strEntryID;
                ProbeRegistryEntry entry = (ProbeRegistryEntry)items[j].getData();
                if (entry != null && (strEntryID = entry.getId()).equals(strProbeKitID)) {
                    items[j].setChecked(true);
                    break;
                }
                ++j;
            }
        }
    }

    public String validateConfiguration(ProfilingSetsManagerCopy managerCopy) {
        if (this.numProbesSelectedinUI == 0) {
            int iSelectedProbes = 0;
            int iAvailableProbes = this._tblProbeSets.getItemCount();
            if (iAvailableProbes > 0) {
                TableItem[] items = this._tblProbeSets.getItems();
                int i = 0;
                while (i < iAvailableProbes) {
                    if (items[i].getChecked()) {
                        ++iSelectedProbes;
                    }
                    ++i;
                }
            }
            if (iAvailableProbes == 0 || iSelectedProbes == 0) {
                return this._warning;
            }
            return null;
        }
        return null;
    }

    public void widgetSelected(SelectionEvent e) {
        final ArrayList<IProject> list = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int idx = 0;
        while (idx < projects.length) {
            try {
                IProject project = projects[idx];
                if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature") && !project.hasNature("org.eclipse.hyades.probekit.probekitnature")) {
                    IJavaProject jProject = JavaCore.create((IProject)project);
                    Object[] resources = jProject.getNonJavaResources();
                    boolean hasProbe = false;
                    int i = 0;
                    while (i < resources.length && !hasProbe) {
                        String extension = ((IResource)resources[i]).getFileExtension();
                        if (extension != null && extension.equals("probe")) {
                            hasProbe = true;
                        }
                        ++i;
                    }
                    if (hasProbe) {
                        list.add(project);
                    } else {
                        List sources = JavaUtil.getSourceContainerEntries((IJavaProject)jProject);
                        i = 0;
                        while (i < sources.size() && !hasProbe) {
                            IPath path = ((IClasspathEntry)sources.get(i)).getPath();
                            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                            resources = folder.members();
                            int j = 0;
                            while (!hasProbe && j < resources.length) {
                                String extension = ((IResource)resources[j]).getFileExtension();
                                if (extension != null && (extension.equals("probe") || extension.equals("probescript"))) {
                                    hasProbe = true;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (hasProbe) {
                            list.add(project);
                        }
                    }
                }
            }
            catch (Exception exception) {}
            ++idx;
        }
        this.populateTableFromRegistry();
        if (list.size() == 0) {
            return;
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        AddProbeNatureOperation addProbeNature = new AddProbeNatureOperation((Collection)list);
                        addProbeNature.run(monitor);
                    }
                    catch (CoreException ex) {
                        ex.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException exec) {
            exec.printStackTrace();
        }
        catch (InterruptedException exec) {
            exec.printStackTrace();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void populateTableFromRegistry() {
        this._tblProbeSets.removeAll();
        this._mapProbeFilters.clear();
        this._registry = null;
        if (this._registry == null) {
            this._registry = ProbeRegistry.getRegistry();
        }
        if (this._registry != null) {
            ProbeRegistryEntry[] probes = this.getProbesSortedByName();
            int i = 0;
            while (i < probes.length) {
                ProbeRegistryEntry probeEntry = probes[i];
                TableItem item = new TableItem(this._tblProbeSets, 0);
                item.setText(0, probeEntry.getName());
                if (probeEntry.hasTargets()) {
                    item.setText(1, ProbekitLaunchMessages._7);
                } else {
                    item.setText(1, ProbekitLaunchMessages._8);
                }
                this._mapProbeFilters.put(probeEntry.getId(), null);
                if (probeEntry.isAuthored()) {
                    item.setText(2, ProbekitLaunchMessages._8);
                } else {
                    item.setText(2, ProbekitLaunchMessages._7);
                }
                item.setText(3, probeEntry.getId());
                item.setData((Object)probeEntry);
                ++i;
            }
        }
    }

    public ProbeRegistryEntry[] getProbesSortedByName() {
        ArrayList<ProbeRegistryEntry> probes = new ArrayList<ProbeRegistryEntry>();
        for (ProbeRegistryEntry entry : this._registry) {
            probes.add(entry);
        }
        ProbeRegistryEntry[] sortedProbes = new ProbeRegistryEntry[probes.size()];
        probes.toArray(sortedProbes);
        Arrays.sort(sortedProbes, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                ProbeRegistryEntry probe1 = (ProbeRegistryEntry)obj1;
                ProbeRegistryEntry probe2 = (ProbeRegistryEntry)obj2;
                return probe1.getName().compareTo(probe2.getName());
            }
        });
        return sortedProbes;
    }

    public void saveSelections(int probesSelected) {
        TabItem[] item;
        this.numProbesSelectedinUI = probesSelected;
        int indexSelection = this._tblProbeSets.getSelectionIndex();
        if (indexSelection >= 0) {
            ProbeRegistryEntry entry;
            TableItem tableItem = this._tblProbeSets.getItem(indexSelection);
            if (tableItem != null && (entry = (ProbeRegistryEntry)tableItem.getData()) != null) {
                String strID = entry.getId();
                if (this._settings != null) {
                    this._settings.put("ProbeTableSelection", strID);
                }
            }
        } else if (this._settings != null) {
            this._settings.put("ProbeTableSelection", "");
        }
        if ((item = this._folder.getSelection())[0] != null) {
            String strName = item[0].getText();
            if (this._settings != null) {
                this._settings.put("ProbeFolderSelection", strName);
            }
        } else {
            this._settings.put("ProbeFolderSelection", "");
        }
    }

    public String getDescription(ProfilingSetsManagerCopy config) {
        String strDelim = "\n";
        String strIndent = "    ";
        this._description = "";
        if (this._registry == null) {
            this._registry = ProbeRegistry.getRegistry();
        }
        if (config != null && config.getDefaultSet() != null) {
            int index = 0;
            String strName = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec.PROBEUI" + index;
            Map configAttributes = config.getDefaultSet().getAttributes();
            ProfilingAttribute attribute = (ProfilingAttribute)configAttributes.get(strName);
            while (attribute != null) {
                String strProbeName;
                ProbeRegistryEntry probeEntry;
                String strValue = attribute.getValue();
                ProbeLaunchConfigString probeString = ProbeLaunchConfigString.fromString((String)strValue);
                String strProbeID = probeString.getRegistryId();
                if (strProbeID != null && strProbeID.length() > 0 && this._registry != null && (probeEntry = this._registry.lookupById(strProbeID)) != null && (strProbeName = probeEntry.getName()) != null) {
                    this._description = String.valueOf(this._description) + strIndent + strProbeName + strDelim;
                }
                strName = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec.PROBEUI" + ++index;
                attribute = (ProfilingAttribute)configAttributes.get(strName);
            }
        }
        if (this._description != null && this._description.length() > 0) {
            int iLastNewLineIndex = this._description.lastIndexOf(strDelim);
            if (iLastNewLineIndex >= 0) {
                this._description = this._description.substring(0, iLastNewLineIndex);
            }
        } else {
            this._description = String.valueOf(strIndent) + ProbekitLaunchMessages._28;
        }
        return this._description;
    }

    public Table getProbeSets() {
        return this._tblProbeSets;
    }

    public ProfilingSetsManagerCopy getManager() {
        return this._managerCopy;
    }

    public ProbeRegistry getRegistry() {
        return this._registry;
    }

    public IDialogSettings getSettings() {
        return this._settings;
    }

    public void setSettings(IDialogSettings givenSettings) {
        this._settings = givenSettings;
    }

    public void addSelectedProbes(String selection) {
        this.selectedProbes.add(selection);
    }

    public void clearSelectedProbes() {
        this.selectedProbes.removeAllElements();
    }

    public synchronized String getVMArguments(ILaunchConfiguration conf) {
        try {
            String vmArgument = "";
            String bootClassPath = "-Xbootclasspath/p:";
            String workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            boolean log = Boolean.getBoolean("probekitLogging");
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
                bootClassPath = String.valueOf(bootClassPath) + "\"";
            }
            String pathSeparator = System.getProperty("path.separator");
            Map activeProbes = this.getActiveProbes(conf);
            Iterator iterKeys = activeProbes.keySet().iterator();
            while (iterKeys.hasNext()) {
                IClasspathEntry[] classpathEntryList;
                String workspaceOfProbeFile;
                String key = iterKeys.next().toString();
                String strProbeSpec = (String)activeProbes.get(key);
                ProbeLaunchConfigString probeConfigDeploy = ProbeLaunchConfigString.fromString((String)strProbeSpec);
                String strProbeID = probeConfigDeploy.getRegistryId();
                ProbeRegistryEntry registryEntry = this.getRegistry().lookupById(strProbeID);
                IResource probeSource = null;
                try {
                    probeSource = registryEntry.getSource();
                }
                catch (InvalidProbeBundleException e) {
                    Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._29, (Throwable)e);
                    ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                    continue;
                }
                if (probeSource == null) {
                    Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._30, null);
                    ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                    continue;
                }
                IJavaProject javaProject = JavaCore.create((IProject)probeSource.getProject());
                if (javaProject == null) continue;
                String projectName = javaProject.getPath().toString();
                if (log) {
                    String message = NLS.bind((String)ProbekitLaunchMessages._36, (Object)projectName);
                    Status status = new Status(1, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
                    ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                    message = NLS.bind((String)ProbekitLaunchMessages._37, (Object)probeSource.toString());
                    status = new Status(1, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
                    ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                }
                if ((workspaceOfProbeFile = probeSource.getLocation().toString()).indexOf(workspaceLocation) == -1) {
                    workspaceLocation = workspaceOfProbeFile.substring(0, workspaceOfProbeFile.indexOf(projectName));
                }
                try {
                    bootClassPath = String.valueOf(bootClassPath) + workspaceLocation + javaProject.getOutputLocation() + pathSeparator;
                }
                catch (JavaModelException e1) {
                    Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._33, (Throwable)e1);
                    ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                }
                try {
                    classpathEntryList = javaProject.getRawClasspath();
                }
                catch (JavaModelException e) {
                    Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._31, (Throwable)e);
                    ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                    continue;
                }
                int i = 0;
                while (i < classpathEntryList.length) {
                    block39: {
                        String logMessage;
                        block38: {
                            IClasspathEntry classpathEntry = classpathEntryList[i];
                            int type = classpathEntry.getEntryKind();
                            logMessage = "Type:";
                            if (type == 3) {
                                if (classpathEntry.getPath().toString().startsWith(projectName)) {
                                    bootClassPath = String.valueOf(bootClassPath) + workspaceLocation;
                                }
                                bootClassPath = String.valueOf(bootClassPath) + classpathEntry.getPath().toString() + pathSeparator;
                                logMessage = String.valueOf(logMessage) + "Source  Path:" + classpathEntry.getPath().toString();
                            } else if (type == 1) {
                                if (classpathEntry.getPath().toString().startsWith(projectName)) {
                                    bootClassPath = String.valueOf(bootClassPath) + workspaceLocation;
                                }
                                bootClassPath = String.valueOf(bootClassPath) + classpathEntry.getPath().toString() + pathSeparator;
                                logMessage = String.valueOf(logMessage) + "Library  Path:" + classpathEntry.getPath().toString();
                            } else {
                                if (type == 2) {
                                    IProject dependentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(classpathEntry.getPath().toString().substring(1));
                                    IJavaProject dependentJavaProject = JavaCore.create((IProject)dependentProject.getProject());
                                    try {
                                        bootClassPath = String.valueOf(bootClassPath) + workspaceLocation + dependentJavaProject.getOutputLocation().toString() + pathSeparator;
                                        logMessage = String.valueOf(logMessage) + "Project  Path:" + dependentJavaProject.getOutputLocation().toString();
                                        break block38;
                                    }
                                    catch (JavaModelException e) {
                                        Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._33, (Throwable)e);
                                        ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                                        break block39;
                                    }
                                }
                                if (type == 4) {
                                    if (classpathEntry.getPath().toString().startsWith(projectName)) {
                                        bootClassPath = String.valueOf(bootClassPath) + workspaceLocation;
                                    }
                                    bootClassPath = String.valueOf(bootClassPath) + JavaCore.getClasspathVariable((String)classpathEntry.getPath().toString()).toString() + pathSeparator;
                                    logMessage = String.valueOf(logMessage) + "Variable  Path:" + JavaCore.getClasspathVariable((String)classpathEntry.getPath().toString()).toString();
                                } else if (type == 5) {
                                    String logContainerContent = "";
                                    String containerName = classpathEntry.getPath().toString();
                                    if (containerName.indexOf("JRE_CONTAINER") != -1) {
                                        logMessage = String.valueOf(logMessage) + "Container " + containerName + " is being ignored";
                                    } else {
                                        IClasspathEntry[] containerContent;
                                        try {
                                            containerContent = JavaCore.getClasspathContainer((IPath)classpathEntry.getPath(), (IJavaProject)javaProject).getClasspathEntries();
                                        }
                                        catch (JavaModelException e) {
                                            Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._32, (Throwable)e);
                                            ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                                            break block39;
                                        }
                                        int k = 0;
                                        while (k < containerContent.length) {
                                            classpathEntry = containerContent[k];
                                            type = classpathEntry.getEntryKind();
                                            if (type == 3 || type == 1 || type == 2) {
                                                if (classpathEntry.getPath().toString().startsWith(projectName)) {
                                                    bootClassPath = String.valueOf(bootClassPath) + workspaceLocation;
                                                }
                                                bootClassPath = String.valueOf(bootClassPath) + classpathEntry.getPath().toString() + pathSeparator;
                                                logContainerContent = String.valueOf(logContainerContent) + classpathEntry.getPath().toString() + pathSeparator;
                                            } else {
                                                String message = NLS.bind((String)ProbekitLaunchMessages._34, (Object)new Integer(type));
                                                Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
                                                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                                            }
                                            ++k;
                                        }
                                        logMessage = String.valueOf(logMessage) + "Container  Name:" + containerName + "  Path:" + logContainerContent;
                                    }
                                }
                            }
                        }
                        if (log) {
                            Status status = new Status(1, "org.eclipse.tptp.platform.probekit.launch", 0, logMessage, null);
                            ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                        }
                    }
                    ++i;
                }
            }
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
                bootClassPath = String.valueOf(bootClassPath) + "\"";
            }
            String osgiProperty = "-Dorg.osgi.framework.bootdelegation=\"*\"";
            if (log) {
                String message = NLS.bind((String)ProbekitLaunchMessages._35, (Object)bootClassPath);
                Status status = new Status(1, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
            }
            vmArgument = String.valueOf(bootClassPath) + " " + osgiProperty;
            return vmArgument;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Map getActiveProbes(ILaunchConfiguration launchConfig) throws CoreException {
        String strProbeDeployPrefix = "org.eclipse.tptp.platform.probekit.Probespec.PROBEUI";
        Map activeProbes = launchConfig.getAttributes();
        Map map = this.filterAttributes(launchConfig, strProbeDeployPrefix, activeProbes);
        return map;
    }

    protected Map filterAttributes(ILaunchConfiguration launchConfig, String strPrefix, Map fullSet) {
        HashMap filteredSet = new HashMap();
        Set values = fullSet.keySet();
        for (Object key : values) {
            String value;
            String probeKey;
            if (!(key instanceof String) || (probeKey = (String)key) == null || !probeKey.startsWith(strPrefix) || (value = (String)fullSet.get(key)).equals(" ")) continue;
            filteredSet.put(key, value);
        }
        return filteredSet;
    }
}

