/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.CustomResourceTreeAndListGroup;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.Messages;
import org.eclipse.ui.dialogs.TypeFilteringDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class CustomWizardExportResourcesPage
extends WizardDataTransferPage {
    private IStructuredSelection initialResourceSelection;
    private List selectedTypes = new ArrayList();
    private CustomResourceTreeAndListGroup resourceGroup;
    private static final String PROBEKIT_EXPORT_SOURCE_MASK = "probe";

    protected CustomWizardExportResourcesPage(String pageName, IStructuredSelection currentSelection) {
        super(pageName);
        this.initialResourceSelection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.initialResourceSelection = new StructuredSelection(selectedResources);
        }
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createResourcesGroup(composite);
        this.createButtonsGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.initialResourceSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.updateWidgetEnablements();
        this.setControl((Control)composite);
    }

    protected abstract void createDestinationGroup(Composite var1);

    protected final void createResourcesGroup(Composite parent) {
        ArrayList<IProject> input = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                input.add(projects[i]);
            }
            ++i;
        }
        this.resourceGroup = new CustomResourceTreeAndListGroup(parent, input, this.getResourceProvider(6), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, true);
        Table table = this.resourceGroup.getListTable();
        table.addListener(24, (Listener)this);
        table.addListener(13, (Listener)this);
        Tree tree = this.resourceGroup.getTree();
        tree.addListener(24, (Listener)this);
        tree.addListener(13, (Listener)this);
    }

    protected void giveFocusToSource() {
        Table table;
        if (this.resourceGroup != null && (table = this.resourceGroup.getListTable()) != null && !table.isDisposed()) {
            table.setFocus();
        }
    }

    protected void giveFocusToTree() {
        if (this.resourceGroup != null) {
            this.resourceGroup.setFocus();
        }
    }

    protected String getErrorDialogTitle() {
        return Messages.ErrorDialogTitle;
    }

    protected boolean ensureResourcesLocal(List resources) {
        return true;
    }

    protected List extractNonLocalResources(List originalList) {
        Vector<IResource> result = new Vector<IResource>(originalList.size());
        for (IResource currentResource : originalList) {
            if (currentResource.isLocal(0)) continue;
            result.addElement(currentResource);
        }
        return result;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            /*
             * Unable to fully structure code
             */
            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException v0) {
                        return new Object[0];
                    }
                    results = new ArrayList<IResource>();
                    i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0) {
                            if (members[i].getType() == 1) {
                                if (members[i].getFileExtension().equals("probe")) {
                                    results.add(members[i]);
                                }
                            } else {
                                results.add(members[i]);
                            }
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    containers = new IResource[((ArrayList)o).size()];
                    try {
                        objs = ((ArrayList)o).toArray();
                        n = 0;
                        while (n < objs.length) {
                            if (objs[n] instanceof IContainer) {
                                containers[n] = (IResource)objs[n];
                            }
                            ++n;
                        }
                    }
                    catch (Exception v1) {
                        return ((ArrayList)o).toArray();
                    }
                    results = new ArrayList<IResource>();
                    i = 0;
                    while (i < containers.length) {
                        if (containers[i] != null && containers[i].getType() == 4) {
                            proj = (IProject)containers[i];
                            try {
                                if (!proj.hasNature("org.eclipse.hyades.probekit.probekitnature")) ** GOTO lbl49
                                results.add(containers[i]);
                            }
                            catch (CoreException v2) {
                                return ((ArrayList)o).toArray();
                            }
                        } else {
                            results.add(containers[i]);
                        }
lbl49:
                        // 3 sources

                        ++i;
                    }
                    return results.toArray();
                }
                return new Object[0];
            }
        };
    }

    protected List getSelectedResources() {
        Iterator resourcesToExportIterator = this.getSelectedResourcesIterator();
        ArrayList resourcesToExport = new ArrayList();
        while (resourcesToExportIterator.hasNext()) {
            resourcesToExport.add(resourcesToExportIterator.next());
        }
        return resourcesToExport;
    }

    protected List getCurrentSelection() {
        ArrayList<String> resourcesToExport = new ArrayList<String>();
        Table table = this.resourceGroup.getListTable();
        TableItem[] items = table.getSelection();
        if (items.length > 0) {
            resourcesToExport.add(items[0].getText());
        }
        return resourcesToExport;
    }

    protected List getCurrentResourceSelection() {
        ArrayList<Object> resourcesToExport = new ArrayList<Object>();
        Table table = this.resourceGroup.getListTable();
        TableItem[] items = table.getSelection();
        if (items.length > 0) {
            resourcesToExport.add(items[0].getData());
        }
        return resourcesToExport;
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.resourceGroup.getAllCheckedListItems().iterator();
    }

    protected List getTypesToExport() {
        return this.selectedTypes;
    }

    protected List getWhiteCheckedResources() {
        return this.resourceGroup.getAllWhiteCheckedItems();
    }

    protected void handleTypesEditButtonPressed() {
        Object[] newSelectedTypes = this.queryResourceTypesToExport();
        if (newSelectedTypes != null) {
            this.selectedTypes = new ArrayList(newSelectedTypes.length);
            int i = 0;
            while (i < newSelectedTypes.length) {
                this.selectedTypes.add(newSelectedTypes[i]);
                ++i;
            }
            this.setupSelectionsBasedOnSelectedTypes();
        }
    }

    protected boolean hasExportableExtension(String resourceName) {
        if (this.selectedTypes == null) {
            return true;
        }
        int separatorIndex = resourceName.lastIndexOf(".");
        if (separatorIndex == -1) {
            return false;
        }
        String extension = resourceName.substring(separatorIndex + 1);
        Iterator enum1 = this.selectedTypes.iterator();
        while (enum1.hasNext()) {
            if (!extension.equalsIgnoreCase((String)enum1.next())) continue;
            return true;
        }
        return false;
    }

    protected void internalSaveWidgetValues() {
    }

    protected Object[] queryResourceTypesToExport() {
        TypeFilteringDialog dialog = new TypeFilteringDialog(this.getContainer().getShell(), (Collection)this.getTypesToExport());
        dialog.open();
        return dialog.getResult();
    }

    protected void restoreResourceSpecificationWidgetValues() {
    }

    protected void saveWidgetValues() {
        this.internalSaveWidgetValues();
    }

    protected void setupBasedOnInitialSelections() {
        for (Object obj : this.initialResourceSelection) {
            if (!(obj instanceof IResource)) continue;
            IResource currentResource = (IResource)obj;
            if (currentResource.getType() == 1) {
                this.resourceGroup.initialCheckListItem(currentResource);
                continue;
            }
            this.resourceGroup.initialCheckTreeItem(currentResource);
        }
    }

    private void setupSelectionsBasedOnSelectedTypes() {
        Runnable runnable = new Runnable(){

            public void run() {
                Hashtable selectionMap = new Hashtable();
                for (IResource resource : CustomWizardExportResourcesPage.this.resourceGroup.getAllWhiteCheckedItems()) {
                    if (resource.getType() == 1) {
                        if (!CustomWizardExportResourcesPage.this.hasExportableExtension(resource.getName())) continue;
                        List<Object> resourceList = new ArrayList<IResource>();
                        IContainer parent = resource.getParent();
                        if (selectionMap.containsKey(parent)) {
                            resourceList = (List)selectionMap.get(parent);
                        }
                        resourceList.add(resource);
                        selectionMap.put(parent, resourceList);
                        continue;
                    }
                    CustomWizardExportResourcesPage.this.setupSelectionsBasedOnSelectedTypes(selectionMap, (IContainer)resource);
                }
                CustomWizardExportResourcesPage.this.resourceGroup.updateSelections(selectionMap);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
    }

    private void setupSelectionsBasedOnSelectedTypes(Map selectionMap, IContainer parent) {
        IResource[] resources;
        ArrayList<IResource> selections = new ArrayList<IResource>();
        boolean hasFiles = false;
        try {
            resources = parent.members();
        }
        catch (CoreException coreException) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1) {
                if (this.hasExportableExtension(resource.getName())) {
                    hasFiles = true;
                    selections.add(resource);
                }
            } else {
                this.setupSelectionsBasedOnSelectedTypes(selectionMap, (IContainer)resource);
            }
            ++i;
        }
        if (hasFiles) {
            selectionMap.put(parent, selections);
        }
    }

    protected boolean saveDirtyEditors() {
        return ProbekitLaunchPlugin.getDefault().getWorkbench().saveAllEditors(true);
    }
}

