/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.CustomWizardExportResourcesPage;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.Messages;

public class CustomWizardFileSystemResourceExportPage1
extends CustomWizardExportResourcesPage
implements Listener {
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    protected Button overwriteExistingFilesCheckbox;
    protected Button createDirectoryStructureButton;
    protected Button createSelectionOnlyButton;
    private static final String FILE_EXPORT_MASK = "*.probekit";
    protected static final String SOURCE_EMPTY_MESSAGE = Messages.SourceEmpty;
    protected static final String DESTINATION_EMPTY_MESSAGE = Messages.DestinationEmpty;

    protected CustomWizardFileSystemResourceExportPage1(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.giveFocusToDestination();
    }

    protected void createDestinationGroup(Composite parent) {
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(this.getDestinationLabel());
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(Messages.DestinationBrowseButton);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(parent, 0);
    }

    protected boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            if (!this.queryYesNoQuestion(Messages.CreateTargetDirectory)) {
                return false;
            }
            if (!directory.mkdirs()) {
                this.displayErrorDialog(Messages.DirectoryCreationError);
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File targetDirectory) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            this.displayErrorDialog(Messages.DirectoryExists);
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(targetDirectory);
    }

    protected String getDestinationLabel() {
        return Messages.ToDirectory;
    }

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String strMessage = this.getMessage();
            if (strMessage != null) {
                if (strMessage.equals(SOURCE_EMPTY_MESSAGE)) {
                    this.giveFocusToSource();
                } else if (strMessage.equals(DESTINATION_EMPTY_MESSAGE)) {
                    this.giveFocusToDestination();
                } else {
                    this.giveFocusToTree();
                }
            } else {
                this.giveFocusToDestination();
            }
        }
    }

    protected void handleDestinationBrowseButtonPressed() {
        String strCurrentDestination;
        String selectedFile = this.queryZipFileToExport();
        if (selectedFile != null && !selectedFile.equals(strCurrentDestination = this.destinationNameField.getText())) {
            this.setDestinationValue(selectedFile);
        }
    }

    protected String queryZipFileToExport() {
        FileDialog dialog = new FileDialog(this.destinationNameField.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{FILE_EXPORT_MASK});
        dialog.setText(Messages.FileDialogText);
        String currentSourceString = this.destinationNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (event.type == 13 && source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updateWidgetEnablements();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.length() == 0) {
            this.setMessage(this.destinationEmptyMessage());
            return false;
        }
        String conflictingContainer = this.getConflictingContainerNameFor(destinationValue);
        if (conflictingContainer != null) {
            this.setErrorMessage(NLS.bind((String)Messages.ConflictingContainer, (Object[])new Object[]{conflictingContainer}));
            this.giveFocusToDestination();
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected String destinationEmptyMessage() {
        return DESTINATION_EMPTY_MESSAGE;
    }

    protected String getConflictingContainerNameFor(String targetDirectory) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path testPath = new Path(targetDirectory);
        if (root.getLocation().isPrefixOf((IPath)testPath)) {
            return Messages.RootName;
        }
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getLocation().isPrefixOf((IPath)testPath)) {
                return projects[i].getName();
            }
            ++i;
        }
        return null;
    }

    protected boolean validateSourceGroup() {
        List resourcesToExport = this.getCurrentSelection();
        if (resourcesToExport.size() <= 0) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            return false;
        }
        return true;
    }
}

