/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import java.io.File;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.CustomWizardResourceImportPage;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.Messages;
import org.eclipse.ui.IWorkbench;

class CustomWizardFileSystemResourceImportPage1
extends CustomWizardResourceImportPage {
    protected Combo sourceNameField;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button sourceBrowseButton;
    private boolean entryChanged = false;

    protected CustomWizardFileSystemResourceImportPage1(String name, IWorkbench aWorkbench, IStructuredSelection selection) {
        super(name, selection);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(this.getSourceLabel());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        this.sourceNameField.addListener(24, (Listener)this);
        this.sourceNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomWizardFileSystemResourceImportPage1.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CustomWizardFileSystemResourceImportPage1.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (CustomWizardFileSystemResourceImportPage1.this.entryChanged) {
                    CustomWizardFileSystemResourceImportPage1.this.entryChanged = false;
                    CustomWizardFileSystemResourceImportPage1.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(Messages.BrowseButton);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.setButtonLayoutData(this.sourceBrowseButton);
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
    }

    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
    }

    protected File getSourceFile() {
        return this.getSourceFile(this.sourceNameField.getText());
    }

    private File getSourceFile(String path) {
        File sourceFile = new File(path);
        if (!sourceFile.exists() || !sourceFile.isFile()) {
            return null;
        }
        return sourceFile;
    }

    protected String getSourceLabel() {
        return "";
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.sourceNameField.setFocus();
        }
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
    }
}

