/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.CustomWizardFileSystemResourceImportPage1;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.IProbekitUIHelpContextIDs;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.Messages;
import org.eclipse.tptp.platform.probekit.registry.CandidateEntry;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistry;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryException;
import org.eclipse.tptp.platform.probekit.util.InvalidProbeBundleException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

class ImportProbeWizardPage
extends CustomWizardFileSystemResourceImportPage1
implements Listener {
    private static final String FILE_IMPORT_MASK = "*.probekit";
    private static final String FILE_IMPORT_EXTENSION = ".probekit";
    protected static final String SOURCE_EMPTY_MESSAGE = Messages.ISourceEmpty;
    private static final String STORE_SOURCE_NAMES_ID = "ImportProbeWizardPage.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "ImportProbeWizardPage.STORE_OVERWRITE_EXISTING_RESOURCES_ID";

    public ImportProbeWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super(Messages.IPageName, aWorkbench, selection);
        this.setTitle(Messages.PageTitle);
        this.setDescription(Messages.Description);
    }

    public boolean cancel() {
        return true;
    }

    protected boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException e) {
            this.displayErrorDialog(e);
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IProbekitUIHelpContextIDs.IMPORT_PROBE_WIZARD_PAGE);
    }

    protected void createOptionsGroup(Composite parent) {
        this.overwriteExistingResourcesCheckbox = new Button(parent, 32);
        this.overwriteExistingResourcesCheckbox.setText(Messages.OverwriteWarningCheckbox);
    }

    protected boolean ensureSourceIsValid() {
        ZipFile specifiedFile = this.getSpecifiedSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return this.closeZipFile(specifiedFile);
    }

    public boolean finish() {
        block22: {
            String strSource;
            if (!this.ensureSourceIsValid()) {
                return false;
            }
            ProbeRegistry registry = ProbeRegistry.getRegistry();
            if (registry != null && (strSource = this.sourceNameField.getText()) != null && strSource.length() > 0) {
                CandidateEntry candidate;
                String strLineSeparator;
                block23: {
                    ProbeRegistryEntry conflict;
                    strLineSeparator = System.getProperty("line.separator");
                    candidate = registry.addIfNoConflict(strSource);
                    if (candidate == null || (conflict = candidate.getConflict()) == null) break block22;
                    if (this.overwriteExistingResourcesCheckbox.getSelection()) break block23;
                    String strConflicts = "";
                    int iConflictDetails = candidate.getFlags();
                    if ((iConflictDetails & 4) != 0) {
                        strConflicts = String.valueOf(Messages.WarningProbeExists) + strLineSeparator;
                    }
                    strConflicts = (iConflictDetails & 1) != 0 ? ((iConflictDetails & 2) != 0 ? String.valueOf(strConflicts) + Messages.WarningOlderVersion + strLineSeparator : String.valueOf(strConflicts) + Messages.WarningNewerVersion + strLineSeparator) : String.valueOf(strConflicts) + Messages.WarningSameVersion + strLineSeparator;
                    String strMessage = String.valueOf(Messages.WarningVersionConflict) + strLineSeparator + strLineSeparator;
                    strMessage = String.valueOf(strMessage) + strConflicts + strLineSeparator + Messages.WarningOverwriteConfirm;
                    boolean bOk = MessageDialog.openConfirm((Shell)this.getContainer().getShell(), (String)Messages.WarningTitle, (String)strMessage);
                    if (bOk) {
                        registry.commit(candidate);
                        break block22;
                    }
                    registry.discard(candidate);
                    return false;
                }
                try {
                    registry.commit(candidate);
                }
                catch (ProbeRegistryException probeRegistryException) {
                    this.displayErrorDialog(Messages.ProbeRegistryException);
                    this.sourceNameField.setFocus();
                    return false;
                }
                catch (InvalidProbeBundleException exc) {
                    String strMessage = NLS.bind((String)Messages.ErrorImporting, (Object)strSource);
                    strMessage = String.valueOf(strMessage) + strLineSeparator;
                    String strReason = "";
                    if (exc.testReason(1)) {
                        if (exc.testReason(17)) {
                            strReason = String.valueOf(strReason) + Messages.ModelFileMissing + strLineSeparator;
                        }
                        if (exc.testReason(33)) {
                            strReason = String.valueOf(strReason) + Messages.ScriptFileMissing + strLineSeparator;
                        }
                        if (exc.testReason(65)) {
                            strReason = String.valueOf(strReason) + Messages.SupportFileMissing + strLineSeparator;
                        }
                        if (strReason.length() == 0) {
                            strReason = String.valueOf(Messages.FileMissingError) + strLineSeparator;
                        }
                    }
                    if (exc.testReason(2)) {
                        if (exc.testReason(18)) {
                            strReason = String.valueOf(strReason) + Messages.ModelFileInaccessible + strLineSeparator;
                        }
                        if (exc.testReason(34)) {
                            strReason = String.valueOf(strReason) + Messages.ScriptFileInaccessible + strLineSeparator;
                        }
                        if (exc.testReason(66)) {
                            strReason = String.valueOf(strReason) + Messages.SupportFileInaccessible + strLineSeparator;
                        }
                        if (strReason.length() == 0) {
                            strReason = String.valueOf(Messages.FileInaccessibleError) + strLineSeparator;
                        }
                    }
                    if (exc.testReason(8)) {
                        strReason = String.valueOf(strReason) + Messages.InvalidModelError + strLineSeparator;
                    }
                    if (exc.testReason(4)) {
                        String strExtension = exc.getExtension();
                        strReason = String.valueOf(strReason) + NLS.bind((String)Messages.TooManyFiles, (Object)strExtension) + strLineSeparator;
                    }
                    String strErrorMessage = String.valueOf(strMessage) + strReason;
                    this.displayErrorDialog(strErrorMessage);
                    this.sourceNameField.setFocus();
                    return false;
                }
                catch (IOException e) {
                    this.displayErrorDialog(e);
                    this.sourceNameField.setFocus();
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String strTitle = Messages.ErrorDialogTitle;
                    String strMessage = Messages.InternalError;
                    ProbekitLaunchPlugin.reportException(e, strTitle, strMessage);
                    return false;
                }
            }
        }
        this.saveWidgetValues();
        return true;
    }

    protected void displayErrorDialog(String message) {
        MessageBox mbox = new MessageBox(this.getContainer().getShell(), 33);
        mbox.setMessage(message);
        mbox.setText(this.getErrorDialogTitle());
        mbox.open();
    }

    protected String getSourceLabel() {
        return Messages.SourceLabel;
    }

    protected ZipFile getSpecifiedSourceFile() {
        return this.getSpecifiedSourceFile(this.sourceNameField.getText());
    }

    private ZipFile getSpecifiedSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException e) {
            this.displayErrorDialog(e);
        }
        catch (IOException e) {
            this.displayErrorDialog(e);
        }
        this.sourceNameField.setFocus();
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    protected void handleSourceBrowseButtonPressed() {
        ZipFile sourceFile;
        String selectedFile = this.queryZipFileToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText()) && (sourceFile = this.getSpecifiedSourceFile(selectedFile)) != null) {
            this.closeZipFile(sourceFile);
            this.setSourceName(selectedFile);
        }
    }

    protected String queryZipFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        dialog.setText(Messages.QueryFileDialogTitle);
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceNameField.getText());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
        }
    }

    protected boolean validateSourceGroup() {
        File sourceFile = this.getSourceFile();
        if (sourceFile == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            return false;
        }
        String strExtension = this.getInputSuffix();
        String strFileName = sourceFile.getName();
        return strFileName.endsWith(strExtension);
    }

    protected String getInputSuffix() {
        return FILE_IMPORT_EXTENSION;
    }
}

