/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.launchpad;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.internal.core.TraceFilterManager;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.execution.util.ICommandElement;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.CustomBase64Encoder;
import org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPadException;
import org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPadUtils;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistry;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;
import org.eclipse.tptp.platform.probekit.util.InvalidProbeBundleException;
import org.eclipse.tptp.platform.probekit.util.ProbeLaunchConfigString;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;

public class LaunchPadJVMTI {
    private ICollector agent;
    private Vector filters = new Vector();
    private static final String ENCODING_NAME_UTF8 = "UTF-8";
    private static final String OPCODE_PROBE = "PROBE";
    private static final String OPCODE_RULE = "RULE";
    private static final String OPCODE_RULE_WITH_BLANK = "RULE ";
    private static final String OPCODE_FILTER_WITH_BLANK = "FILTER ";
    private static final String ATTR_FILTER_SET_ID = "org.eclipse.tptp.platform.jvmti.client.ATTR_FILTERSET_ID";

    public void agentActive(ICollector currentAgent, ILaunchConfiguration config) throws CoreException, LaunchPadException {
        String[] rules = new String[1000];
        this.agent = currentAgent;
        Vector<ProbeRegistryEntry> registryEntries = new Vector<ProbeRegistryEntry>();
        if (this.agent == null) {
            throw new LaunchPadException("Agent not found");
        }
        ProbeRegistry registry = ProbeRegistry.getRegistry();
        Map m = config.getAttributes();
        String key2 = " ";
        Set keys = m.keySet();
        for (String key2 : keys) {
            String probeID;
            ProbeRegistryEntry registryEntry;
            Object value = m.get(key2);
            if (!key2.startsWith("org.eclipse.tptp.platform.probekit.Probespec.") && !value.equals(" ") || value.equals(" ")) continue;
            ProbeLaunchConfigString probeConfig = ProbeLaunchConfigString.fromString((String)value.toString());
            String defaultFilterSet = " ";
            defaultFilterSet = !LauncherUtility.isAutoFilteringCriteria((ILaunchConfiguration)config) ? "org.eclipse.hyades.trace.ui.filterSet.default" : "auto_generated_filter_set";
            String filterSetId = config.getAttribute(ATTR_FILTER_SET_ID, defaultFilterSet);
            FilterSetElement filterSet = (FilterSetElement)TraceFilterManager.getInstance().getFilterSet().get(filterSetId);
            ArrayList filters = filterSet.getChildren();
            String probeFilters = this.processDefaultFilters(filters);
            rules = this.translateFilters(probeFilters, OPCODE_FILTER_WITH_BLANK);
            this.clearFilters();
            int i = 0;
            while (i < rules.length) {
                this.addFilter(rules[i]);
                ++i;
            }
            if (probeConfig.getType() != 1 || (registryEntry = registry.lookupById(probeID = probeConfig.getRegistryId())) == null) continue;
            registryEntries.add(registryEntry);
            this.deployProbes(registryEntry, registryEntries.size() - 1);
        }
    }

    private String[] translateFilters(String filterString, String prefix) {
        if (filterString == null) {
            return new String[0];
        }
        if (filterString.endsWith("&")) {
            filterString = filterString.substring(0, filterString.length() - 1);
        }
        String[] filters = filterString.split("[&]");
        Vector<String> rules = new Vector<String>();
        int n = 0;
        while (n < filters.length) {
            StringBuffer rule = new StringBuffer(prefix);
            rule.append(' ');
            String tokenPackage1 = ".";
            String tokenPackage2 = null;
            String tokenClass1 = "*";
            String tokenClass2 = null;
            String tokenMethod = "*";
            String tokenSignature = "*";
            String tokenAction = "EXCLUDE";
            String[] tokens = filters[n].split("[:]");
            int t = 0;
            while (t < tokens.length) {
                String token = tokens[t];
                if (token.compareTo("INCLUDE") == 0 || token.compareTo("EXCLUDE") == 0) {
                    tokenAction = token;
                    break;
                }
                switch (t) {
                    case 0: {
                        int indDot = token.lastIndexOf(46);
                        int indStar = token.indexOf(42);
                        if (indDot != -1) {
                            tokenPackage1 = token.substring(0, indDot);
                            tokenClass1 = token.substring(indDot + 1);
                            if (!token.endsWith("*")) break;
                            tokenPackage2 = token;
                            tokenClass2 = "*";
                            break;
                        }
                        if (indStar != -1) {
                            if (token.startsWith("*")) {
                                if (token.length() > 1 && token.endsWith("*")) {
                                    tokenPackage1 = token;
                                    tokenClass1 = "*";
                                    tokenPackage2 = "*";
                                    tokenClass2 = token;
                                    break;
                                }
                                tokenPackage1 = "*";
                                tokenClass1 = token;
                                break;
                            }
                            tokenPackage1 = token;
                            tokenClass1 = "*";
                            tokenPackage2 = ".";
                            tokenClass2 = token;
                            break;
                        }
                        if (indStar != -1 || indDot != -1) break;
                        tokenClass1 = token;
                        break;
                    }
                    case 1: {
                        tokenMethod = token;
                        break;
                    }
                    case 2: {
                        tokenSignature = token;
                        break;
                    }
                }
                ++t;
            }
            rule.append(tokenPackage1);
            rule.append(' ');
            rule.append(tokenClass1);
            rule.append(' ');
            rule.append(tokenMethod);
            rule.append(' ');
            rule.append(tokenSignature);
            rule.append(' ');
            rule.append(tokenAction);
            rules.add(rule.toString());
            if (tokenPackage2 != null) {
                rule = new StringBuffer(prefix);
                rule.append(' ');
                rule.append(tokenPackage2);
                rule.append(' ');
                rule.append(tokenClass2);
                rule.append(' ');
                rule.append(tokenMethod);
                rule.append(' ');
                rule.append(tokenSignature);
                rule.append(' ');
                rule.append(tokenAction);
                rules.add(rule.toString());
            }
            ++n;
        }
        String[] rulesOut = new String[rules.size()];
        int i = 0;
        while (i < rulesOut.length) {
            rulesOut[i] = (String)rules.get(i);
            ++i;
        }
        return rulesOut;
    }

    private String processDefaultFilters(ArrayList configFilters) {
        Iterator itrFilters = configFilters.iterator();
        StringBuffer newFilter = new StringBuffer();
        boolean insertDelimiter = false;
        while (itrFilters.hasNext()) {
            FilterTableElement configFilter = (FilterTableElement)itrFilters.next();
            String className = configFilter.getText();
            String methodName = configFilter.getMethod();
            String action = configFilter.getVisibility();
            boolean active = true;
            if (!active) continue;
            if (insertDelimiter) {
                newFilter.append('&');
            }
            newFilter.append(className);
            newFilter.append(':');
            newFilter.append(methodName);
            newFilter.append(':');
            newFilter.append(action);
            insertDelimiter = true;
        }
        return newFilter.toString();
    }

    public void deployProbes(ProbeRegistryEntry probeRegistryEntry, int probeNumber) throws LaunchPadException {
        try {
            Vector<String> classPathVector = new Vector<String>();
            File probeScript = probeRegistryEntry.getProbescript();
            File[] probeFiles = probeRegistryEntry.getFiles();
            String probeScriptPath = probeScript.getAbsolutePath();
            classPathVector.add(probeScriptPath);
            int j = 0;
            while (j < probeFiles.length) {
                if (LaunchPadUtils.isClass(probeFiles[j])) {
                    String filePath = probeFiles[j].getAbsolutePath();
                    classPathVector.add(filePath);
                }
                ++j;
            }
            this.prepareFileArrays(classPathVector.toArray(), this.agent, probeNumber);
        }
        catch (InvalidProbeBundleException invalidProbeBundleException) {
            LaunchPadUtils.trace("InvalidProbeBundleException in deployProbe()");
            throw new LaunchPadException("Invalid registry entry");
        }
    }

    public void prepareFileArrays(Object[] probeClassPath, ICollector agent, int probeNumber) throws LaunchPadException {
        try {
            Vector<String> classNames = new Vector<String>();
            Vector<byte[]> bytes = new Vector<byte[]>();
            int i = 0;
            while (i < probeClassPath.length) {
                String path = (String)probeClassPath[i];
                if (path.endsWith(".probescript")) {
                    File scriptf = new File(path);
                    byte[] script = this.weaveFilters(LaunchPadUtils.readFileIntoBuffer(scriptf));
                    classNames.add(scriptf.getName());
                    bytes.add(script);
                } else if (probeClassPath[i] instanceof String) {
                    String classPath = (String)probeClassPath[i];
                    File f = new File(classPath);
                    classNames.add(f.getName());
                    bytes.add(LaunchPadUtils.readFileIntoBuffer(f));
                }
                ++i;
            }
            LaunchPadJVMTI.deployProbeClasses(bytes, classNames, (IAgent)agent, probeNumber);
        }
        catch (FileNotFoundException e) {
            LaunchPadUtils.trace("FileNotFound in LaunchPadJVMTI");
            throw new LaunchPadException(e);
        }
        catch (IOException e) {
            LaunchPadUtils.trace("IOException in LaunchPadJVMTI");
            throw new LaunchPadException(e);
        }
    }

    public static void deployProbeClasses(Vector bytes, Vector classNames, IAgent agent, int probeNumber) throws LaunchPadException {
        try {
            int count = 4;
            int i = 0;
            while (i < bytes.size()) {
                String className = (String)classNames.get(i);
                byte[] classBytes = (byte[])bytes.get(i);
                byte[] classNameBytes = className.getBytes(ENCODING_NAME_UTF8);
                count += 4 + classNameBytes.length + 4 + classBytes.length;
                ++i;
            }
            ByteBuffer buffer = ByteBuffer.allocate(count);
            buffer.putInt(-557126464);
            int i2 = 0;
            while (i2 < bytes.size()) {
                String className = (String)classNames.get(i2);
                byte[] classBytes = (byte[])bytes.get(i2);
                byte[] classNameBytes = className.getBytes(ENCODING_NAME_UTF8);
                buffer.putInt(classNameBytes.length).put(classNameBytes);
                buffer.putInt(classBytes.length).put(classBytes);
                ++i2;
            }
            new CustomBase64Encoder();
            String commandData = CustomBase64Encoder.encode(buffer.array());
            CommandFragment command = new CommandFragment();
            command.setCommand("<applyOptions iid='org.eclipse.tptp.jvmti'><option><name>PROBEKIT_DATA_" + String.valueOf(probeNumber) + "</name>" + "<value>" + commandData + "</value></option></applyOptions>");
            agent.sendCommand(command.buildCommand(), new ICommandHandler(){

                public void incomingCommand(INode node, ICommandElement element) {
                }
            });
        }
        catch (InactiveAgentException e) {
            LaunchPadUtils.trace("InactiveAgentException in LaunchPadJVMTI");
            throw new LaunchPadException(e);
        }
        catch (NotConnectedException e) {
            LaunchPadUtils.trace("NotConnectedException in LaunchPadJVMTI");
            throw new LaunchPadException(e);
        }
        catch (UnsupportedEncodingException e) {
            LaunchPadUtils.trace("UnsupportedEncodingException in LaunchPadJVMTI");
            throw new LaunchPadException(e);
        }
    }

    private byte[] weaveFilters(byte[] script) throws UnsupportedEncodingException {
        if (this.filters.size() == 0) {
            return script;
        }
        String[] probescriptAsStrings = this.convertBytesToStrings(script);
        boolean seenAnyProbeLinesYet = false;
        boolean seenAnyRulesYet = false;
        Vector<String> newProbescriptStringVector = new Vector<String>();
        Vector filtersAsRules = this.createRulesStringVector();
        int i = 0;
        while (i < probescriptAsStrings.length) {
            String opcode = this.getFirstWord(probescriptAsStrings[i]);
            if (opcode.equalsIgnoreCase(OPCODE_PROBE)) {
                if (seenAnyProbeLinesYet && !seenAnyRulesYet) {
                    newProbescriptStringVector.addAll(filtersAsRules);
                }
                seenAnyProbeLinesYet = true;
                seenAnyRulesYet = false;
            } else if (opcode.equalsIgnoreCase(OPCODE_RULE)) {
                seenAnyRulesYet = true;
            }
            newProbescriptStringVector.add(probescriptAsStrings[i]);
            ++i;
        }
        if (seenAnyProbeLinesYet && !seenAnyRulesYet) {
            newProbescriptStringVector.addAll(filtersAsRules);
        }
        newProbescriptStringVector.addAll(this.filters);
        Iterator itr = newProbescriptStringVector.iterator();
        int size = 0;
        while (itr.hasNext()) {
            String next = (String)itr.next();
            size += next.getBytes(ENCODING_NAME_UTF8).length + 1;
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        for (String next : newProbescriptStringVector) {
            buf.put(next.getBytes(ENCODING_NAME_UTF8));
            buf.put((byte)0);
        }
        return buf.array();
    }

    private String[] convertBytesToStrings(byte[] bytes) throws UnsupportedEncodingException {
        String oneBigString = new String(bytes, ENCODING_NAME_UTF8);
        String[] result = oneBigString.split("[\u0000\n\r\u0085\u2028\u2029]");
        return result;
    }

    private Vector createRulesStringVector() {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.filters.size()) {
            String s = (String)this.filters.elementAt(i);
            if (s.startsWith(OPCODE_FILTER_WITH_BLANK)) {
                s = OPCODE_RULE_WITH_BLANK + s.substring(OPCODE_FILTER_WITH_BLANK.length());
            }
            result.add(s);
            ++i;
        }
        return result;
    }

    private String getFirstWord(String input) {
        String[] splitResult = input.trim().split("\\s+", 2);
        return splitResult[0];
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void addFilter(String filterString) {
        this.filters.add(filterString);
    }

    public void setAgent(ICollector agent) {
        this.agent = agent;
    }
}

