/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IiopProfiler.java,v 1.4 2006/04/03 20:25:57 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace;

import org.eclipse.hyades.collection.correlation.BaseApplicationImpl;
import org.eclipse.hyades.collection.correlation.BaseCorrelatorDataImpl;


/**
 * This is the application to collect the trace data.
 * 
 * @author Richard Duggan
 * @author Qiyan Li
 * @author Paul E. Slauenwhite
 */
public class IiopProfiler extends BaseApplicationImpl {

	public static final int VERSION = 1;
	public static final int ID = 10002;
    private static IiopProfiler instance = null;


    /**
     * This creates a singleton profiler.
     */
    public static IiopProfiler getInstance() {
        
        synchronized (IiopProfiler.class) {
            return (instance == null ? instance = new IiopProfiler() : instance);
        }
    }

    
    /**
     * This is the default constructor.
     */
    private IiopProfiler() {
    	//No-operation.
    }
    

	/**
	 * @see org.eclipse.hyades.collection.correlation.BaseApplicationImpl#instantiateCorrelator()
	 */
	public BaseCorrelatorDataImpl instantiateCorrelator() {
		return new TraceCorrelator();
	}


	/**
	 * @see org.eclipse.hyades.collection.correlation.IApplication#getId()
	 */
	public int getId() {
		return ID;
	}


	/**
	 * @see org.eclipse.hyades.collection.correlation.IApplication#getVersion()
	 */
	public int getVersion() {
		return VERSION;
	}
}
