/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadComparator.java,v 1.2 2005/02/25 22:17:10 hleung Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace;

import java.util.Comparator;


/**
 * This is the key to differentiate between different contexts.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class ThreadComparator implements Comparator {
    private int id = Thread.currentThread().hashCode();


    /**
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    public int compare(Object lhs, Object rhs) {
        return ((ThreadComparator) lhs).id - ((ThreadComparator) rhs).id;
    }


    /**
     * @see java.lang.Object#equals(Object)
     */
    public boolean equals(Object obj) {
        return id == ((ThreadComparator) obj).id;
    }
}
