/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceHandler.java,v 1.2 2005/02/25 22:17:10 hleung Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace;

import org.eclipse.hyades.collection.correlation.CorrelatorAssociation;
import org.eclipse.hyades.collection.correlation.IContextHandler;
import org.eclipse.hyades.execution.trace.util.RecordMethodAccess;


/**
 * This is the event hanlder logging all events.
 * 
 * @author Richard Duggan, Qiayn Li
 */
public class TraceHandler implements IContextHandler {
    
    /**
     * The reference to the logger that performs the actually logging
     */
    private TraceLogger logger;


    /**
     * This is the default constructor.
     */
    public TraceHandler() {
        logger = TraceLogger.getInstance();
    }


	/**
	 * @see org.eclipse.hyades.collection.correlation.IContextHandler#handleEntry(org.eclipse.hyades.collection.correlation.CorrelatorAssociation)
	 */
	public void handleEntry(CorrelatorAssociation context) {

        logger.logCorrelator(RecordMethodAccess.METHOD_ENTRY,
            (TraceCorrelator) context.getChild(), (TraceCorrelator) context.getParent());
	}


	/**
	 * @see org.eclipse.hyades.collection.correlation.IContextHandler#handleExit(org.eclipse.hyades.collection.correlation.CorrelatorAssociation)
	 */
	public void handleExit(CorrelatorAssociation context) {

        logger.logCorrelator(RecordMethodAccess.METHOD_EXIT,
            (TraceCorrelator) context.getChild(), (TraceCorrelator) context.getParent());
	}


	/**
	 * @see org.eclipse.hyades.collection.correlation.IContextHandler#handleSend(org.eclipse.hyades.collection.correlation.CorrelatorAssociation)
	 */
	public void handleSend(CorrelatorAssociation context) {

        logger.logCorrelator(RecordMethodAccess.METHOD_CALL,
            (TraceCorrelator) context.getParent(), (TraceCorrelator) context.getChild());
	}


	/**
	 * @see org.eclipse.hyades.collection.correlation.IContextHandler#handleReceive(org.eclipse.hyades.collection.correlation.CorrelatorAssociation)
	 */
    public void handleReceive(CorrelatorAssociation context) {

        logger.logCorrelator(RecordMethodAccess.METHOD_RECEIVE,
            (TraceCorrelator) context.getChild(), (TraceCorrelator) context.getParent());
    }


	/**
	 * @see org.eclipse.hyades.collection.correlation.IContextHandler#handleReply(org.eclipse.hyades.collection.correlation.CorrelatorAssociation)
	 */
	public void handleReply(CorrelatorAssociation context) {

        logger.logCorrelator(RecordMethodAccess.METHOD_REPLY,
            (TraceCorrelator) context.getParent(), (TraceCorrelator) context.getChild());
	}


	/**
	 * @see org.eclipse.hyades.collection.correlation.IContextHandler#handleReturn(org.eclipse.hyades.collection.correlation.CorrelatorAssociation)
	 */
	public void handleReturn(CorrelatorAssociation context) {

        logger.logCorrelator(RecordMethodAccess.METHOD_RETURN,
            (TraceCorrelator) context.getChild(), (TraceCorrelator) context.getParent());
	}
}
