/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecordObjAlloc.java,v 1.2 2005/02/25 22:17:10 hleung Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace.util;


/**
 * This is the record for object creation.  For up-to-date descriptions of the tag attributes,
 * see Event Specification for the Java Profiler at <code>http://www.eclipse.org/hyades</code>.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class RecordObjAlloc {

    /**
     * the number of records to provide a unique object ID
     */
    private static int _numberRecords = 0;

    private int transientThreadIdRef = 0;
    private int threadIdRef = 0;
    private String time = null;
    private int isArray = 0;
    private int transientObjId = 0;
    private final int objId;
    private int size = 0;
    private int transientClassIdRef = 0;
    private int classIdRef = 0;
    private Object context_data = null;
    private String collationValue = null;
    private String traceIdRef = null;


    /**
     * Creates a record for this object with a unique ID.
     */
    public RecordObjAlloc() {

        /* Obtain a unique ID for this object. */
        synchronized (this.getClass()) {
            objId = ++_numberRecords;
        }
    }


    /**
     * Returns this record as a string.
     * 
     * @return  this record as a string
     */
    public String toString() {

        return "<objAlloc objId=\"" + objId + "\"" +
               (transientThreadIdRef == 0 ? "" : " transientThreadIdRef=\"" + transientThreadIdRef + "\"") +
               (threadIdRef == 0 ? "" : " threadIdRef=\"" + threadIdRef + "\"") +
               (time == null ? "" : " time=\"" + time + "\"") +
               (isArray == 0 ? "" : " isArray=\"" + isArray + "\"") +
               (transientObjId == 0 ? "" : " transientObjId=\"" + transientObjId + "\"") +
               (size == 0 ? "" : " size=\"" + size + "\"") +
               (transientClassIdRef == 0 ? "" : " transientClassIdRef=\"" + transientClassIdRef + "\"") +
               (classIdRef == 0 ? "" : " classIdRef=\"" + classIdRef + "\"") +
               (context_data == null ? "" : " context_data=\"" + context_data + "\"") +
               (collationValue == null ? "" : " collationValue=\"" + collationValue + "\"") +
               (traceIdRef == null ? "" : " traceIdRef=\"" + traceIdRef + "\"") + "/>";
    }


    public void setClassIdRef(int classIdRef) {
        this.classIdRef = classIdRef;
    }


    public void setCollationValue(String collationValue) {
        this.collationValue = collationValue;
    }


    public void setContext_data(Object context_data) {
        this.context_data = context_data;
    }


    public void setIsArray(int isArray) {
        this.isArray = isArray;
    }


    public void setSize(int size) {
        this.size = size;
    }


    public void setThreadIdRef(int threadIdRef) {
        this.threadIdRef = threadIdRef;
    }


    public void setTime(String time) {
        this.time = time;
    }


    public void setTraceIdRef(String traceIdRef) {
        this.traceIdRef = traceIdRef;
    }


    public void setTransientClassIdRef(int transientClassIdRef) {
        this.transientClassIdRef = transientClassIdRef;
    }


    public void setTransientObjId(int transientObjId) {
        this.transientObjId = transientObjId;
    }


    public void setTransientThreadIdRef(int transientThreadIdRef) {
        this.transientThreadIdRef = transientThreadIdRef;
    }


    public int getClassIdRef() {
        return classIdRef;
    }


    public String getCollationValue() {
        return collationValue;
    }


    public Object getContext_data() {
        return context_data;
    }


    public int getIsArray() {
        return isArray;
    }


    public int getObjId() {
        return objId;
    }


    public int getSize() {
        return size;
    }


    public int getThreadIdRef() {
        return threadIdRef;
    }


    public String getTime() {
        return time;
    }


    public String getTraceIdRef() {
        return traceIdRef;
    }


    public int getTransientClassIdRef() {
        return transientClassIdRef;
    }


    public int getTransientObjId() {
        return transientObjId;
    }


    public int getTransientThreadIdRef() {
        return transientThreadIdRef;
    }
}
