/**********************************************************************
Copyright (c) 2005, 2007 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: SetConfig.java,v 1.13 2007/11/19 20:29:20 jcayne Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.tptp.platform.collection.framework;

import java.util.Enumeration;

import org.eclipse.tptp.platform.agentcontroller.config.Agent;
import org.eclipse.tptp.platform.agentcontroller.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.config.Option;
import org.eclipse.tptp.platform.agentcontroller.config.PlatformObject;
import org.eclipse.tptp.platform.agentcontroller.config.PluginConfig;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfigSkeleton;
import org.eclipse.tptp.platform.agentcontroller.config.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig extends SetConfigSkeleton {

	public void askUser() {
	}

	public void generateConfiguration() {
		Document doc;
		Element holder;
		Element pConfig;

		Element aEnv;
		Element agent;
		Element option;
		Element var;

		//
		// Standard initializer 
		//
		doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		pConfig = doc.createElement(PluginConfig.TAG);
		holder = configFile.getHolder();
		holder.appendChild(pConfig);
		PluginConfig.setRequires(pConfig, "org.eclipse.hyades.execution, org.eclipse.hyades.logging.core");

		//
		// Plugin specific information
		//
		aEnv = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(aEnv, "default");
		pConfig.appendChild(aEnv);

		//
		// Provides
		//

		// Bug 89383 begins
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hcframe.jar");
		aEnv.appendChild(var);
		// Bug 89383 ends

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_TPTP_PLATFORM_COLLECTION_FRAMEWORK");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hcframe.jar");
		aEnv.appendChild(var);

        //Add all of the NL jars to the classpath:
        Enumeration nlJars = getNLFiles();
        while(nlJars.hasMoreElements()) {
            var = doc.createElement(Variable.TAG);            
            Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_TPTP_PLATFORM_COLLECTION_FRAMEWORK");            
            Variable.setPosition(var, "append");            
            Variable.setValue(var, ((String)(nlJars.nextElement())));            
            aEnv.appendChild(var);
        }

		//
		// Application
		//

		agent = doc.createElement(Agent.TAG);
		Agent.setConfiguration(agent, "default");
		Agent.setName(agent, "Java Profiling Agent");
		Agent.setClient(agent, "DYNAMIC");
		if(PlatformObject.name.startsWith("Windows")) {
			Agent.setDataChannelSize(agent, "64M");
		}
		else {
			Agent.setDataChannelSize(agent, "30M");
		}
		Agent.setType(agent, "Profiler");
		pConfig.appendChild(agent);

		option = doc.createElement(Option.TAG);
		Option.setName(option, "Thread Analysis Agent");
		Option.setType(option, "Profiler");
		Option.setValue(option, "hcthread");
		pConfig.appendChild(option);

		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setType(option, "version");
		if(getPluginName().indexOf('_') != -1) {
			Option.setName(option, getPluginName().substring(0, getPluginName().lastIndexOf('_')));
			Option.setValue(option, getPluginName().substring(getPluginName().lastIndexOf('_') + 1));
		}
		else {
			Option.setName(option, getPluginName());
			Option.setValue(option, "unknown");
		}
		pConfig.appendChild(option);

		configFile.saveToFile();
	}

	public void printHelp() {
	}

	public void printExamples() {
	}

}
