/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataChannelHelper.java,v 1.3 2005/09/21 20:48:53 sschneid Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.collection.framework.channel;

/**
 * 
 * Description:
 * 		Describes a data channel helper class.
 *
 * Creation date: Apr 10, 2003
 * 
 */

import org.eclipse.hyades.execution.core.DataChannelConnectionException;
import org.eclipse.hyades.execution.core.DataChannelCreationException;

public class DataChannelHelper {

	public DataChannelHelper() {
	}
	
	public DataChannelImpl createDataChannel() 
				throws DataChannelCreationException {
		DataChannelImpl dc = new DataChannelImpl();
		
		try {
			dc.create();
		}
		catch (DataChannelCreationException dce) {
			throw dce;
		}
		
		return dc;
	}
	
	public DataChannelImpl createDataChannel(String name)
				throws DataChannelCreationException {
		DataChannelImpl dc = new DataChannelImpl();
	
		dc.setName(name);
		
		try {
			dc.create();
		}
		catch (DataChannelCreationException dce) {
			throw dce;
		}
		
		return dc;
	}	

		
	public DataChannelImpl createDataChannel(int size)
				throws DataChannelCreationException {
		DataChannelImpl dc = new DataChannelImpl();

		dc.setSize(size);
				
		try {
			dc.create();
		}
		catch (DataChannelCreationException dce) {
			throw dce;
		}
		
		return dc;
	}	
	
	
	public DataChannelImpl createDataChannel(String name, int size)
				throws DataChannelCreationException {
		DataChannelImpl dc = new DataChannelImpl();
		
		dc.setName(name);
		dc.setSize(size);
			
		try {
			dc.create();
		}
		catch (DataChannelCreationException dce) {
			throw dce;
		}
		
		return dc;
	}	


	public DataChannelImpl connectToDataChannel(String name)	
				throws DataChannelConnectionException {
		DataChannelImpl dc = new DataChannelImpl();
		
		dc.setName(name);
			
		try {
			dc.connect();
		}
		catch (DataChannelConnectionException dce) {
			throw dce;
		}
		
		return dc;
	}	

		
}