/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ParseMonitorOwner.java,v 1.2 2005/02/25 22:17:43 hleung Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;


import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ParseMonitorOwner 
{
	
	public ParseMonitorOwner(Hashtable i, Hashtable t, Hashtable m, Hashtable tid, ThreadDump td)
	{
		_idents = i;
		_threadDump = td;
		_threads = t;
		_monitors = m;
		_ownedMonitors = new Hashtable();
		_tid = tid;
	}
	
	public void doIt(int monIndex) 
	{

		Vector tdVector = _threadDump.getThreadDumpVector();
			
		String line = null;
		int size = tdVector.size();
		int sIndex = -1;
		String s = null;
//		Thd thread = null;
		Monitor monitor = null;
		
		while (true) 
		{
			//if we reach end of the file, break.
			if(size < ++monIndex)
				break;
			line = ((String)tdVector.elementAt(monIndex));
			//if we leave the monitor section, break.
			sIndex = line.indexOf("JVM System Monitor Dump (registered monitors):");
			if(sIndex >= 0)
				break;
			sIndex = line.indexOf("unowned");
			if(sIndex >= 0)
			{
				
				// deal with unowned monitors here
				// by checking if the monitor start address is equal to a thread's TID
				// i.e. if java.net.PlainDatagramSocketImpl@113B9958/113B9960
				// is a monitor then the start address for this monitor follows the @ and ends
				// at the "/".  And this value we should check against all Thread's TIDs
				// if this condition is true then that Thread is considered the owner of 
				// that particular monitor we are checking against.
					
				setMonOwner(line);	
					
					
						
				continue;
			}
		    sIndex = line.indexOf(FLATLOCKMSG);
		    if( sIndex >= 0 ) {
				//get the cross referenceable ident
				s = line.substring(sIndex + FLATLOCKMSG_LEN,sIndex + FLATLOCKMSG_LEN+4);
				// get the cross referenceable sys_thread_t
				s = (String)_idents.get(s); 
				// get the thread by using sys_thread_t	    
				//thread = (Thd)_threads.get(s);
				// find name of monitor within line in order to perform lookup on _monitors
				setMonOwner(line,s);
				continue;
		    }
		    // added for Linux (cx130) dump file.
		    sIndex = line.indexOf(FLATLOCKMSG_WITHIDENTASDIGIT);
		    if( sIndex >=0 ) {
		    	s = line.substring(sIndex + FLATLOCKMSG_WITHIDENTASDIGIT_LEN,
		    			line.indexOf(" ",sIndex+FLATLOCKMSG_WITHIDENTASDIGIT_LEN+1));
		    	s = (String)_idents.get(s);
		    	setMonOwner(line,s);
		    }
		    // added above for Linux (cx130) dump file.
		    

			sIndex = line.indexOf(OWNERMSG);
			if( sIndex >= 0 )
			{
				//s = line.substring(line.indexOf("(")+1, line.indexOf(")"));
				s = line.substring(line.indexOf("(",sIndex+OWNERMSG.length())+1, line.indexOf(")",sIndex+OWNERMSG.length()));
				// get the thread by using sys_thread_t	    
				//thread = (Thd)_threads.get(s);

				// find name of monitor within line in order to perform lookup on _monitors
				setMonOwner(line,s);

			}

			
			
			/*
			
			ident = line.substring(sIndex+6, sIndex+10);
			sysIndex = line.indexOf('(',sIndex+10);
			sys_thread_t = line.substring( sysIndex+1, line.indexOf(')', sysIndex+3) );
			addIdent(ident, sys_thread_t);*/
		}
		
				


		

	}
	
	public String toString()
	{

		StringBuffer sb = new StringBuffer();
		Iterator i = _ownedMonitors.keySet().iterator();
		sb.append("Owned Monitor Dump\n");
		while( i.hasNext() ) {
			sb.append("Monitor=\n");
			String name = (String)i.next();
			Monitor m = (Monitor)_monitors.get(name);
			sb.append( m.getName()  ).append("\n") ;
			sb.append( ((Thd)m._owner)._threadId  ).append("\n") ;
			if( m._waiters.size() > 0 ) {
				sb.append("Waiting sys_thread_t\n");
				for(int j = 0; j < m._waiters.size(); j++) {
					sb.append(((Thd)m._waiters.get(j))._threadId  ).append("\n") ;
				}			
			}
			else sb.append("No Waiters\n");
		}		
		
		return sb.toString();
	}
	
	public void addOwnedMonitor(String key,Monitor value) 
	{
		_ownedMonitors.put(key,value);
	}
	
	public Iterator getOwnedMonitorIterator() {
		return _ownedMonitors.keySet().iterator();
	}
	

	
	public void setMonOwner(String line, String t) 
	{
		// since line is a TA built line, instead of a JVM built javacore line it contains an extra colon.
		// and this needs to be consistent otherwise it will fail.
/*		int sIndex = line.indexOf(":", line.indexOf(":")+1);
		String s = line.substring(0,sIndex);
		s = s.substring(s.lastIndexOf(" ")+1);
		// now we can look up the monitor by name as stored in _monitors hashtable
		 */
		Monitor monitor = getMonitor(line);
		if( monitor == null ) 
		{
			// perhaps log this?
		}
		else {
			// get the thread by using sys_thread_t	  
			Thd thread = (Thd)_threads.get(t);
			if( thread == null ) 
			{
				// perhaps log this?
			}
			else 
			{
				monitor.setOwner(thread);
				addOwnedMonitor(monitor._name,monitor);
			}
		}		
		return;
	}
	/*
	 * This method is only used for monitors that claim themselves as "unowned", however,
	 *  their monitor start address coincides with some threads TID value.
	 */
	public void setMonOwner(String line)
	{
		Monitor monitor = getMonitor(line);
		if( monitor == null ) 
		{
			// perhaps log this? since it should always be in there
		}
		else 
		{
			String systhreadt = (String)_tid.get(getMonitorStartAddress(monitor._name));
			if( systhreadt != null )
			{
				Thd thread = (Thd)_threads.get(systhreadt);
				if( thread != null )
				{
					monitor.setOwner(thread);
					addOwnedMonitor(monitor._name,monitor);
				}
				else 
				{
					//perhaps log this?
				}
			}
		}		
	}
	
	public Monitor getMonitor(String line) 
	{
		int sIndex = line.indexOf(":", line.indexOf(":")+1);
		String s = line.substring(0,sIndex);
		s = s.substring(s.lastIndexOf(" ")+1);
		// now we can look up the monitor by name as stored in _monitors hashtable
		return (Monitor)_monitors.get(s);
	}
	
	public String getMonitorStartAddress(String monitorName)
	{
		// umm what is faster? creating an "int" or parsing 8 chars of a string?
		int sIndex = monitorName.indexOf("@");
		int fIndex = monitorName.indexOf("/",sIndex+1);
		String addr = monitorName.substring(sIndex+1,fIndex);
		return "0x" + addr;
	}
	
	public Hashtable getOwnedMonitors() 
	{
		return _ownedMonitors;
	}
	

	
	
	
	private Hashtable		_idents 		= null;
	private ThreadDump 	_threadDump 	= null;
	private Hashtable 		_threads 		= null;
	private Hashtable 		_monitors 		= null;
	private Hashtable		_ownedMonitors	= null;
	private Hashtable 		_tid			= null;
	private Vector			deadlockResults	= null;
	public static final String FLATLOCKMSG = "Flat locked by thread ident ";
	// added because a Linux dump file (cx130-) had it this way  
	public static final String FLATLOCKMSG_WITHIDENTASDIGIT = "Flat locked by threadIdent ";
	public static final int FLATLOCKMSG_WITHIDENTASDIGIT_LEN = FLATLOCKMSG_WITHIDENTASDIGIT.length();
	//added because of Linux WAS 402 dump file.
	public static final String FLATLOCKOWNER = "(Flat locked) owner ";
	public static final int FLATLOCKMSG_LEN = FLATLOCKMSG.length();
	public static final String OWNERMSG = "owner ";
//	private static final int OWNERMSG_LEN = OWNERMSG.length();
	
	
	
}
