/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ParseSystemMonitor.java,v 1.2 2005/02/25 22:17:43 hleung Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ParseSystemMonitor {
	
	public ParseSystemMonitor(Hashtable t, Hashtable i, Vector l)
	{
		_sysMon = new Hashtable();
		_threads = t;
		_lines = l;
		_idents = i;
	}
	
	public void doIt(int startIndex, int stopIndex)
	{
		String s = null;
		String line = null;
		int sIndex = -1;
		
		for(int i=startIndex; i<stopIndex; ++i)
		{
			if(_lines.size()<i)
				break;
			line = (String)_lines.elementAt(i);
			if(line.indexOf("lock:")>=0)
			{
				if(!(line.indexOf("<unowned>")>=0))
				{
					sIndex = line.indexOf(ParseMonitorOwner.FLATLOCKMSG);
					if(sIndex >=0)
					{
						//get the cross referenceable ident
						s = line.substring(sIndex + ParseMonitorOwner.FLATLOCKMSG_LEN,sIndex + ParseMonitorOwner.FLATLOCKMSG_LEN+4);
						// get the cross referenceable sys_thread_t
						s = (String)_idents.get(s); 
						// find name of monitor within line in order to perform lookup on _monitors
						setMonOwner(line,s,i);
						continue;
					}
					sIndex = line.indexOf(ParseMonitorOwner.OWNERMSG);
					if(sIndex >= 0)
					{
						s = line.substring(line.indexOf("(")+1, line.indexOf(")"));
		
						// find name of monitor within line in order to perform lookup on _monitors
						setMonOwner(line,s,i);
						continue;												
					}
				}

			}
		}
		//stop parsing at "Thread identifiers (as used in flat monitors):"
	}
	
	public void setMonOwner(String line, String t, int index) 
	{
		// since line is a TA built line, instead of a JVM built javacore line it contains an extra colon.
		// and this needs to be consistent otherwise it will fail.
		int sIndex = line.indexOf(":", line.indexOf(":")+1);
		String s = line.substring(0,sIndex);
		s = s.substring(s.lastIndexOf(":")+1).trim();
		// now we can look up the monitor by name as stored in _monitors hashtable
		Monitor monitor = new Monitor(s,0);
		// get the thread by using sys_thread_t	   
		Thd thread = (Thd)_threads.get(t);
		if( thread == null ) 
		{
			// perhaps log this?
		}
		else {
			monitor.setOwner(thread);
			monitor._name = s;
			setWaiters(index,monitor);
			addSystemMonitor(s,monitor);
		}	
		return;
	}
	
	public void setWaiters(int index, Monitor monitor)
	{
		String line = (String)_lines.elementAt(++index);
		int sIndex = line.indexOf("Waiting to be notified:");
		int p1 = -1;
		int p2 = -1;
		if( sIndex >= 0 ) {
			while(true) 
			{
				if( _lines.size() < ++index)
					break;
				line = (String)_lines.elementAt(index);					
				if( line.indexOf(" lock: ") >= 0 ) 
					break;
					//check if the ( or ) are there.  if they are not, break because it will cause an error
				p1 = line.indexOf("(");
				p2 = line.indexOf(")");
				if(  p1 < 0 ||  p2 < 0 )
					break;
				line = line.substring( p1 + 1, p2);
				monitor._waiters.add(_threads.get(line));
				
			}
		}
		
	}
	
	public void addSystemMonitor(String key, Monitor value) 
	{
		_sysMon.put(key,value);
	}
	
	public Hashtable getSysMon()
	{
		return _sysMon;
	}
	
	public String toString()
	{

		StringBuffer sb = new StringBuffer();
		Iterator i = _sysMon.keySet().iterator();
		sb.append("System Monitor Dump\n");
		while( i.hasNext() ) {
			sb.append("Monitor=\n");
			String name = (String)i.next();
			Monitor m = (Monitor)_sysMon.get(name);
			sb.append( m.getName()  ).append("\n") ;
			sb.append( ((Thd)m._owner)._threadId  ).append("\n") ;
			if( m._waiters.size() > 0 ) {
				sb.append("Waiting sys_thread_t\n");
				for(int j = 0; j < m._waiters.size(); j++) {
					sb.append(((Thd)m._waiters.get(j))._threadId  ).append("\n") ;
				}			
			}
			else sb.append("No Waiters\n");
		}		
		
		return sb.toString();
	}
	private Hashtable _sysMon = null;
	private Hashtable _threads = null;
	private Vector _lines = null;
	private Hashtable _idents = null;

}
