/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ParseTID.java,v 1.2 2005/02/25 22:17:43 hleung Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Hashtable;
import java.util.Vector;


public class ParseTID {
	
	public ParseTID(Vector v)
	{
		_lines = v;
		_tid = new Hashtable();
		_reversedTid = new Hashtable(); // created to have a revsered copy of _tid
	}
	
	public void doIt()
	{
		int size = _lines.size();
		String line = null;
		int i =0;
		int sIndex = -1;
		int comma = -1;
		for(; i<size; i++)
		{
			line = (String)_lines.elementAt(i);
			if(line.indexOf("Full thread dump Classic VM") >=0)
			{
				break;
			}	
		}
		
		String tid = null;
		String sys_thread_t = null;
		
		for(;i<size;++i)
		{
			line = (String)_lines.elementAt(i);
			sIndex = line.indexOf("TID:");
			if(sIndex >= 0)
			{
				comma = line.indexOf(",",sIndex+5);
				tid = line.substring(sIndex+4,comma);
				sIndex = line.indexOf("sys_thread_t:",comma+1);
				comma = line.indexOf(",",sIndex+14);
				sys_thread_t = line.substring(sIndex+13, comma);
				_tid.put(tid,sys_thread_t);
				_reversedTid.put(sys_thread_t,tid);
			}
		}
	}
	
	public Hashtable getTIDMap() 
	{
		return _tid;
	}

	public Hashtable getReversedTIDMap() 
	{
		return _reversedTid;
	}
	
	private Vector _lines 	= null;
	private Hashtable _tid = null;
	private Hashtable _reversedTid = null;

}
