/**********************************************************************
Copyright (c) 2005, 2006 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: StkEntry.java,v 1.4 2006/11/13 20:17:32 samwai Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;


import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;



public class StkEntry implements Externalizable
{
   /**
	 * 
	 */
	private static final long serialVersionUID = 3212113331166362316L;
private static int _curVersion = 1; // update when version changes (data added)
   private int _version = -1;

   public StkEntry( String method, String pkg, String module, int lineno, boolean isNative )
   {
      _version    = _curVersion;
      _method     = method;
      _pkg        = pkg;
      _lineno     = lineno;
      _isNative   = isNative;
      _module     = module;
   }


   public String format( int indent )
   {
      String sIndent = "";
      for( int i = 0; i < indent; ++i )
         sIndent += "   ";
      String sRet = sIndent + "      " + _pkg + "." + _method + " " + TAUtils.getNLSValue("ta.string.in", "in") + " " + _module + " " + TAUtils.getNLSValue("ta.string.native", "native") + "=" + _isNative;
      return sRet;
   }

   public void print( int indent )
   {
      System.out.println( format( indent ));
   }

   public String getFQName()
   {
      return _pkg + "." + _method;
   }

   public void writeExternal( ObjectOutput out ) throws IOException
   {
      out.writeInt(     _version );
      out.writeObject(  _method );
      out.writeObject(  _pkg );
      out.writeObject(  _module );
      out.writeInt(     _lineno );
      out.writeBoolean( _isNative );

   }

   public void readExternal( ObjectInput in ) throws IOException, ClassNotFoundException
   {
      _version    = in.readInt();
      _method     = (String)in.readObject();
      _pkg        = (String)in.readObject();
      _module     = (String)in.readObject();
      _lineno     = in.readInt();
      _isNative   = in.readBoolean();
   }

   public StkEntry() // for externalization
   {
   }


   public String _method;
   public String _pkg;
   public String _module;
   public int _lineno;
   public boolean _isNative;
   // end of version 1 variables
   // add version 2 variables here

   //
   // add statics and transients below 
   //
   
}

