/**********************************************************************
Copyright (c) 2005, 2006 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: StkEntryNative.java,v 1.4 2006/11/13 20:17:32 samwai Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;



public class StkEntryNative

   extends    StkEntry 
   implements Externalizable
{
   /**
	 * 
	 */
	private static final long serialVersionUID = 7779315781800929098L;
private static int _curVersion = 1; // update when version changes (data added)
   private int _version = -1;

   public StkEntryNative( String function, String hexAddress )
   {
      _version    = _curVersion;
      _function   = function;
      _hexAddress = hexAddress;
   }


   public String format( int indent )
   {
      String sIndent = "";
      String sRet    = "";

      for( int i = 0; i < indent; ++i )
         sIndent += "   ";

      if( _function == null )
          sRet = sIndent + "      " + _hexAddress;
      else
          sRet = sIndent + "      " + _hexAddress + " " + TAUtils.getNLSValue("ta.string.in", "in") + " " + _function;

      return sRet;
   }

   public void print( int indent )
   {
      System.out.println( format( indent ));
   }

   public String getFQName()
   {
      return _function;
   }

   public void writeExternal( ObjectOutput out ) throws IOException
   {
      out.writeInt(     _version );
      out.writeObject(  _method );
      out.writeObject(  _pkg );
      out.writeObject(  _module );
      out.writeInt(     _lineno );
      out.writeBoolean( _isNative );
      out.writeObject(  _function );
      out.writeObject(  _hexAddress );

   }

   public void readExternal( ObjectInput in ) throws IOException, ClassNotFoundException
   {
      _version    = in.readInt();
      _method     = (String)in.readObject();
      _pkg        = (String)in.readObject();
      _module     = (String)in.readObject();
      _lineno     = in.readInt();
      _isNative   = in.readBoolean();
      _function   = (String)in.readObject();
      _hexAddress = (String)in.readObject();
   }

   public StkEntryNative() // for externalization
   {
   }


   public String _function;
   public String _hexAddress;
}

