/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: TaTosThdCountGridElement.java,v 1.2 2005/02/25 22:17:43 hleung Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;



public class TaTosThdCountGridElement implements TaGridElement
{
   public TaTosThdCountGridElement( int thdCount, Object additionalInfo )
   {
      _thdCount = thdCount;
      _additional = additionalInfo;
   }
   private TaTosThdCountGridElement()
   {
   }
   
   public String toString()
   {
      return ""+_thdCount;
   }

   public int compareTo( TaGridElement g )
   {
      TaTosThdCountGridElement e = (TaTosThdCountGridElement)g;
      int iRet = 1;
      if( e._thdCount == _thdCount )
         iRet = 0;
      else if( e._thdCount < _thdCount )
         iRet = -1;
      return iRet;
   }
   public int getThdCount()
   {
      return _thdCount;
   }
   
   public Object getAdditionalInfo()
   {
      return _additional;
   }

   private Object _additional = null;
   private int _thdCount = 0;
}

