/**********************************************************************
Copyright (c) 2005, 2006 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ThreadDump.java,v 1.4 2006/06/06 01:24:30 bduncan Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Vector;

/* holds the original thread dump text */

public class ThreadDump implements Externalizable
{
   /**
	 * 
	 */
	private static final long serialVersionUID = 1642708849786645642L;
public static final int _curVersion = 1;
   public int _version = -1;

   public Enumeration getEnumerator()
   {
      Enumeration xnum = _lines.elements();
      return xnum;
   }

   public String getNextLine( Enumeration xnum )
   {
      String sRet = null;
      if( xnum.hasMoreElements() )
         sRet = (String)xnum.nextElement();
      return sRet;
   }

   public void addLine( String line, int lineNo )
   {
      String lineNum = "" + lineNo;
      int spaces = 6-lineNum.length();
      
      for( int i = 0; i < spaces; ++i )
         lineNum = " " + lineNum;
      
      _lines.add( lineNum + ":" + line );
   }

   public ThreadDump()
   {
      _version = _curVersion;
      _lines = new Vector();
   }

   public void writeExternal( ObjectOutput out ) throws IOException
   {
      out.writeInt( _curVersion );
      out.writeObject( _lines );

   }
   
   public void readExternal( ObjectInput in ) throws IOException,ClassNotFoundException
   {
      _version = in.readInt();
      _lines = (Vector)in.readObject();
   }

   public int getSize()
   {
       return _lines.size();
   }

   public Vector getThreadDumpVector() //dipak
   {
                return _lines;
   }

   //private String dummyStreamTestVar = null;
   private Vector _lines = null;

}


