/**********************************************************************
Copyright (c) 2005, 2006 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: DumpParser.java,v 1.3 2006/06/06 01:24:31 bduncan Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
/*
 * DumpParser - IBM, March 2001
 */

package org.eclipse.hyades.collection.threadanalyzer.dumpparser;
//import com.ibm..ws.performance.threadanalyzer.dumpparser.*;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.SwingUtilities;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;
//B import com.ibm.ws.performance.threadanalyzer.tagui.TaGUI;
//B import com.ibm.ws.performance.threadanalyzer.tagui.TaServerOutProcessDialog;
//B import com.ibm.ws.performance.threadanalyzer.tagui.TaServerOutProcessThread;


public class DumpParser
{
//B   private static TaServerOutProcessDialog _od = null;
   private static DumpParser instance = null;
   private boolean cmdLine = false;
   protected boolean newDump = false;
   protected boolean recordLineFlag = true;

//   public static void doIt( String args[], TaServerOutProcessDialog od )
//   public static void doIt( String args[] )
//   {
//         _od = od;

           /*
           if( _od == null )
                logDebug( "_od is null" );
           else
                logDebug( "_od not null" );
                */

//         main( args );
           //doIt2( args );
//   }

   public DumpParser()
   {
       this.cmdLine = false; // default
   }

   public DumpParser( boolean cmdLine )
   {
        this.cmdLine = cmdLine;
   }

   public static void main( String args[] )
   {
       instance = new DumpParser( true );
       instance.doIt( args );
   }

   public void doIt( String args[] )
   {
      // open the dump file and parse it
          
       /*
       for( int i = 0; i < args.length; i++ )
       {
           System.out.println("args["+i+"]: " + args[i]);
       }
       */
      DumpParser d = null;
      parseArgs( args );
//      System.out.println( "#1 reportOut = " + DumpParser.getArg( "reportOut" ) );

      boolean fWriteReport    = !getArg( "reportType" ).equalsIgnoreCase( "none" );
      String streamInName     = DumpParser.getArg( "streamIn" );
      String dumpInName       = DumpParser.getArg( "dumpIn" );

      if( streamInName != null && dumpInName != null )
      {
         logErr( TAUtils.getNLSValue("ta.errmsg.SpecifyOnlyOne", "Must specify only one of { streamIn or dumpIn }") );
         syntax();
      }

      if( streamInName == null && dumpInName == null )
      {
         // since stream in is undoc'd for now, just output a message
         // that dumpin is required...
         logErr( TAUtils.getNLSValue("ta.errmsg.MustSpecifyDumpIn", "Must specify dumpIn") );
         //System.out.println( "Must specify one of { streamIn or dumpIn }" );
         syntax();
      }

      String reportOutName = getArg( "reportOut" );
      String streamOutName = getArg( "streamOut" );

      String reportType = getArg( "reportType" );
      if(      ! reportType.equalsIgnoreCase( "html" ) 
      && ! reportType.equalsIgnoreCase( "text" ) 
      && ! reportType.equalsIgnoreCase( "none" ) 
      )
      {
         logErr( TAUtils.getNLSValue("ta.errmsg.ReportTypeMustBe", "reportType must be either 'html', 'text' or 'none'") );
         syntax();
      }
      /*
      if( streamOut.get() != null && reportOut.get() != null )
      {
         logErr( "Must specify one of { streamOut or reportOut }" );
         syntax();
      }
      if( streamOut.get() == null && reportOut.get() == null )
      {
         logErr( "Must specify one of { streamOut or reportOut }" );
         syntax();
      }
      */

      if( dumpInName != null )
      {

                 DumpData data = null;

         try
         {
            d = DumpParser.create( dumpInName );                
            //dipak            
            logDebug("dumpName=\t" + dumpInName);
            logDebug("DumpParser=\t" + d.getClass().getName());         
            _dumpInName =  new String(dumpInName);

                        data = new DumpData();
            //dipak
            data.setDumpParserClassName(d.getClass().getName());
                        data.setInputFilename( dumpInName );

                        data.setLogLevel( logLevelFromArgs() );

            // d150307
            if( extraCarriageReturns( dumpInName ) )
            {
                final String dumpFile = dumpInName;

               Runnable showErrorDialog = new Runnable()
               {
                  public void run()
                  {

//B                     JOptionPane.showMessageDialog( TaGUI.getInstance(),"Error parsing: " + dumpFile + "\n\nThis file appears to have extraneous carriage returns.  Please clean up the file and try again.","Error",JOptionPane.ERROR_MESSAGE);
                    }
                };

                SwingUtilities.invokeLater( showErrorDialog );
                return;
            }

                        d.parse( data );       

//                      data.warnMissingStacks( System.err );

//                      System.out.println( "#2 reportOut = " + DumpParser.getArg( "reportOut" ) );

            /*
            TaGUI gui = (TaGUI) Class.forName("com.ibm.ws.performance.threadanalyzer.tagui.TaGUI").newInstance();
            if( gui.guiExists() )
                System.out.println("gui exists !!!");
            else
                System.out.println("gui does not exist !!!");
                */

//                      System.out.println( "#3 reportOut = " + DumpParser.getArg( "reportOut" ) );
            if( !cmdLine )
            {
               if ( streamOutName != null )
               {
//               We are only writing out a .dump file that gets picked up by the GUI., so don't print
                // that the file has been parsed and analyzed.
//B             if( TaGUI.getOpenExistingDialog() != null )
//B             {
//B                 // for non-Solaris dumps
//B                             TaGUI.getOpenExistingDialog().append("\r\n" + "Successfully parsed" );
//B                 TaGUI.getOpenExistingDialog().append("\r\n" + "Performing analysis..." );
//B             }
//B             else
//B                 // for Solaris dumps
//B                             TaServerOutProcessThread.getDialog().appendText("\n" + "Successfully parsed: " + dumpInName);
               }
            }
            else
                logInfo( "Successfully parsed: " + dumpInName );
         }
         catch( Exception e )
         {
                        if( _logLevel >= DEBUG )
                                e.printStackTrace();

            final String dumpFile = dumpInName;
            final String lineNo   = e.getMessage();

            if( !cmdLine )
            {
//B             if( TaGUI.getOpenExistingDialog() != null )
//B                 // for non-Solaris dumps
//B                             TaGUI.getOpenExistingDialog().append("\r\n" + "Errors occurred while parsing: "+ e.toString());
//B             else
//B                 // for Solaris dumps
//B                             TaServerOutProcessThread.getDialog().appendText("\r\n" + "Errors occurred during parsing");

               Runnable showErrorDialog = new Runnable()
               {
                  public void run()
                  {

//B                     JOptionPane.showMessageDialog( TaGUI.getInstance(),"Error parsing: " + dumpFile + "\n\nThis does not appear to be a valid dump file.  Editing the file at line " + lineNo + " \nand deleting any invalid stack entries may allow the file to be read.","Error",JOptionPane.ERROR_MESSAGE);
                    }
                };

                SwingUtilities.invokeLater( showErrorDialog );
            }

            else
                            logErr("Errors occurred parsing: " + dumpFile);

                         
                        return;
            //System.exit( -1 );
         }


         if( d._r != null )
         {
            try
            {
               d._r.close();
            }
            catch( IOException ioe )
            {
               // nothing.
            }
         }
//               logInfo( "after d._r.close()" );

         if( streamOutName == null && fWriteReport )
         {
                        logDebug( "streamOutName == null & fWriteReport" );
//                      logDebug( "#4 reportOut = " + DumpParser.getArg( "reportOut" ) );

            if( getArg( "reportOut" ).equalsIgnoreCase( "DEFAULT" ))
               data.print();
            else data.print( getArg( "reportOut" ));
         }

                 // Writes out a .dump file that gets picked up by the GUI.
                 // I don't know if we still need to do this, or if we can
                 // just pass it back directly to the GUI...
         else if( streamOutName != null )
         {
            try
            {
                           logDebug( "DumpParser.main()  trying to write to: " + streamOutName );
               data.writeTo( streamOutName );                         
            }
            catch( Throwable e1 )
            {
               logErr( TAUtils.getNLSValue("ta.errmsg.ExceptionOccurred", "an exception occurred.") );    
               e1.printStackTrace();                              
               //throw e1;                                        
            }
         }
//               logInfo( "neither was true" );
      }
      else
      {
         try
         {

            DumpData data = DumpData.readFrom( streamInName );
            data.setLogLevel( logLevelFromArgs() );
            if( fWriteReport )
               data.print();
//            data.warnMissingStacks( System.err );
         }
         catch( Exception e1 )
         {
            logErr( TAUtils.getNLSValue("ta.errmsg.ExceptionOccurred", "an exception occurred.") );    
            e1.printStackTrace();                              

         }
      }
//        logInfo( "attempting flush()" );
//      System.err.flush();
//        logInfo( "after flush()" );
      // give caller a chance to read all of stderr
      try
      {
//               logInfo( "before sleep()" );
         Thread.sleep( 1000 );
//               logInfo( "after sleep()" );
      }
      catch( InterruptedException ie )
      {
      }
          
//        Thread.dumpStack();
   }


   private static boolean extraCarriageReturns( String inFile )
       throws FileNotFoundException, IOException
       
   {
       boolean unixNewlines = false;

       BufferedReader charReader = 
           new BufferedReader( 
               new FileReader( inFile ) );

       logDebug("[DumpParser] detecting first EOL");

       for( char c = 0; (c = (char) charReader.read()) != '\r'; )
       {
           if( _logLevel >= DEBUG )
               System.err.print(c);

           if( c == '\n' )
           {
               unixNewlines = true;
               break; // unix newline format detected
           }
       }

       logDebug("\n[DumpParser] Found EOL !!!");

       if( ! unixNewlines )
       {
           if( charReader.read() == '\r' )
           {
               logDebug("[DumpParser] extra carriage returns detected.  quitting...");
               return true;
           }
       }

       return false;
   }


   public static DumpParser create( String fileName ) throws Exception
   {
      int file_type = UNKNOWN;
      
      file_type = getDumpParserTypeFromFile( fileName );

      BufferedReader r;
      try
      {
         r = new BufferedReader( new FileReader( fileName ) );

      }
      catch( Exception e )
      {
         logErr( TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + fileName );
         throw e;
      }

      DumpParser d = null;     
      d = createParser( file_type, r );
      return d;
   }

   public static int getDumpParserTypeFromFile( String fileName ) throws Exception
   {
     
     String str1;
     int file_type = UNKNOWN;
     BufferedReader r = null;
     try
     {
        r = new BufferedReader( new FileReader( fileName ) );
     }
     catch( Exception e )
     {
        logErr( "dumpparser: " + TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + fileName );
        throw e;
     }
     for( int i = 0; i < 75; ++i )
     {
        str1 = r.readLine();
        if ( str1 == null )
          break;
        file_type = getDumpParserType( str1 );
        if ( file_type != UNKNOWN ) {
          _dumpingJvmName=str1.substring(str1.indexOf(" ")+1);
          break;
        }
     }
     return file_type;
   }
   
   public static int getDumpParserTypeFromDumpData( DumpData d )
   {
     String str1;
     int file_type = UNKNOWN;
     ThreadDump thdDump = null;
     thdDump = d.getThreadDump();
     Enumeration xnum = thdDump.getEnumerator();
     for ( int i = 0; i < 75; ++i )
     {
       str1 = thdDump.getNextLine( xnum );
       file_type = getDumpParserType( str1 );
       if ( file_type != UNKNOWN )
         break;
     }
     return file_type;
   }
   
   private static int getDumpParserType( String str )
   {
     int file_type = UNKNOWN;
     if( str.indexOf( "IBM build a118" ) != -1 )
     {
        logDebug( "jdk build: a118..." );
        file_type = a118_20010215a;
     }
     if( str.indexOf( "IBM AIX build" ) != -1 )
     {
       if( str.indexOf( "IBM AIX build ca131" ) != -1 )
               {   // so far, it looks the same as ...
          logDebug( "jdk AIX build: ca131..." );
  //                  file_type = ca131_20020722;
          file_type = ca122_20001026b;
       }
       if( str.indexOf( "IBM AIX build ca131-20021" ) != -1 ||
           str.indexOf( "IBM AIX build ca131-2003" )  != -1 )
               {
          logDebug( "jdk AIX build: ca131-20021..." );
          file_type = LINUX131_2;
       }       
       if( str.indexOf( "IBM AIX build ca1411" ) != -1 )
       {
           logDebug( "jdk AIX build: ca1411..." );
           file_type = ca1411_20031011;
       }
     }
     if( str.indexOf( "IBM build ca130" ) != -1 )
     {   // so far, it looks the same as ...
        logDebug( "jdk build: ca130..." );
        file_type = ca122_20001026b;
     }

     if( str.indexOf( "IBM build ca122" ) != -1 )
     {
        logDebug( "jdk build: ca122..." );
        file_type = ca122_20001026b;
     }

     if( str.indexOf( "IBM build cx130" ) != -1 )
     {
        logDebug( "jdk build: cx130..." );
        //dipak
        //cx130 should be for Linux 130
        //ca122 is being used by AIX and is not easily changeable for
        //Linux. The looks like comment is an old comment
        //file_type = ca122_20001026b; // looks like...
        file_type = LINUX130;
     }

     if( str.indexOf( "IBM build cn122" ) != -1 )
     {
        logDebug( "jdk build: cn122..." ); // 3.5.x
        file_type = cn122_20001026;
     }

     if( str.indexOf( "IBM build cn130" ) != -1 )
     {
        logDebug( "jdk build: cn130..." );
        file_type = cn130_20010502; // looks like...
     }
             if( str.indexOf( "IBM Windows 32 build cn131" ) != -1 )
             {
                    logDebug( "jdk build: cn131..." );
                     file_type = cn131_20020223;
             }
     if( str.indexOf( "A SIGQUIT has been received. Do you want to:" ) != -1 )
     {
        logDebug( TAUtils.getNLSValue("ta.errmsg.FileTypeWs35ForSolaris", "File type ws 35 for solaris") );
        file_type = SOLARIS35;
     }
     if( str.indexOf( "cn130-20010925" ) != -1 )
     {
        logDebug( "jdk build: cn130-20010925" );
        file_type = cn130_20010502; // looks like...
     }
     if( str.indexOf( "cn130-20010914" ) != -1 )
     {
        logDebug( "jdk build: cn130-20010914" );
        file_type = cn130_20010502; // looks like javacore
                    if( str.indexOf( "Classic VM" ) != -1 ) // Classic VM is NOT on this line for new style
                            file_type = cn122_20001026; // looks like... Go figure...
     }
     if( str.indexOf( "cn130-20010609" ) != -1 )
     {
        logDebug( "jdk build: cn130-20010609" );
        file_type = cn130_20010502; // looks like...
     }
     if( str.indexOf( "cn130-20010502" ) != -1 )
     {
        logDebug( "jdk build: cn130-20010502" );
        file_type = cn130_20010502;
     }
     if( str.indexOf( "cn1411-20031011" ) != -1 )
     {
        logDebug( "jdk build: cn1411-20031011" );
        file_type = cn1411_20031011;
     }

             /*
     if( str1.indexOf( "IBM Windows 32 build cn131" ) != -1 )
     {
        logDebug( "jdk build: cn131..." );
        file_type = cn130_20010502; // looks like...
     }
             */

     if( str.indexOf( "ca122-20010629" ) != -1 )
     {
        logDebug( "jdk build: ca122-20010629" ); // workaround libjvm.a for 122
        file_type = ca122_20001026b;
     }

     if( str.indexOf( "ca122-20001026b" ) != -1 )
     {
        logDebug( "jdk build: ca122-20001026b" );
        file_type = ca122_20001026b;
     }

     if( str.indexOf( "c390_x122-20010316" ) != -1 )
     {
        logDebug( "jdk build: c390_x122-20010316" ); // 3.5 390 linux
        file_type = cn122_20001026;
     }
     if( str.indexOf( "cn122-20010629" ) != -1 )
     { // this build apparently activated javacore-like thread dumps in 3.55
       // unfortunately, this build writes the thread dumps to two places...
       // the stderr version is like the old cn122 format and the
       // javacore version is more like the cn130 version
       // By default, since this is for NT 1.2.2, we pick up the 
       // stderr version when getThreadDump is used.
       // However, logic needs to be inserted to
       // determine the "actual" format being accessed. Goofy as hell...
       // --
        logDebug( "jdk build: cn122-20010629" );
        file_type = cn122_20001026; // looks like... (stderr version)
        if( str.indexOf( "Classic VM" ) == -1 ) // Classic VM is NOT on this line for new style
           file_type = cn130_20010502; // looks like... (javacore version) -- btw, they slightly changed this format as well for this PTF. Go figure...
     }
     if( str.indexOf( "cn122-20010503a" ) != -1 )
     { // this build apparently activated javacore-like thread dumps in 3.5x
        logDebug( "jdk build: cn130..." );
        file_type = cn130_20010502; // looks like...
     }
     if( str.indexOf( "cn122-20010929" ) != -1 )
     { // this build apparently activated javacore-like thread dumps in 3.5x
        logDebug( "jdk build: cn130..." );
        file_type = cn130_20010502; // looks like...
     }
     if( str.indexOf( "cn122-20010308" ) != -1 )
     {
        logDebug( "jdk build: cn122-20010308" ); // 3.5.4
        file_type = cn122_20001026;
     }
     if( str.indexOf( "cn122-20001026" ) != -1 )
     { // so far, was 4.0 for nt looks like aix 1.2.2
        logDebug( "jdk build: cn122-20001026" );
        file_type = cn122_20001026;
     }
     if( str.indexOf( "ca122-20001026" ) != -1 )
     { // redundant,but explicit
        logDebug( "jdk build: ca122-20001026" );
        file_type = ca122_20001026b;
     }
     if( str.indexOf( "ca130-20010713" ) != -1 ) // test jvm
     {
        // so far, it looks the same as ...
        logDebug( "jdk build: ca130-20010713" );
        file_type = ca122_20001026b;
     }
     if( str.indexOf( "ca130-20010615" ) != -1 )
     {   // so far, it looks the same as ...
        logDebug( "jdk build: ca130-20010615" );
        file_type = ca122_20001026b;
     }

     if( str.indexOf( "ca130-20010330" ) != -1 )
     {   // so far, it looks the same as ...
        logDebug( "jdk build: ca130-20010330" );
        file_type = ca122_20001026b;
     }
     if( str.indexOf( "ca122-20010313" ) != -1 )
     {   // so far, it looks the same as ...
        logDebug( "jdk build: ca122-20010313" );
        file_type = ca122_20001026b;
     }

     if( str.indexOf( "a118-20010804" ) != -1 )
     {
        logDebug( "jdk build: a118-20010804" );
        file_type = a118_20010215a;  // looks like...
     }
     if( str.indexOf( "a118-20010215a" ) != -1 )
     {
        logDebug( "jdk build: a118-20010215a" );
        file_type = a118_20010215a;
     }
     if( str.indexOf( "a118-20000411" ) != -1 )
     {   // so far, it looks the same as ...
        logDebug( "jdk build: a118-20000411" );
        file_type = a118_20010215a;
     }
             if( str.indexOf( "lwp_id" ) != -1 )
             {
                     logDebug( "lwp_id...indicates HP" );
                     file_type = HPUX;
             }
             if( str.indexOf( "cx390130" ) != -1 || 
         str.indexOf( "cxia32130") != -1 )
             {
                     //logDebug( "J2RE 1.3.0 IBM build cx390130-2001112" );
                     logDebug( "J2RE 1.3.0 IBM build for Linux" );
                     file_type = LINUX130;
             }
      if( str.indexOf( "cx3901411-20031011" ) != -1 )
      {
         logDebug( "jdk build:  cx3901411-20031011" ); // 390 linux
         file_type = LINUX131_2;
      }
     //dipak
     if( str.indexOf("IBM build cxppc") != -1 )
     {
        logDebug("IBM build cxppc - Linux/Suse");
        file_type = LINUX131_CXPPC;
     }
     if( str.indexOf( "cx390131" ) != -1 ||
         str.indexOf( "cxia32131") != -1 )
     {
                     logDebug( "J2RE 1.3.1 IBM build for Linux" );
                     file_type = LINUX131;
     }
             if( str.indexOf( "cxia32131-20021" ) != -1 || 
         str.indexOf( "cxia32131-2003" )  != -1 || 
         str.indexOf( "cx390131-20021"  ) != -1 ||
         str.indexOf( "cx390131-2003"  )  != -1 )
             {
                     logDebug( "J2RE 1.3.1 IBM build for Linux" );
                     //file_type = cxia32;
                     file_type = LINUX131_2;
             }
             if( str.indexOf( "cn131w-20020223" ) != -1 )
             {
                     logDebug( "J2RE 1.3.1 IBM Windows 32 build cn131w-20020223 ORB130" );
                     file_type = cn131_20020223;
             }
             if( str.indexOf( "cn131-20021" )  != -1 ||
         str.indexOf( "cn131-2003" )   != -1 ||
         str.indexOf( "cn131w-20021" ) != -1 ||
         str.indexOf( "cndev-2003" ) != -1 ||
         str.indexOf( "cndev-2004" ) != -1 ||
         str.indexOf( "cn142-2004" ) != -1 ||		 
         str.indexOf( "cn131w-2003" )  != -1 )
             {
					 logDebug( "Compatible with parser for IBM Windows 32 build cn131-20021012" );
                     file_type = cn131_20021012;
             }
     return file_type;
   }
   
   public static DumpParser createParser( int file_type, BufferedReader r )
   {
     // later, create the correct kind of 
     // parser.  For now, create
     // a parser for an NT jvm dump
     DumpParser d = null;

     //if( file_type == aNT )
     /*if( file_type == -1 )
        d = new DumpParserNT( );
     else */                         


         /*
         if( file_type == UNKNOWN && ! getArg("openExisting").equalsIgnoreCase("true") )
         {
                 // if the dump type is unknown let's check if it's HP.

                 // HP doesn't output the JVM build ID in its dump text so let's
                 // call the local WAS jvm and ask it...

                 // note we only do this check if we're triggering the dump, not if we're
                 // opening an existing file

                 String cmd = System.getProperty("java.home") +
                         System.getProperty("file.separator") + ".." +
                         System.getProperty("file.separator") + "bin" +
                         System.getProperty("file.separator") +
                         "java -fullversion";

                 System.out.println( "cmd = " + cmd );

                 Process p = Runtime.getRuntime().exec(cmd);
                 java.io.InputStream is = p.getErrorStream();

                 int ch = 0;
                 StringBuffer sb = new StringBuffer();

                 while( (ch = is.read()) != -1 )
                 {
                         sb.append( (char)ch );
                 }

                 String jvmVersion = sb.toString();

                 System.out.println( "jvmVersion = " + jvmVersion );
                 System.out.println( "os.name = " + System.getProperty("os.name"));

                 if( System.getProperty("os.name").indexOf( "HP-UX" ) != -1 )
                 {
                               if( jvmVersion.indexOf( "jinteg:07/30/01-15:33" ) != -1 )
                               {
                                  logDebug( "jdk build: HPUX jinteg:07/30/01-15:33" );
                                  file_type = HPUX;
                                  System.out.println( "file_type set to HPUX" );
                               }
                 }

         }
         */

     if( file_type == cn122_20001026 )
     {
        d = new DumpParserNT( );  // for 3.5.x
     }
         else if( file_type == ca131_20020722 )
         {
                d = new DumpParser_ca131_20020722();
         }
     else if( file_type == cn1411_20031011 )
     {
        d = new DumpParser_cn131_20021012( );
     }
     else if( file_type == cn131_20021012 )
     {
        d = new DumpParser_cn131_20021012();
     }
     else if( file_type == cn131_20020223 )
     {
        d = new DumpParser_cn131_20020223();
     }
     else if( file_type == cn130_20010502 )
     {
        d = new DumpParser_cn130_20010502( );
     }
     else if( file_type == ca122_20001026b )
     {
        d = new DumpParser_ca122_20001026b( );
     }
     else if( file_type == ca1411_20031011 )
     {
       d = new DumpParser_ca1411_20031011();
     }
     else if( file_type == a118_20010215a || file_type == a118_20000411 )
     {
        d = new DumpParser_a118_20010215a( );
     }
     else if( file_type == SOLARIS35 )
     {
        d = new DumpParserSolaris();
     }
         else if( file_type == HPUX )
         {
                d = new DumpParserHP();
         }
         else if( file_type == LINUX130 )
         {
                d = new DumpParserLinux(); 
         }
         else if( file_type == LINUX131 )
         {
                d = new DumpParserLinux131(); 
         }
         else if( file_type == LINUX131_2)
         {
                d = new DumpParser_cxia32131_20021023(); 
         }
         else if( file_type == LINUX131_CXPPC )
         { //dipak
        d = new DumpParserLinux131_Suse_cxppc();
     }
         else
         {
                d = new DumpParserSolaris40( );   // default
         }

     d._r = r;
//     d._logLevel = logLevelFromArgs();
     DumpParser._logLevel = logLevelFromArgs();

     return d;
   }

   private static int logLevelFromArgs()
   {
      int retVal = INFO;
      String arg = getArg( "logLevel" );
      if( arg != null )
      {
         if( arg.equalsIgnoreCase( "error" ) )
            retVal = ERROR;
         if( arg.equalsIgnoreCase( "warn" ) )
            retVal = WARNING;
         if( arg.equalsIgnoreCase( "info" ) )
            retVal = INFO;
         if( arg.equalsIgnoreCase( "detail" ) )
            retVal = DETAIL;
         if( arg.equalsIgnoreCase( "debug" ) )
            retVal = DEBUG;
      }
      return retVal;

   }

   protected String getLine() throws Exception
   {
      String sRet = null;
      if( _r.ready() )
      {
         ++_lineNo;
         sRet = _r.readLine();
      }

      logDebug( "line " + _lineNo + ": " + sRet );
      return sRet;

   }

   protected String getLine( DumpData d ) throws Exception
   {
      String sRet = null;
      sRet = getLine();

      if( recordLineFlag )
          d.addDumpTextLine( sRet, _lineNo );

      if( newDump && sRet != null )
      {
          int i = sRet.indexOf(' ');
          String sRetNew = sRet.substring(i);
          sRetNew.trim();
          return sRetNew;
      }

      return sRet;
   }

   protected void resetFileReader()
       throws Exception
   {
       try
       {
          _r.close();
       }
       catch( IOException ioe )
       {
          // nothing.
       }

       try
       {
          _r = new BufferedReader( new FileReader( _dumpInName ) );
          _lineNo = 0;
       }
       catch( Exception e )
       {
          logErr( TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + _dumpInName );
          throw e;
       }
   }

   protected static void syntax()
   {
      logErr( "DumpParser " + TAUtils.getNLSValue("ta.string.syntax", "syntax") + ":" );
      //streamin is undoc'd System.out.println( "   { streamIn=filename | dumpIn=filename }" );
      logErr( "   { dumpIn=filename }" );
      //System.out.println( "   [ streamOut=filename ] " );
      //System.out.println( "   [ detailXML=filename (defaults to ./threadanalyzerdetail.XML)]" );
      //System.out.println( "   [ analyze={ WAS | EJB | SERVLET | OTHER | ALL (default is WAS) ]" );
      logErr( "   [ logLevel={ERROR | WARN | INFO | DETAIL | DEBUG} (default:INFO) ]" );
      //System.out.println( "   { reportOut={ STDOUT | filename } (default is STDOUT) " );
      logErr( "   [ reportType={ TEXT | HTML | NONE } ( default is HTML ) ] " );
      logErr( "   [ dumpInType={ SERVEROUT | JAVACORE } ( default is JAVACORE ) ] " );

          return;
      //System.exit( -1 );

   }

   // made this public to work-around problem with new GUI testing
   // Ultimately, this requirement would be removed and the method
   // can be made protected again.
   public void parseArgs( String args[] )
   {
      for( int i = 0; i < _validArgNames.length; ++i )
      {
         //System.out.println( "Put: " + _validArgNames[ i ] );
         String sArg = null;
         if( _validArgNames[ i ].equals( "detailXML" ) )
            sArg = "./threadanalyzerdetail.xml" ;
         if( _validArgNames[ i ].equals( "reportOut" ) )
            sArg = "default";
         if( _validArgNames[ i ].equals( "reportType" ) )
             sArg = "html";
         if( _validArgNames[ i ].equals( "analyze" ) )
            sArg = "was";
         if( _validArgNames[ i ].equals( "dumpInType" ) )
            sArg = "javaCore";
         _args.put( _validArgNames[ i ].toUpperCase(), new Arg( sArg ) );
      }

      Enumeration xnum = null;

      for( xnum = _args.keys(); xnum.hasMoreElements(); )
      {
         String key = (String)xnum.nextElement();
         for( int i = 0; i < args.length; ++i )
         {
            if( args[i].toUpperCase().startsWith( key.toUpperCase() ) )
            {
               String value = null;
               int idx = args[i].toUpperCase().indexOf( key.toUpperCase() + "=" );
               if( idx == -1 )
                  syntax();
               idx = args[i].indexOf( "=" );
               value = args[i].substring( idx+1 );
               if( value.length() <= 0 )
                  syntax();
               if( key.equalsIgnoreCase( "logLevel" ) )
               {
                  if( !value.equalsIgnoreCase( "ERROR" ) &&
                  !value.equalsIgnoreCase( "WARN" ) &&
                  !value.equalsIgnoreCase( "INFO" ) &&
                  !value.equalsIgnoreCase( "DETAIL" ) &&
                  !value.equalsIgnoreCase( "DEBUG" ) )
                     syntax();
               }
               if( key.equalsIgnoreCase( "analyze" ) )
               {
                  if( !value.equalsIgnoreCase( "WAS" ) &&
                  !value.equalsIgnoreCase( "EJB" ) &&
                  !value.equalsIgnoreCase( "SERVLET" ) &&
                  !value.equalsIgnoreCase( "ALL" ) )
                     syntax();
               }
               _args.put( key.toUpperCase(), new Arg( value ) );
//               System.out.println("args: key=" + key + "  val=" + value);
               break;
            }
         }
      }
   }

   //public abstract void parse( DumpData d ) throws Exception;
   public void parse( DumpData d ) throws Exception
   {
   }


   protected static String _validArgNames[] =
   {
      "streamIn",
      "streamOut",
      "dumpIn",
      "detailXML",
      "logLevel",
      "reportOut",
      "reportType",
      "analyze",
          "dumpInType"
   };


   protected static void logErr( String msg )
   {
      System.err.println( msg );
   }

   protected static void logWarn( String msg )
   {
      if( _logLevel >= WARNING )
         System.err.println( msg );
   }

   protected static void logInfo( String msg )
   {
//B       if( _od != null )
//B       {
//B               _od.appendText( msg );
//B               return;
//B       }

      if( _logLevel >= INFO )
                 System.err.println( TAUtils.getNLSValue("ta.button.Info", "INFO") + ": " + msg );
   }

   protected static void logDetail( String msg )
   {
      if( _logLevel >= DETAIL )
         System.err.println( msg );
   }

   protected static void logDebug( String msg )
   {
      if( _logLevel >= DEBUG )
         System.err.println( msg );
   }

   public int getLogLevel()
   {
      return _logLevel;
   }

   public static String getArg( String argName )
   {
      String sRet = null;
      Arg arg = (Arg)_args.get( argName.toUpperCase() );
      if( arg != null )
         sRet = arg.get();
      else
      {
         logErr( TAUtils.getNLSValue("ta.errmsg.CantFindArg", "can't find argument") + ": " + argName.toUpperCase() );
      }
      return sRet;
   }

   public static void setDumpInName(String inName) {
	  _dumpInName = inName;
   }
   
   public String getDumpingJvmName() {
   	  return _dumpingJvmName;
   }
   public static final int DEBUG   = 4;
   public static final int DETAIL  = 3;
   public static final int INFO    = 2;
   public static final int WARNING = 1;
   public static final int ERROR   = 0;
   protected static int _logLevel = INFO;


   private static final int LINUX130         = 1;
   private static final int AIX              = 2;
   private static final int SOLARIS35        = 3;
   private static final int NT               = 4;
   private static final int HPUX             = 5;
   private static final int INTERNAL         = 6;
   private static final int ca122_20001026b  = 7;
   private static final int a118_20010215a   = 8;
   private static final int a118_20000411    = 9;
   private static final int cn130_20010502   = 10;
   private static final int cn122_20001026   = 11;
   private static final int cn131_20020223   = 12;
   private static final int ca131_20020722   = 13;
   private static final int cn131_20021012   = 14;
   private static final int ca1411_20031011  = 18;
   private static final int cn1411_20031011  = 19;
   private static final int LINUX131         = 15;
   private static final int LINUX131_2       = 16;
   //dipak
   private static final int LINUX131_CXPPC   =  17; 
   private static final int UNKNOWN          = 99;
   protected int _lineNo = 0;
   protected BufferedReader _r;
   protected static Hashtable _args = new Hashtable();
   protected static String _dumpInName;
   protected static String _dumpingJvmName;

   class Arg
   {
      public String _arg;
      public Arg( String val )
      {
         _arg = val;
      }
      public String get()
      {
         return _arg;
      }
   }
}


