/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: FileServerParametersExtendedImpl.java,v 1.3 2005/05/20 22:53:06 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.collection.framework;

import org.eclipse.hyades.internal.execution.file.IConnectionHandler;
import org.eclipse.hyades.internal.execution.file.IFileServerParameters;

/**
 * An extended implementation of the file server parameters implementation class
 * that creates an instance of the extended file connection handler class rather
 * than the legacy one. This is needed to support channels instead of socket and
 * streams in the file server.
 * 
 * @author Scott E. Schneider
 */
class FileServerParametersExtendedImpl implements IFileServerParameters {

	/**
	 * The preferred connection handler to use when connections are accepted on
	 * a server socket channel
	 */
	private final IConnectionHandler handler;

	/**
	 * The file server port used for this instance of the file server
	 */
	private int port;

	/**
	 * Create the file connection handler at construction time
	 */
	FileServerParametersExtendedImpl() {
		this.handler = new FileConnectionHandlerExtended();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#getConnectionHandler()
	 */
	public Object getConnectionHandler() {
		return this.handler;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#getPort()
	 */
	public int getPort() {
		return this.port;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#setPort(int)
	 */
	public void setPort(int port) {
		this.port = port;
	}

}
