/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: FileServerParametersImpl.java,v 1.7 2005/06/20 13:55:50 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.collection.framework;

import org.eclipse.hyades.internal.execution.file.IFileServerParameters;

/**
 * A bridge that instantiates the appropriate concrete class to use that should
 * match the file server implementation that is being used. The native code
 * expects a class by this name in this package and is instantiated by the agent
 * controller native code. This class creates and plugs in the real
 * implementation.
 * 
 * @author Scott E. Schneider
 */
public class FileServerParametersImpl implements IFileServerParameters {

	/**
	 * The concrete implementation that the bridge delegates calls into
	 */
	private IFileServerParameters parameters;

	/**
	 * An internal factory method for creating the appropriate file server
	 * parameters implementation that the bridge will forward to
	 * 
	 * @return the concrete delegate object
	 */
	private IFileServerParameters createFileServerParametersImpl() {
		return this.parameters = new FileServerParametersExtendedImpl();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#getConnectionHandler()
	 */
	public Object getConnectionHandler() {
		if (this.parameters == null) {
			this.parameters = this.createFileServerParametersImpl();
		}
		return this.parameters.getConnectionHandler();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#getPort()
	 */
	public int getPort() {
		if (this.parameters == null) {
			this.parameters = this.createFileServerParametersImpl();
		}
		return this.parameters.getPort();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.internal.execution.file.IFileServerParameters#setPort(int)
	 */
	public void setPort(int port) {
		if (this.parameters == null) {
			this.parameters = this.createFileServerParametersImpl();
		}
		this.parameters.setPort(port);
	}

}
