/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: SecureFileServerParametersImpl.java,v 1.4 2005/10/01 20:49:22 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.collection.framework;

import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.execution.security.ISecureServerParameters;

/**
 * This is now a bridge class that forwards the get connection handler method on
 * to the appropriate concrete instance, the former class that was named as this
 * class is now marked as legacy.
 * 
 * @author Scott E. Schneider
 */
public class SecureFileServerParametersImpl extends SecureServer {

	/**
	 * The concrete implementation that the bridge delegates calls into
	 */
	private ISecureServerParameters parameters;

	/**
	 * An internal factory method for creating the appropriate file server
	 * parameters implementation that the bridge will forward to
	 * 
	 * @return the concrete delegate object
	 */
	private ISecureServerParameters createFileServerParametersImpl() {
		return this.parameters = new SecureFileServerParametersExtendedImpl();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getConnectionHandler()
	 */
	public IConnectionHandler getConnectionHandler() {
		if (this.parameters == null) {
			this.parameters = this.createFileServerParametersImpl();
		}
		return this.parameters.getConnectionHandler();
	}

}
