/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DCFillerProcess.java,v 1.3 2005/10/01 22:03:41 sschneid Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.collection.framework;

/**
 *
 * Description:
 * 		Describes a data channel Filler process.
 *
 * Parameters
 * 		name of Data Channel
 * 		(optional) name of file to read to fill the data channel
 * 				- default file name is c:\temp\dctest.in
 * 		
 *
 * Creation date: Apr 10, 2003
 *
 */

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

import org.eclipse.hyades.collection.framework.channel.DataChannelHelper;
import org.eclipse.hyades.collection.framework.channel.DataChannelImpl;
import org.eclipse.hyades.execution.core.DataChannelConnectionException;
import org.eclipse.hyades.execution.core.DataChannelNotInitializedException;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;

/** Represents a data channel filler process. */
public class DCFillerProcess {

    // File name (shared between ctor and run)
    private static String fileName;
    private static String DCName;

    /** The entry point. Control is passed to run(). */
    public static void main(String[] args) {
        new DCFillerProcess(args);

        DataChannelHelper dch = new DataChannelHelper();

        DataChannelImpl dc;

		/* This filler process reads data from a file and writes it
		 * to the data channel.
		 */
        try {
        	dc = dch.connectToDataChannel(DCName);
        	
        	dc.setFillable();

        	FileInputStream fistream = new FileInputStream(fileName);
        	
			OutputStream ostrm = dc.getOutputStream();

			byte[] inbytes = new byte[8096];
			int bytesRead = 0;
		
			/* Read from the file stream and write to the output stream
			 * returned by the data channel
			 */
			try {
				while (true) {
					bytesRead = fistream.read(inbytes);
			
					if (bytesRead > 0) {
						ostrm.write(inbytes, 0, bytesRead);
					
					}
					else if (bytesRead < 0) {
						// End of File reached - no more data to read so quit
						break;	
					}
				}
				ostrm.close();	
			}
			catch (IOException ioe) {
				System.out.println("IOException occurred tyring to read from file or write to data channe");
			}			
			
			fistream.close();
			
        	dc.disconnect();
        	
        }
        catch (DataChannelConnectionException e) {
        	System.out.println("DCFillerProcess:  could not connect to data channel with name " + DCName
        	     + "\n   Reason: " + e.getMessage());
        }
        catch (InvalidDataChannelAccessException e) {
         	System.out.println("DCFillerProcess:  Cannot write to this data channel");
        }       	
        catch (DataChannelNotInitializedException e) {
         	System.out.println("DCFillerProcess:  data channel is not initialized");
        }
        catch (FileNotFoundException e) {
         	System.out.println("DCFillerProcess:  could not open file " + fileName);
        }
        catch (IOException e) {
         	System.out.println("DCFillerProcess:  could not close file " + fileName);
        }

    }

	public DCFillerProcess(String[] args) {
		System.out.println("DCFillerProcess: Command line arguments, length="+args.length);
        for ( int i=0; i<args.length; i++ )
            System.out.println("\targs["+i+"] = "+args[i]);

        // Data Channel name is the first command line argument, file name is the second
        if (args.length == 2) {
           DCName = args[0];
           fileName = args[1];
        }
        else if (args.length == 1) {
        	DCName = args[0];
			fileName = "c:\\temp\\dctest.in";
        }
        else {
        	DCName="shmchannel";
			fileName = "c:\\temp\\dctest.in";
        }
    }


}