/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: TestLauncher.java,v 1.2 2005/02/25 22:17:43 hleung Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

package org.eclipse.hyades.test.collection.framework;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.execution.core.impl.ProcessExecutableObjectImpl;
import org.eclipse.hyades.execution.core.impl.ProcessExecutorImpl;

/**
 * @author IBM
 *
 * This is a test case for the org.eclipse.hyades.collection.framework.java.executor package
 */
public class TestLauncher implements IExecutionComponentStateChangeListener {
	public static void main(String[] args) {

		TestLauncher test = new TestLauncher();
		test.mainTest();
	}

	private void mainTest() {
		ExecutionEnvironmentImpl exeEnv = new ExecutionEnvironmentImpl();
		exeEnv.init();
		OrderedPropertyImpl prop;

		prop = new OrderedPropertyImpl();
		prop.setName("CLASSPATH");

		if(System.getProperty("os.name").startsWith("Windows")) {
			prop.prependValue(new String("E:\\Test"));
			prop.appendValue(File.pathSeparator);
			prop.appendValue(new String("E:\\Test\\hello"));
			exeEnv.setEnv(prop);

			test01(exeEnv);
			//test02(exeEnv);
			//test03(exeEnv);
		}
		else {
			prop.prependValue(new String("/home/eclipse/Test"));
			exeEnv.setEnv(prop);

			test01Linux(exeEnv);
		}
	}
	
	private synchronized void runProcess(ExecutionEnvironmentImpl exeEnv, ProcessExecutableObjectImpl exeObj, boolean useConsole) {
		ProcessExecutorImpl executor;
		OutputStream stdin;
		InputStream stdout;
		InputStream stderr;
		UserConsole u = new UserConsole();
		int pid;

		executor = new ProcessExecutorImpl();
		exeEnv.addChild(executor);

		executor.setExecutableObject(exeObj);
		executor.addExecutionComponentStateChangeListener(this);

		if(useConsole) {
			stdin = executor.getStandardInputStream();
			stdout = executor.getStandardOutputStream();
			stderr = executor.getStandardErrorStream();
	
			u.setStdin(stdin);
			u.setStdout(stdout);
			u.setStderr(stderr);
			u.start();
		}

		executor.launch();

		pid = new Integer(executor.getPid()).intValue();
		if(pid < 0)
			return;

		if(useConsole) {
			/* Block this method until process has exited since there is only one system console available */
			while(executor.getProcessStatus(pid) != IExecutionComponent.DEAD) {
				try {
					Thread.sleep(2000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public void test01(ExecutionEnvironmentImpl exeEnv) {
		ProcessExecutableObjectImpl exeObj;

		/* Prepare the executable object */
		exeObj = new ProcessExecutableObjectImpl();
		exeObj.init();
		exeObj.setName("Java test case #1");
		exeObj.setExe("E:\\jdk1.3.1\\bin\\java.exe");
		exeObj.setArgs("InOut");
		exeObj.setLocation("E:\\shared");
		runProcess(exeEnv, exeObj, true);
	}

	public void test02(ExecutionEnvironmentImpl exeEnv) {
		ProcessExecutableObjectImpl exeObj;

		/* Prepare the executable object */
		exeObj = new ProcessExecutableObjectImpl();
		exeObj.init();
		exeObj.setName("Java test case #2");
		exeObj.setExe("E:\\jdk1.3.1\\bin\\java.exe");
		exeObj.setArgs("PerformanceExample");
		exeObj.setLocation("E:\\shared");
		runProcess(exeEnv, exeObj, false);
	}

	public void test03(ExecutionEnvironmentImpl exeEnv) {
		ProcessExecutableObjectImpl exeObj;

		/* Prepare the executable object */
		exeObj = new ProcessExecutableObjectImpl();
		exeObj.init();
		exeObj.setName("Java test case #3");
		exeObj.setExe("E:\\jdk1.3.1\\bin\\java.exe");
		exeObj.setArgs("GetJavaProperties");
		exeObj.setLocation("E:\\shared");
		runProcess(exeEnv, exeObj, true);
	}

	public void test01Linux(ExecutionEnvironmentImpl exeEnv) {
		ProcessExecutableObjectImpl exeObj;

		/* Prepare the executable object */
		exeObj = new ProcessExecutableObjectImpl();
		exeObj.init();
		exeObj.setName("Java test case #1 (Linux)");
		exeObj.setExe("/opt/IBMJava2-131/bin/java");
		exeObj.setArgs("InOut");
		exeObj.setLocation("/tmp");
		runProcess(exeEnv, exeObj, true);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener#stateChanged(org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent)
	 */
	public void stateChanged(ExecutionComponentStateChangeEvent newState) {
		if(newState.getState()==IExecutionComponent.DEAD && (newState.getComponent() instanceof IExecutor )) {
			int pid = new Integer(((ProcessExecutorImpl)newState.getComponent()).getPid()).intValue();
			System.out.println("Test case process completed: " + pid);
		}
		
	}
}
