/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: UserConsole.java,v 1.2 2005/02/25 22:17:43 hleung Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

package org.eclipse.hyades.test.collection.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 * @author IBM
 *
 * Class used to handle standard input, output and error from the process
 */
public class UserConsole {
	private PrintWriter bStdin = null;
	private InputStream stdout = null;
	private InputStream stderr = null;
	private InThread in;
	private OutThread out;
	private ErrThread err;

	public UserConsole() {
		in = new InThread();
		out = new OutThread();
		err = new ErrThread();

		in.setDaemon(true);
		out.setDaemon(true);
		err.setDaemon(true);
	}

	public void setStdin(OutputStream out) {
		bStdin = new PrintWriter(new OutputStreamWriter(out));
	}

	public void setStdout(InputStream in) {
		stdout = in;
	}

	public void setStderr(InputStream in) {
		stderr = in;
	}

	public void start() {
		in.start();
		out.start();
		err.start();
	}

	class InThread extends Thread {
		public InThread() {
			setName("stdin");
		}

		public void run() {
			BufferedReader bRead = new BufferedReader(new InputStreamReader(System.in));
			String str;

			if(bStdin == null) {
				return;
			}

			while(true) {
				try {
					str = bRead.readLine();
					bStdin.println(str);
					bStdin.flush();
				} catch (IOException e) {
					e.printStackTrace();
					break;
				}
			}
		}
	}

	class OutThread extends Thread {
		public OutThread() {
			setName("stdout");
		}

		public void run() {
			int b;

			if(stdout == null)
				return;

			try {
				while((b = stdout.read()) != -1) {
					System.out.print((char)b);
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	class ErrThread extends Thread {
		public ErrThread() {
			setName("stderr");
		}

		public void run() {
			int b;

			if(stderr == null)
				return;

			try {
				while((b = stderr.read()) != -1) {
					System.err.print((char)b);
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}
