/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportStylesPreferencePage.java,v 1.8 2008/05/09 21:15:43 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.report;

import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.StylesInitializer;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.signals.internal.Signal;
import org.eclipse.tptp.platform.report.ui.swt.widgets.internal.StylesFieldEditor;
import org.eclipse.tptp.test.samples.SamplesPlugin;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * ReportStylesPreferencePage.java
 * <p/>
 * 
 * 
 * @author     Paul E. Slauenwhite
 * @author     Patrick Nedelec
 * @version    May 9, 2008
 * @since      June 6, 2005
 * @see        PreferencePage
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class ReportStylesPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {

	private LocalStylesFieldEditor recentStylesEditor;
    
    public static final String ID = "ReportView.Preferences";
    
    public static Signal sig_asv_graphic_style_chgd = new Signal("valueChanged()"); //$NON-NLS-1$

	private DStyleRegistry registry = null;

	public ReportStylesPreferencePage() {
	}

	public void init(IWorkbench workbench)  {
		this.registry = StylesInitializer.getCurrentReportStyles();
	}
        
	public boolean performOk() {

		sig_asv_graphic_style_chgd.setBlocked(true);
		this.recentStylesEditor.store();	
		sig_asv_graphic_style_chgd.setBlocked(false);
		sig_asv_graphic_style_chgd.emit();
		return true;
	}
	
	public void createControl(Composite parent) {
		super.createControl(parent);
	}
	
	protected void performDefaults() {
		this.recentStylesEditor.loadDefault();	
	}
	
	/**
	 * @see PreferencePage#createContents
	 */
	protected Control createContents(Composite parent)  {
				
		SamplesPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(parent, SamplesPlugin.getID() + ".ptrf001");

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayoutData(GridDataUtil.createFill());
		composite.setLayout(new GridLayout());

		final Group sampleReportFontGroup = new Group(composite, SWT.SHADOW_ETCHED_IN);
		sampleReportFontGroup.setLayout(new GridLayout());
		sampleReportFontGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		sampleReportFontGroup.setText(SamplesPluginResourceBundle.TEST_REPORT_FONT_PREFERENCES_GROUP_NAME);
		
		this.recentStylesEditor = new LocalStylesFieldEditor(ReportStylesPreferencePage.ID, "message", sampleReportFontGroup); //$NON-NLS-1$
		this.recentStylesEditor.setStylesRegistry(this.registry);
		this.recentStylesEditor.setPreferenceStore(SamplesPlugin.getDefault().getPreferenceStore());
		this.recentStylesEditor.setPage(this);

        Dialog.applyDialogFont( composite );
		return composite;
	}
	
	private class LocalStylesFieldEditor extends StylesFieldEditor
	{
		public LocalStylesFieldEditor(String name, String labelText,
				Composite parent) {
			super(name, labelText, parent);
		}
		public  void loadDefault() {
			super.loadDefault();
			this.setPresentsDefaultValue(false);
		}
	}
}