/*******************************************************************************
 * Copyright (c) 2004, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportWindowWizardPage.java,v 1.12 2009/08/12 12:02:53 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.report;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

import com.ibm.icu.util.Calendar;

/**
 * Page one of the wizard for soliciting the report window from the user.
 * <p>
 * The report window consists of a start date and time and 
 * an end date and time (UTC).  The window is used to resolve 
 * execution results for a test suite within a finite period of time.
 * <p>
 * Page one solicits from the user the start date and time and an end 
 * date and time in the local time zone.  The report window is set by the 
 * user using <code>org.eclipse.swt.widgets.DateTime<code> widgets.
 * <p>
 * 
 * 
 * @author     Paul E. Slauenwhite
 * @author     Patrick Nedelec
 * @version    August 12, 2009
 * @since      November 23, 2004
 * @see        org.eclipse.jface.wizard.WizardPage
 * @see        org.eclipse.hyades.test.tools.ui.common.internal.report.ReportWindowWizard
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class ReportWindowWizardPage extends WizardPage {
    
	private long startTime = -1;
	private long endTime = -1;
    
    /**
     * No-argument constructor.
     */
    public ReportWindowWizardPage() {
        
    	super("Report Window Wizard Page"); //$NON-NLS-1$
        
    	setTitle(SamplesPluginResourceBundle.ReportWindowWizardPage_Title); 
        
    	setDescription(SamplesPluginResourceBundle.ReportWindowWizardPage_Description); 
    }

    /**
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    public void createControl(Composite parent) {
    	
    	Composite pane = new Composite(parent, SWT.NONE);
        pane.setLayout(getGridLayout(2, 5, 10));
        pane.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

        Group startDateTimeGroup = new Group(pane, SWT.SHADOW_NONE);
	    startDateTimeGroup.setLayout(getGridLayout(1, 10, 10));
	    startDateTimeGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	    startDateTimeGroup.setText(SamplesPluginResourceBundle.ReportWindowWizardPage_LABEL_STARTTIME);

	    Calendar currentDateTimeCalendar = Calendar.getInstance();
	    currentDateTimeCalendar.set(Calendar.MILLISECOND, 0);
	    
        //Initialize the start date to the current date:
		final DateTime startDateSelector = new DateTime (startDateTimeGroup, SWT.CALENDAR);
        startDateSelector.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));
        startDateSelector.setYear(currentDateTimeCalendar.get(Calendar.YEAR));
        startDateSelector.setMonth(currentDateTimeCalendar.get(Calendar.MONTH));
        startDateSelector.setDay(currentDateTimeCalendar.get(Calendar.DAY_OF_MONTH));
        startDateSelector.setFocus();
                
        //Initialize the start time to 12:00.00 AM of the current date:
		final DateTime startTimeSelector = new DateTime (startDateTimeGroup, (SWT.TIME | SWT.SHORT));
		startTimeSelector.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false));
		startTimeSelector.setHours(0);
		startTimeSelector.setMinutes(0);
		startTimeSelector.setSeconds(0);

        Group endDateTimeGroup = new Group(pane, SWT.SHADOW_NONE);
	    endDateTimeGroup.setLayout(getGridLayout(1, 10, 10));
	    endDateTimeGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	    endDateTimeGroup.setText(SamplesPluginResourceBundle.ReportWindowWizardPage_LABEL_ENDTIME);

	    //Initialize the end date to the current date:
		final DateTime endDateSelector = new DateTime (endDateTimeGroup, SWT.CALENDAR);
		endDateSelector.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));
		endDateSelector.setYear(currentDateTimeCalendar.get(Calendar.YEAR));
		endDateSelector.setMonth(currentDateTimeCalendar.get(Calendar.MONTH));
		endDateSelector.setDay(currentDateTimeCalendar.get(Calendar.DAY_OF_MONTH));
		endDateSelector.setFocus();

        //Initialize the end time to the current time:
		final DateTime endTimeSelector = new DateTime (endDateTimeGroup, (SWT.TIME | SWT.SHORT));
		endTimeSelector.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false));
		endTimeSelector.setHours(currentDateTimeCalendar.get(Calendar.HOUR_OF_DAY));
		endTimeSelector.setMinutes(currentDateTimeCalendar.get(Calendar.MINUTE));
		endTimeSelector.setSeconds(currentDateTimeCalendar.get(Calendar.SECOND));

        //Initialize the end date and time to the current date and time:
        endTime = currentDateTimeCalendar.getTimeInMillis();

        //Initialize the start date and time to 12:00.00 AM of the current date:
        currentDateTimeCalendar.set(Calendar.HOUR_OF_DAY, 0);
        currentDateTimeCalendar.set(Calendar.MINUTE, 0);
        currentDateTimeCalendar.set(Calendar.SECOND, 0);
       
        startTime = currentDateTimeCalendar.getTimeInMillis();

        SelectionListener dateTimeSelectionListener = new SelectionListener() {

        	public void widgetSelected(SelectionEvent e){
        		verifyDateTimes();
        	}
        	
        	public void widgetDefaultSelected(SelectionEvent e){
        		verifyDateTimes();
        	}
        	
        	private void verifyDateTimes(){

        		Calendar startDateTimeCalendar = Calendar.getInstance();
        		startDateTimeCalendar.set(Calendar.YEAR, startDateSelector.getYear());
        		startDateTimeCalendar.set(Calendar.MONTH, startDateSelector.getMonth());
        		startDateTimeCalendar.set(Calendar.DAY_OF_MONTH, startDateSelector.getDay());
        		startDateTimeCalendar.set(Calendar.HOUR_OF_DAY, startTimeSelector.getHours());
        		startDateTimeCalendar.set(Calendar.MINUTE, startTimeSelector.getMinutes());
        		startDateTimeCalendar.set(Calendar.SECOND, startTimeSelector.getSeconds());
        		startDateTimeCalendar.set(Calendar.MILLISECOND, 0);        
        		
        		startTime = startDateTimeCalendar.getTimeInMillis();

        		Calendar endDateTimeCalendar = Calendar.getInstance();
        		endDateTimeCalendar.set(Calendar.YEAR, endDateSelector.getYear());
        		endDateTimeCalendar.set(Calendar.MONTH, endDateSelector.getMonth());
        		endDateTimeCalendar.set(Calendar.DAY_OF_MONTH, endDateSelector.getDay());
        		endDateTimeCalendar.set(Calendar.HOUR_OF_DAY, endTimeSelector.getHours());
        		endDateTimeCalendar.set(Calendar.MINUTE, endTimeSelector.getMinutes());
        		endDateTimeCalendar.set(Calendar.SECOND, endTimeSelector.getSeconds());
        		endDateTimeCalendar.set(Calendar.MILLISECOND, 0);        
        		
        		endTime = endDateTimeCalendar.getTimeInMillis();

        		setErrorMessage(null);
        		setPageComplete(false);

        		if (endTime <= startTime) {
					setErrorMessage(SamplesPluginResourceBundle.ReportWindowWizardPage_DATE_ERROR_);
				} 
        		else {
					setPageComplete(true);
				}
        	}
        };

        startDateSelector.addSelectionListener(dateTimeSelectionListener);
        startTimeSelector.addSelectionListener(dateTimeSelectionListener);

        endDateSelector.addSelectionListener(dateTimeSelectionListener);
        endTimeSelector.addSelectionListener(dateTimeSelectionListener);

        pane.layout(false,true);
        
        setControl(pane);
    }

    /**
     * Retrieves the start date and time in milliseconds (UTC) of the 
     * report window.
     * <p>
     * 
     * @return The start date and time in milliseconds (UTC).
     */
    public long getStartTime() {
        return startTime;
    }

    /**
     * Retrieves the end date and time in milliseconds (UTC) of the 
     * report window.
     * <p>
     * 
     * @return The end date and time in milliseconds (UTC).
     */
    public long getEndTime() {
        return endTime;
    }

    private GridLayout getGridLayout(int numColumns, int margin, int spacing){
		
		GridLayout gridLayout = new GridLayout(numColumns, true);
		
		gridLayout.marginWidth = margin;
		gridLayout.marginHeight = margin;
				
		gridLayout.horizontalSpacing = spacing;
		gridLayout.verticalSpacing = spacing;
		
		return gridLayout;
	}    
}
