/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionVisitor.java,v 1.9 2010/02/03 13:56:23 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import java.util.Iterator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.test.tools.ui.common.internal.report.DescendingVisitor;
import org.eclipse.hyades.test.tools.ui.common.internal.report.Visitor;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

/**
 * <p>Visits a test log to create a part of the final JScrib document.</p>
 * 
 * 
 * @author     Patrick Nedelec
 * @author     Paul E. Slauenwhite
 * @version    February 3, 2010
 * @since      June 6, 2005
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class ExecutionVisitor extends DescendingVisitor implements Visitor {
    private TPFExecutionResult executionResult;
    private DItem parentItem;
    private int[] resultsSet;
    private JscribWriter jscribWriter;
    private TestSuiteVisitor testSuiteVisitor;

    /**
     * @param jscribWriter
     */
    public ExecutionVisitor(JscribWriter jscribWriter) {
        this.jscribWriter = jscribWriter;
    }

    /**
     * @see org.eclipse.hyades.test.tools.ui.common.internal.report.Visitor#visit(org.eclipse.hyades.test.tools.ui.common.internal.report.DescendingVisitor, java.lang.Object, org.eclipse.tptp.platform.report.core.internal.DItem)
     */
    public void visit(DescendingVisitor dvisitor, Object data, DItem parent) throws Exception {
        if (data instanceof TPFExecutionResult && dvisitor instanceof TestSuiteVisitor) {
            this.executionResult = (TPFExecutionResult) data;
            this.parentItem = parent;
            this.testSuiteVisitor = (TestSuiteVisitor) dvisitor;
            visit();
        } else {
            throw new Exception("ExecutionVisitor: invalid object"); //$NON-NLS-1$
        }
    }

    private void visit() {
        DRow row = new DRow();

        DCellText previousCell = null;
        IDStyle cellStyle = jscribWriter.getStyle(SamplesPluginResourceBundle.StylesInitializer_NORMAL_CELL);
        String[] contents = getRowData();
        for (int i = 0, max = contents.length; i < max; i++) {
            DCellText cell = new DCellText(contents[i]);
            cell.setStyle(cellStyle);
            row.insertChild(cell, previousCell);
            previousCell = cell;
        }
        DCellText rateCell = jscribWriter.generateRateCell(resultsSet[0], resultsSet[4], false, cellStyle);
        row.insertChild(rateCell, previousCell);
        parentItem.addChild(row);
    }

    private String[] getRowData() {
        resultsSet = new int[5];
        Iterator it = ReportDataUtils.findAllVerdictEvents(executionResult.getExecutionHistory()).iterator();
        while (it.hasNext()) {
            TPFVerdict verdict = ((TPFVerdict) (it.next()));
            switch (verdict.getValue()) {
                case TPFVerdict.PASS:
                    resultsSet[0]++;
                    break;
                case TPFVerdict.INCONCLUSIVE:
                    resultsSet[1]++;
                    break;
                case TPFVerdict.FAIL:
                    resultsSet[2]++;
                    break;
                case TPFVerdict.ERROR:
                    resultsSet[3]++;
                    break;
            }
        }
        resultsSet[4] = (resultsSet[0] + resultsSet[1] + resultsSet[2] + resultsSet[3]);

        return new String[] { getExecutionValue(), getDateValue(), ReportDataUtils.normalize(resultsSet[0]), ReportDataUtils.normalize(resultsSet[1]),
                ReportDataUtils.normalize(resultsSet[2]), ReportDataUtils.normalize(resultsSet[3]), ReportDataUtils.normalize(resultsSet[4])};
    }

    private String getDateValue() {
    	return (EventUtil.getTime(((TPFExecutionEvent)(executionResult.getExecutionHistory().getExecutionEvents().get(0))).getTimestamp()));
    }

    /**
     * @return
     */
    private String getExecutionValue() {
        return executionResult.getName();
    }

    /**
     * @see org.eclipse.hyades.test.tools.ui.common.internal.report.Visitor#postVisit()
     */
    public void postVisit() {
        int[] res = new int[] { resultsSet[0], resultsSet[1], resultsSet[2], resultsSet[3]};
        testSuiteVisitor.addToResults(res);
        jscribWriter.resultsByExecutionMap.put(executionResult, res);
    }

}
