/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportGraphicUtils.java,v 1.10 2009/04/29 12:40:37 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;

/**
 * <p>Utility class for generating JScrib report graphics.</p>
 * 
 * 
 * @author     Patrick Nedelec
 * @author     Paul E. Slauenwhite
 * @version    April 29, 2009
 * @since      June 6, 2005
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class ReportGraphicUtils {

    public static DItem createTitle(String title, int level, IDStyle style, DImage image) {
        DItem ret = new DTitle(level);
        ret.addChild(new DText((image != null) ? title + " " : title)); //$NON-NLS-1$
        ((DTitle) ret).setStyle(style);
        if (image != null && !image.equals("")) { //$NON-NLS-1$
            ret.addChild(image);
        }
        return ret;
    }

    public static DCell createStyledCell(IDStyle cellStyle, int align, String text) {
        return createStyledCell(cellStyle, null, align, text);
    }

    public static DCell createStyledCell(IDStyle cellStyle, IDStyle textStyle, int align, String text) {
        DCell cell = new DCell();
        cell.setStyle(cellStyle);
        DParagraph p = new DParagraph(align);
        DText dtext = new DText(text);
        if (textStyle != null) {
            dtext.setStyle(textStyle);
        }
        p.addChild(dtext);
        cell.addChild(p);
        return cell;
    }

    public static DCell createReportLinksCell(Collection testSuites, IDStyle textStyle, IDStyle hLinkStyle) {

    	DParagraph testSuitesCell = new DParagraph(IDAlignment.LEFT);
        
    	DCell reportLinksCell = new DCell();
        reportLinksCell.addChild(testSuitesCell);

        DLink current = null;
        IDItem previous = null;
        
        Iterator testSuitesIterator = testSuites.iterator();
        
        while(testSuitesIterator.hasNext()) {
            
        	TPFTestSuite testSuite = ((TPFTestSuite)(testSuitesIterator.next()));
            
        	String location = ""; //$NON-NLS-1$ 
            
        	Resource resource = testSuite.eResource();
            
        	if (resource != null) {
            
            	IFile workspaceFile = EMFUtil.getWorkspaceFile(resource.getURI());
                
            	if (workspaceFile != null) {
                
            		IPath locPath = workspaceFile.getLocation();
                    
            		if (locPath != null) {
                        location = locPath.toOSString();
                    }
                }
            }
            
            current = new DLink(location); 
            current.addChild(new DText(testSuite.getName()));
            current.setStyle(hLinkStyle);
            
            testSuitesCell.insertChild(current, previous);
            
            if(testSuitesIterator.hasNext()){

            	DText txt = new DText(", "); //$NON-NLS-1$ 
               
            	testSuitesCell.insertChild(txt, current);
            	
            	previous = txt;
            }
            else{
            	previous = current;
            }       
        }
        
        return reportLinksCell;
    }
}
