/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StylesInitializer.java,v 1.12 2009/05/17 16:16:23 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;

import org.eclipse.hyades.test.tools.ui.common.internal.report.ReportStylesPreferencePage;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDXmlParserAdapter;
import org.eclipse.tptp.test.samples.SamplesPlugin;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;
import org.eclipse.xsd.util.XSDParser;

/**
 * <p>This class initializes default styles used in the JScrib document.</p>
 * 
 * 
 * @author     Patrick Nedelec
 * @author     Paul E. Slauenwhite
 * @version    May 16, 2009
 * @since      June 6, 2005
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class StylesInitializer {

    private static DStyleRegistry defaultRegistry = null;

    public static DStyleRegistry getDefaultReportStyles() {
        if (defaultRegistry == null) {
            defaultRegistry = new StylesInitializer().initStyles();
        }
        return defaultRegistry;
    }

    /** initialise the IPalette from the SVG palette definition */
    /*private Palette createPalette(DefaultResources resources, Locale locale)
    {
        SVGColorPalettes palettes = new SVGColorPalettes(resources, locale);
        palettes.setCustomPalettes(resources.getResourceDir(),
                                   resources.getDefaultPalettesId(), 
                                   resources.getDefaultPaletteSetId().toString());
        int pal[] = new int[palettes.getPalette().length];
        for (int i=0; i<palettes.getPalette().length; i++)
        {
            DColor c = new DColor();
            c.serializeFromString(palettes.getPalette()[i]);
            pal[i] = (c.getRGBA()>>8);
        }
        return  new Palette(pal);
    }*/
    
    private DStyleRegistry initStyles() {
        
        // init palettes from SVG palette definition
        //DefaultResources resources = new DefaultResources();
        //Locale locale = Locale.getDefault();
        //Palette pal = createPalette(resources, locale);
        
        DStyleRegistry registry = new DStyleRegistry();

        //- Colors
        DColor white = new DColor(255, 255, 255);
        DColor black = new DColor(0, 0, 0);
        DColor gray = new DColor(220, 220, 220);
        DColor blue = new DColor(0, 128, 255);
        
        DColor colorPass = new DColor(TestUIConstants.COLOR_PASS.red, TestUIConstants.COLOR_PASS.green, TestUIConstants.COLOR_PASS.blue);
        DColor colorFail = new DColor(TestUIConstants.COLOR_FAIL.red, TestUIConstants.COLOR_FAIL.green, TestUIConstants.COLOR_FAIL.blue);
        DColor colorInconclusive = new DColor(TestUIConstants.COLOR_INCONCLUSIVE.red, TestUIConstants.COLOR_INCONCLUSIVE.green, TestUIConstants.COLOR_INCONCLUSIVE.blue);
        DColor colorError = new DColor(TestUIConstants.COLOR_ERROR.red, TestUIConstants.COLOR_ERROR.green, TestUIConstants.COLOR_ERROR.blue);

        //- Fonts
        int height = 10;
        try {
            Font font = JFaceResources.getTextFont();
            FontData dfont = font.getFontData()[0];
            height = dfont.getHeight();
        } catch (Throwable e) {
            //- Nothing to do -> Nominal in non-UI mode
        }
        DFont title1Font = new DFont("title1Font", null, 20, IDFont.BOLD); //$NON-NLS-1$
        DFont title2Font = new DFont("title2Font", null, 16, IDFont.BOLD); //$NON-NLS-1$
        DFont title3Font = new DFont("title3Font", null, 12, IDFont.BOLD); //$NON-NLS-1$
        DFont normalFont = new DFont("normalFont", null, height, IDFont.NORMAL); //$NON-NLS-1$
        DFont chartFont = new DFont("axisFont", null, height, IDFont.BOLD); //$NON-NLS-1$
        DFont linkFont = new DFont("linkFont", null, height, IDFont.UNDERLINE); //$NON-NLS-1$
        DFont headerFont = new DFont("headerFont", null, height, IDFont.BOLD); //$NON-NLS-1$
        DFont gerrorFont = new DFont("gerrorFont", null, height,IDFont.BOLD|IDFont.ITALIC); //$NON-NLS-1$

        //- Styles
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE1, title1Font, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE2, title2Font, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE3, title3Font, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_PASS, normalFont, colorPass, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL, normalFont, colorFail, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE, normalFont, colorInconclusive, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR, normalFont, colorError, white)); 
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_PASS_CELL, normalFont, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL_CELL, normalFont, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE_CELL, normalFont, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR_CELL, normalFont, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_PASS_CELL_TEXT, normalFont, colorPass, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_FAIL_CELL_TEXT, normalFont, colorFail, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_INCONCLUSIVE_CELL_TEXT, normalFont, colorInconclusive, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_ERROR_CELL_TEXT, normalFont, colorError, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_CHART_TITLE, chartFont, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_HEADER_CELL, headerFont, black, gray));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_NORMAL_CELL, normalFont, black, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_LINK_CELL, linkFont, blue, white));
        registry.putStyle(new DStyle(SamplesPluginResourceBundle.StylesInitializer_GENERATION_ERROR, gerrorFont, colorError, white));

        return registry;
    }
    
    static DStyleRegistry graphicregistry = null;
    
    public static DStyleRegistry getCurrentReportStyles()
    {
        if(graphicregistry != null)
            return graphicregistry;
        graphicregistry = getDefaultReportStyles();
        String txt = SamplesPlugin.getDefault().getPreferenceStore().getString(ReportStylesPreferencePage.ID); //$NON-NLS-1$);

        if((txt!=null)&&(txt.length()>0)){
            DXmlReader reader = new DXmlReader(new XSDXmlParserAdapter( new XSDParser()) );
            ByteArrayInputStream buf = new ByteArrayInputStream(txt.getBytes());
            try{
                reader.read( buf );
                DStyleRegistry newregistry = reader.getStyleRegistry();
                if(newregistry != null){
                    Iterator i = newregistry.iterator();
                    while (i.hasNext())
                    {
                        Object s = i.next();
                        if (s instanceof IDStyle){
                            java.util.List sol = graphicregistry.getStyles(((IDStyle)s).getName());
                            if((sol != null)&&(sol.size()>0)){
                                Iterator j = sol.iterator();
                                while (j.hasNext())
                                {
                                    Object so = j.next();
                                    if (so instanceof IDStyle){
                                        ((IDStyle)so).setBackColor(((IDStyle)s).getBackColor());
                                        ((IDStyle)so).setForeColor(((IDStyle)s).getForeColor());
                                        ((IDStyle)so).setFont(((IDStyle)s).getFont());
                                        ((IDStyle)so).setNumberingFormat(((IDStyle)s).getNumberingFormat());
                                        ((IDStyle)so).setWallpaper(((IDStyle)s).getWallpaper());
                                    }
                                }
                            }else{
                                graphicregistry.putStyle((IDStyle)s);
                            }
                        }
                    }
                }
            }
            catch(Exception e)
            {
                e.printStackTrace();     
            }
        }
        return graphicregistry;
    }

    public static void initializeDefaultPreferences(IPreferenceStore store)
    {
        DXmlWriter aw = new DXmlWriter();
        
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try{
          aw.write(buf, getDefaultReportStyles());
        }catch(Exception e){
        }
        store.setDefault(ReportStylesPreferencePage.ID,buf.toString());
    }
    
}
