/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteVisitor.java,v 1.5 2010/02/03 13:56:23 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.test.tools.ui.common.internal.report.DescendingVisitor;
import org.eclipse.hyades.test.tools.ui.common.internal.report.Visitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFolderModel;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

/**
 * This visitor visits a test (TPFTestSuite) and create a part of the final JScrib document.
 * <p/>
 * 
 * 
 * @author     Patrick Nedelec
 * @author     Paul E. Slauenwhite
 * @version    February 3, 2010
 * @since      June 6, 2005
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class TestSuiteVisitor extends DescendingVisitor implements Visitor {

    private TPFTestSuite testSuite;
    private DItem parentItem;
    private HashMap executionsByTestsuiteMap;
    private long startTime;
    private long endTime;
    private JscribWriter jscribWriter;
    private int[] resultSet;
    private List execList;

    public TestSuiteVisitor(Map executionsByTestsuiteMap, long startTime, long endTime) {
        this.executionsByTestsuiteMap = new HashMap();
        this.executionsByTestsuiteMap.putAll(executionsByTestsuiteMap);
        this.startTime = startTime;
        this.endTime = endTime;
        this.resultSet = new int[4];
        this.execList = new LinkedList();
    }

    /**
     * @see org.eclipse.hyades.test.tools.ui.common.internal.report.Visitor#visit(org.eclipse.hyades.test.tools.ui.common.internal.report.DescendingVisitor, java.lang.Object, org.eclipse.tptp.platform.report.core.internal.DItem)
     */
    public void visit(DescendingVisitor dvisitor, Object data, DItem parent) throws Exception {
        if (data instanceof TPFTestSuite && dvisitor instanceof JscribWriter) {
            testSuite = (TPFTestSuite) data;
            parentItem = parent;
            jscribWriter = (JscribWriter) dvisitor;
            visit();
        } else {
            throw new Exception("TestSuiteVisitor: invalid object"); //$NON-NLS-1$
        }
    }

    private void visit() throws Exception {
        DFolder folder = new DFolder(true);
        folder.setFolderModel(new DFolderModel(true, new ISymbol.Minus(), new ISymbol.Plus()));
        DParagraph paragraph = new DParagraph();
        DItem title = ReportGraphicUtils.createTitle(NLS.bind(SamplesPluginResourceBundle.TestSuiteVisitor_TestSuite, testSuite.getName()), 2, 
                jscribWriter.getStyle(SamplesPluginResourceBundle.StylesInitializer_TITLE2), null);

        //- By executions part
        DParagraph byExecutionParagraph = new DParagraph();
        DTable byExecutionTable = new DTable();

        //- Create table headers
        DRow row = new DRow();
        DCellText previousCell = null;
        String[] headers = new String[] {
                SamplesPluginResourceBundle.TestSuiteVisitor_Execution, SamplesPluginResourceBundle.TestSuiteVisitor_Date, 
                SamplesPluginResourceBundle.JScribWriter_Pass, SamplesPluginResourceBundle.JScribWriter_Inconclusive, SamplesPluginResourceBundle.JScribWriter_Fail, SamplesPluginResourceBundle.JScribWriter_Error, 
                SamplesPluginResourceBundle.TestSuiteVisitor_Attempted, 
                SamplesPluginResourceBundle.TestSuiteVisitor_PassRate}; 
        for (int i = 0, max = headers.length; i < max; i++) {
            DCellText cell = new DCellText(headers[i]);
            cell.setStyle(jscribWriter.getStyle(SamplesPluginResourceBundle.StylesInitializer_HEADER_CELL));
            row.insertChild(cell, previousCell);
            previousCell = cell;
        }
        byExecutionTable.addChild(row);

        Iterator executionResultsIterator = ReportDataUtils.getExecutionResultsForWindow(((List) (executionsByTestsuiteMap.get(testSuite))), startTime, endTime).iterator();
        //Only report on test suites with one or more execution results for the report window:
        while (executionResultsIterator.hasNext()) {
            TPFExecutionResult executionResult = ((TPFExecutionResult) (executionResultsIterator.next()));
            accept(new ExecutionVisitor(jscribWriter), executionResult, byExecutionTable);
            execList.add(executionResult);
        }

        //- Verdict paragraph
        DParagraph verdictParagraph = new DParagraph();
        int verdict = ReportDataUtils.getVerdict(resultSet);
        verdictParagraph.setStyle(jscribWriter.getVerdictCellStyle(verdict));
        DText verdictText = new DText("\n" + NLS.bind(SamplesPluginResourceBundle.TestSuiteVisitor_Verdict, jscribWriter.getVerdictLabel(verdict)) + "\n"); 
        DText execText = new DText(NLS.bind(SamplesPluginResourceBundle.TestSuiteVisitor_NumberOfTestLogs, ReportDataUtils.normalize(execList.size())) + "\n\n"); 
        verdictParagraph.addChild(verdictText);
        verdictParagraph.addChild(execText);
        if (verdict == TPFVerdict.PASS) {
            //- Collapse all the 'passed' Test Suites
            folder.setOpen(false);
        }

        //- Organize document
        paragraph.addChild(verdictParagraph);
        byExecutionParagraph.addChild(byExecutionTable);
        paragraph.addChild(byExecutionParagraph);
        paragraph.addChild(new DText("\n")); //$NON-NLS-1$
        
        folder.addChild(title);
        folder.addChild(paragraph);
        
        parentItem.addChild(folder);
    }

    /**
     * @see org.eclipse.hyades.test.tools.ui.common.internal.report.Visitor#postVisit()
     */
    public void postVisit() {
        jscribWriter.resultsByTestSuiteMap.put(testSuite, resultSet);
        jscribWriter.execsByTestSuiteMap.put(testSuite, execList);
        jscribWriter.addToResults(resultSet);
    }

    public void addToResults(int[] newResultSet) {
        for (int i = 0, max = resultSet.length; i < max; i++) {
            this.resultSet[i] += newResultSet[i];
        }
    }

}
