/*******************************************************************************
 * Copyright (c) 2008, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractHTTPPageReportGeneratorWizard.java,v 1.2 2010/05/05 12:32:04 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.reports;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

/**
 * <p>AbstractHTTPPageReportGeneratorWizard.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version May 4, 2010
 * @since   April 10, 2008
 */
public abstract class AbstractHTTPPageReportGeneratorWizard extends ReportGeneratorWizard {

	protected TPFExecutionResult result = null;

	private TestLocationPage testLocationPage = null;
    private EList selectedTestSuites = null;

    private final static String FILE_EXTENSION = "html"; //$NON-NLS-1$

    /**
     * Constructor.
     */
    public AbstractHTTPPageReportGeneratorWizard() {
    	super();        
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.ui.report.ReportGeneratorWizard#getEditorId()
     */
    public String getEditorId() {		
		return "org.eclipse.ui.browser.editorSupport"; //$NON-NLS-1$
	}
    
    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {

        testLocationPage = new TestLocationPage("location", adjustLocation()); //$NON-NLS-1$
        testLocationPage.setTitle(UiPluginResourceBundle.WIZ_TST_REP_PG_TTL); 
        testLocationPage.setDescription(UiPluginResourceBundle.WIZ_TST_REP_PG_LOC_DSC); 
        testLocationPage.setFileExtension(FILE_EXTENSION);
    }

    protected IStructuredSelection adjustLocation() {
        
    	IStructuredSelection structuredSelection = getSelection();
        Object selection = structuredSelection.getFirstElement();
        
        if (selection instanceof IResource) {
            
            IContainer parent = ((IResource)(selection)).getParent();
            
            if ((parent != null) && parent.exists()) {
                structuredSelection = new StructuredSelection(parent);
            }
        }
        
        return structuredSelection;
    }

    /**
     * @see org.eclipse.hyades.ui.report.ReportGeneratorWizard#addReportPages()
     */
    protected void addReportPages() throws Exception {
        addPage(testLocationPage);
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#canFinish()
     */
    public boolean canFinish() {
        return (testLocationPage.isPageComplete());
    }

    /**
     * @see org.eclipse.hyades.ui.report.ReportGeneratorWizard#isAvailable(org.eclipse.jface.viewers.ISelection)
     */
    public boolean isAvailable(ISelection selection) {
    	
    	//Step 1: Determine if the selection contains at least one element:
		if ((selection == null) || (selection.isEmpty())){ 
			return false;
		}
		
		//Step 2: Determine if the selection element contains URL test suite(s) and resolve the selected URL test suite(s):
        selectedTestSuites = new BasicEList();
		Iterator selectionIterator = ((IStructuredSelection) (new StructuredSelection(selection).getFirstElement())).iterator();
        
		while (selectionIterator.hasNext()) {
             
            Object testSuiteProxyNode = selectionIterator.next();

            if (testSuiteProxyNode instanceof ITestSuiteProxyNode){
            	
            	TPFTestSuite testSuite = ((ITestSuiteProxyNode) (testSuiteProxyNode)).getTestSuite();
            	
            	if(testSuite.getType().equals(TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE)){
            		selectedTestSuites.add(testSuite);
            	}
                else{

                	selectedTestSuites = null;
        			
        			return false;
                }
            }
            else{

            	selectedTestSuites = null;
    			
    			return false;
            }
        }     
		
		//Step 3: Determine if at least one URL test suite has been selected:
		if(selectedTestSuites.size() == 0){
			
			selectedTestSuites = null;
			
			return false;
		}
		
		return true;
    }
    
    protected void initResultSelection(){
		
		List results = new ArrayList();	
		Iterator selectedTestSuitesIterator = selectedTestSuites.iterator();

		while(selectedTestSuitesIterator.hasNext()){		
			results.addAll(ExecutionUtil.findExecutionResults(((TPFTestSuite)(selectedTestSuitesIterator.next()))));		}
		
		if(results.size() > 1){
			 
			ResultsSelectionWizard wiz = new ResultsSelectionWizard(results);
			 
			new WizardDialog(Display.getDefault().getActiveShell(),wiz).open();			
			
			result = wiz.getSelectedResult();
		 }
		 else if(results.size() == 1){
		 	result = (TPFExecutionResult)results.get(0);
		 }
		 else{
			result = null;
		 }
	}
    
    protected IFile getReportFile() {
        IFile file = null;
        IPath path = testLocationPage.getContainerFullPath();
        IResource res = createContainer(path);
        path = new Path(testLocationPage.getFileName()); //$NON-NLS-1$
        file = ((IContainer) res).getFile(path);
        return file;
    }
    
    private IContainer createContainer(IPath path) {
        IContainer container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();

        for (int idx = 0; idx < segCount; idx++) {
            if (idx == 0) {
                //project
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    //create the project
                    try {
                        project.create(null);
                    } catch (Exception e) {
                        UiPlugin.logError(e);
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                } catch (Exception e) {
                }
                container = project;
            } else // (idx > 1)
            { //folder
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    //create the folder
                    try {
                        folder.create(false, true, null);
                    } catch (Exception e) {
                        UiPlugin.logError(e);
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
        }
        try {
            container.getProject().refreshLocal(IResource.DEPTH_INFINITE, null);
        } catch (CoreException exc) {
            UiPlugin.logError(exc);
            exc.printStackTrace();
        }
        return container;
    }
}
