/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpAbstractReport.java,v 1.3 2010/05/20 13:49:41 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.reports;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.http.runner.HttpExecutor;

/**
 * <p>Abstract parent class for HTTP Reports</p>
 * 
 * 
 * @author  Jeffrey Nevicosi
 * @author  Paul Slauenwhite
 * @version May 20, 2010
 * @since   June 10, 2005
 */
public abstract class HttpAbstractReport {

	protected TPFExecutionResult result = null;
	protected ArrayList list = null;
	
	public static final String responseTimeMarker = HttpExecutor.TIME;
	public static final String pageNameMarker=HttpExecutor.RESPONSE_URL;
	public static final String sysOutTag="System.out:\n";
	public static final String crlf = "\r\n";
	public static final String lf = "\n";
	/**
	 * 
	 */
	public HttpAbstractReport(TPFExecutionResult result) {
		this.result = result;
		
	}

	public void generate() {
		
		list = new ArrayList();
				
		setupReport();
		
		if(result != null){
			recurseGenerate(result.getExecutionHistory().getExecutionEvents());
		}
		
		finishReport();
	}
	/**
	 * Recursively processes a list of execution events, searching for select event types
	 * 
	 * @param list
	 */
	protected void recurseGenerate(EList list)
	{
		Iterator iter = list.iterator();
		
		while (iter.hasNext()) 
		{
			Object tpfObject = iter.next();
			if(tpfObject instanceof TPFMessageEvent)
			{
				processMessageEvent((TPFMessageEvent)tpfObject);
			}
			else if(tpfObject instanceof TPFTypedEvent)
			{
				processTypedEvent((TPFTypedEvent)tpfObject);
			}

			//search for child objects			
			if (tpfObject instanceof TPFInvocationEvent)
			{
				EList rList = ((TPFInvocationEvent)tpfObject).getInvokedExecutionResult()
								.getExecutionHistory().getExecutionEvents();
				if (!rList.isEmpty())
					recurseGenerate(rList);			
			}
			else if (tpfObject instanceof TPFExecutionEvent)
			{
				EList rList = ((TPFExecutionEvent)tpfObject).getChildren();
				if (!rList.isEmpty())
					recurseGenerate(rList);
			}
		}
	}
	
	abstract protected void processMessageEvent(TPFMessageEvent event);
	abstract protected void processTypedEvent(TPFTypedEvent typedEvent);

	abstract protected void setupReport();
	abstract protected void finishReport();
	
	public ArrayList getList() {
		return list;
	}
	
	protected IReportGraphDataProvider findPage(String pageName)
	{
		for (Iterator it = list.iterator(); it.hasNext();)
		{
			IReportGraphDataProvider foo = (IReportGraphDataProvider) it.next();
			if (foo.getId().equals(pageName))
				return foo; 
		}		
		return null;
	}
	
}
