/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportGraph.java,v 1.5 2007/04/26 20:57:57 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.reports;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tptp.platform.report.core.provisional.Generator;
import org.eclipse.tptp.platform.report.core.provisional.IChart;
import org.eclipse.tptp.platform.report.core.provisional.IRenderer;
import org.eclipse.tptp.platform.report.core.provisional.SVGRenderer;
import org.eclipse.tptp.platform.report.core.provisional.SerializerImpl;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author amathur To change the template for this generated type comment go to
 *         Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ReportGraph {
	IFile outputFile = null;

	ArrayList list = null;

	ReportGraphConfiguration config = null;

	public ReportGraph(ArrayList list, ReportGraphConfiguration configuration) {
		this.list = list;
		this.config = configuration;
	}

	/**
	 * This method was disabled (basically all commented out) to help with the
	 * 4.0 migration--this functionality will eventually get replaced by the new
	 * reporting features. Commenting this method out eliminated the
	 * SVGGenerator dependencies and allows the codebase to successfully
	 * compile.
	 * 
	 * @param svgPath
	 * @return
	 * @throws Exception
	 */
public InputStream generate(IPath svgPath)
		throws Exception {
			
		
	
		// Defines a new color palette and initializes it with white in all the
		// positions
		ArrayList colourPalette = new ArrayList(); 

		// creates a Document by collecting information from the Component Test
		// objects
		Document newDoc = generateDataDocument(list, colourPalette);
		if(newDoc == null)
			return null;
		
		// turn the DOM into an SVG chart
// ResourcesPlugin.getWorkspace().getRoot().getFile(svgPath).toString()
		IPath svgGenPath = svgPath.removeFileExtension().addFileExtension("svg"); //$NON-NLS-1$
		FileOutputStream outputStream = new FileOutputStream(ResourcesPlugin.getWorkspace().getRoot().
				getFile(svgGenPath).getLocation().toFile()); 
		IRenderer renderer = new SVGRenderer();
		renderer.setProperty(IRenderer.OUTPUTSTREAM_IDENTIFIER, outputStream);
		IChart chart = SerializerImpl.instance().read(newDoc);
		Generator.instance().run(renderer, chart);

		
		// write the SVG to a file
		IPath svgPathExt = svgPath.removeFileExtension().addFileExtension("svg"); //$NON-NLS-1$
		
// String svgFileName =
// createFile(svgPathExt,svgBarChart.serializeGeneratedDocumentToString(generatedDocument)).getName();
		String svgURL = SamplesPluginResourceBundle.SVG_URL; 
		
		// create the HTML to return to caller
		StringBuffer sb = new StringBuffer();
		sb.append("<html>\n").append("<head>\n").append("<title>").append(getUserText("chart.Title")).append(" </title>").append("</head>\n"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
		sb.append("<body>\n").append("<embed type=\"image/svg+xml\" src=\""); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append(svgPathExt.lastSegment()).append("\" ").append("width=\"").append(config.getMinWidth()).append("\" "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		sb.append("height=\"").append(config.getHeight()).append("\" "); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append("name=\"mySvgDocument\""); //$NON-NLS-1$
		sb.append("/>\n"); //$NON-NLS-1$
		sb.append("<p><font face=\"arial\" font size = \"1\"> ").append(svgURL).append(" </font> <p>"); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append(" </body>").append(" </html>"); //$NON-NLS-1$ //$NON-NLS-2$
		
		ResourcesPlugin.getWorkspace().getRoot().getFile(svgPathExt).refreshLocal(1, new NullProgressMonitor());
// outputFile = createFile(htmlPath, sb.toString());
		//return new ByteArrayInputStream(printDOM(newDoc).toString().getBytes("UTF-8"));
		return new ByteArrayInputStream(sb.toString().getBytes("UTF-8")); //$NON-NLS-1$
		// return null;
	}
	protected Document generateDataDocument(ArrayList list,
			ArrayList colourPalette) throws Exception {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document document = builder.newDocument();

		// create the root element, i.e. configuration

		Element chart = document.createElement("chart"); //$NON-NLS-1$
		chart.setAttribute("width", "800"); //$NON-NLS-1$ //$NON-NLS-2$
		chart.setAttribute("height", "500"); //$NON-NLS-1$ //$NON-NLS-2$
		chart.setAttribute("minWidth", "800"); //$NON-NLS-1$ //$NON-NLS-2$
		chart.setAttribute("minHeight", "500"); //$NON-NLS-1$ //$NON-NLS-2$
		document.appendChild(chart);
		
		Element legend = document.createElement("legend"); //$NON-NLS-1$
		legend.setAttribute("show", "false");  //DOESN'T WORK!! //$NON-NLS-1$ //$NON-NLS-2$
//		legend.setAttribute("label", "");
//		legend.setAttribute("id", "URLlegendid");
		chart.appendChild(legend);
		
		Element chartTitle = document.createElement("chartTitle"); //$NON-NLS-1$
		chartTitle.setAttribute("label", config.getTitle()); //$NON-NLS-1$
		chart.appendChild(chartTitle);

/*		Element timeStamp = document.createElement("timeStamp");
		SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"); 
		//value is in xsd:dateTime format		
		timeStamp.setAttribute("value", dateFormatter.format(new Date()));
		chart.appendChild(timeStamp);
*/		


		Element plotArea = document.createElement("plotArea"); //$NON-NLS-1$
		plotArea.setAttribute("type", "verticalBar"); //$NON-NLS-1$ //$NON-NLS-2$
		chart.appendChild(plotArea);
		
		Element axes = document.createElement("axes"); //$NON-NLS-1$
		plotArea.appendChild(axes);
		
		Element xaxis = document.createElement("axis"); //$NON-NLS-1$
		xaxis.setAttribute("id", "x"); //$NON-NLS-1$ //$NON-NLS-2$
		addAxisCategories(document, xaxis, list);
		axes.appendChild(xaxis);
		
		Element yaxis = document.createElement("axis"); //$NON-NLS-1$
		yaxis.setAttribute("id", "y"); //$NON-NLS-1$ //$NON-NLS-2$
		yaxis.setAttribute("title", config.getYTitle()); //$NON-NLS-1$
		addYSegments(document, yaxis, list);
		axes.appendChild(yaxis);

		Element curves = document.createElement("datasets"); //$NON-NLS-1$
		plotArea.appendChild(curves);
		Element curve = document.createElement("dataset"); //$NON-NLS-1$
		curve.setAttribute("label", "URL.Curve1"); //$NON-NLS-1$ //$NON-NLS-2$
		curves.appendChild(curve);
		for (int i = 0; i < list.size(); i++) {
			createBarData(document, curve, (IReportGraphDataProvider)list.get(i), i);
			
		}
		if (list.size() == 0)
		{ //create default 
			createBarData(document, curve, null, 0);
		}
		/*
		 * if(addBarData(document, dataUpdateElement, position,
		 * getUserText("chart.expectedAttempt"), list)) //$NON-NLS-1$ {
		 * colourPalette.add("#D3D3D3"); //grey //$NON-NLS-1$ position++; } //CR
		 * Temp for TEST createXData(document, dataUpdateElement, list); //
		 * Create the categorization element which contains the information //
		 * related Y axis //CR Temp for TEST createYData(document,
		 * dataUpdateElement, list);
		 */
				
		return document;
	}

	/**
	 * Returns the values that will be presented for the user.
	 * 
	 * @param String
	 *            key The key for the value
	 * @return String the value
	 */
	protected String getUserText(String key) {
		if ("chart.Title".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_1; 

		if ("chart.Legend".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_2; 

		if ("chart.timestampPrefix".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_3; 

		if ("chart.Xtitle".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_4; 

		if ("chart.Ytitle".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_5; 

		if ("chart.attempt".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_6; 

		if ("chart.error".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_7; 

		if ("chart.pass".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_8; 

		if ("chart.fail".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_9; 

		if ("chart.inconclusive".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_10; 

		if ("chart.expectedAttempt".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_11; 

		if ("chart.expectedError".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_12; 

		if ("chart.expectedPass".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_13; 

		if ("chart.expectedFail".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_14; 

		if ("chart.expectedInconclusive".equals(key)) //$NON-NLS-1$
			return SamplesPluginResourceBundle.ReportGraph_15; 

		return key;
	}

	protected void addAxisCategories(Document document, Element axis, ArrayList list)
	{
		Element cats = document.createElement("categories"); //$NON-NLS-1$
		axis.appendChild(cats);
		
		for (int i=0; i < list.size(); i++)
		{
			Element cat = document.createElement("category"); //$NON-NLS-1$
			cat.setAttribute("id", "c"+i); //$NON-NLS-1$ //$NON-NLS-2$
			cats.appendChild(cat);
			String id = ((IReportGraphDataProvider) list.get(i)).getId();
		
			if (id.substring(0,7).equals("http://")) //$NON-NLS-1$
				id = id.substring(7);
			id = id.replaceAll("/", "/ "); //$NON-NLS-1$ //$NON-NLS-2$
			cat.setAttribute("label", id); //$NON-NLS-1$
/*		if (id.length() < 20)
				cat.setAttribute("label", id);
			else
			{
				int n = id.indexOf('/',20);
				if (n == -1)
					n = id.length();
				id = id.substring(0, n);
				cat.setAttribute("label", id);				
			}
*/			
//			cat.setAttribute("tooltip", origId);
		}
		if (list.size() == 0)
		{
			//add an empty category, just to keep metadata valid
			Element cat = document.createElement("category"); //$NON-NLS-1$
			cat.setAttribute("id", "c0"); //$NON-NLS-1$ //$NON-NLS-2$
			cat.setAttribute("label", ""); //$NON-NLS-1$ //$NON-NLS-2$
			cats.appendChild(cat);
		}
	}
	
	protected void addYSegments(Document document, Element axis, ArrayList list)
	{
		
	}
	
	
	protected void createBarData(Document document, Element curve, IReportGraphDataProvider data, int count)
	{

		// TODO: Add curve data
		// curve.setAttribute("type", )
		//Element props = document.createElement("properties");
		//curve.appendChild(props);
		// add point
		Element pt = document.createElement("point"); //$NON-NLS-1$
//		pt.setAttribute("type", "actual");
		curve.appendChild(pt);
		Element coord = document.createElement("coord"); //$NON-NLS-1$
		coord.setAttribute("axis", "y"); //$NON-NLS-1$ //$NON-NLS-2$
		//round to nearest thousandth
		double dbl;
		try {
			Double d;
			if (data == null)
				d = new Double(0);
			else
				d = new Double(data.getValue());
			dbl = (double) (((double)(long)(d.doubleValue()*1000 + .5)) /1000);
		}
		catch (NumberFormatException e)
		{
			dbl = 0;
		}
		
		coord.setAttribute("value", new Double(dbl).toString());		 //$NON-NLS-1$
		pt.appendChild(coord);
		Element coordObj = document.createElement("coord"); //$NON-NLS-1$
		coordObj.setAttribute("axis", "x"); //$NON-NLS-1$ //$NON-NLS-2$
		//coordObj.setAttribute("class", "java.lang.String");
		coordObj.setAttribute("value", "c"+count); //$NON-NLS-1$ //$NON-NLS-2$
		
		pt.appendChild(coordObj);
	}
	/**
	 * Creates a file in the same location and name of the <i>originalFile</i>
	 * but with a different extension.
	 * 
	 * @param String
	 *            IPath the IPath for the generated svg file
	 * @param String
	 *            extension The extension of the new file
	 * @param String
	 *            content The content of the new file.
	 * @return IFile The created file;
	 */
	protected IFile createFile(IPath svgPath, String content)
			throws CoreException {

		IFile file = null;
		try {
			file = ResourcesPlugin.getWorkspace().getRoot().getFile(svgPath);
			ByteArrayInputStream inputStream = null;
			try {
				inputStream = new ByteArrayInputStream(content
						.getBytes("UTF-8")); //$NON-NLS-1$
			} catch (UnsupportedEncodingException e) {
				inputStream = new ByteArrayInputStream(content.getBytes());
			}

			if (file.exists()) {
				try {
					file.setContents(inputStream, true, false,
							new NullProgressMonitor());
				} catch (CoreException e1) {
					e1.printStackTrace();
				}
			} else {
				file.create(inputStream, true, new NullProgressMonitor());
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		return file;
	}

//private StringBuffer printDOM(Node node) {
//	
//	StringBuffer sb = new StringBuffer();
//	if (node.getNodeType() == Node.TEXT_NODE)
//	{
//		sb.append(node.getNodeName());
//		sb.append(node.getNodeValue());
//		return sb;
//	}
//	sb.append("<" + node.getNodeName()); //$NON-NLS-1$
//	if (node.getAttributes() != null)
//	{
//		for (int i=0; i < node.getAttributes().getLength(); i++)	
//		{
//			Node att = node.getAttributes().item(i);
//			sb.append(" ") //$NON-NLS-1$
//				.append(att.getNodeName())
//				.append("=") //$NON-NLS-1$
//				.append(att.getNodeValue());
//		}
//	}
//	sb.append(">\n"); //$NON-NLS-1$
//	Node child = node.getFirstChild();
//	while (child != null)
//	{
//		sb.append(printDOM(child));
//		child = child.getNextSibling();
//	}	
//	sb.append("</").append(node.getNodeName()).append(">"); //$NON-NLS-1$ //$NON-NLS-2$
//	return sb;
//}
}
