/*******************************************************************************
 * Copyright (c) 2008, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HTTPPageHitRateReportGeneratorWizard.java,v 1.3 2010/05/20 13:49:41 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.reports.hitrate;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.AbstractHTTPPageReportGeneratorWizard;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.ReportGraph;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginImageManager;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

/**
 * <p>HTTPPageHitRateReportGeneratorWizard.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version May 20, 2010
 * @since   April 10, 2008
 */
public class HTTPPageHitRateReportGeneratorWizard extends AbstractHTTPPageReportGeneratorWizard {

    /**
     * Constructor.
     */
    public HTTPPageHitRateReportGeneratorWizard() {
        
    	super();
        
    	setWindowTitle(SamplesPluginResourceBundle.ReportWindowWizardPage_Title); 
        setDefaultPageImageDescriptor(SamplesPluginImageManager.getInstance().getImageDescriptor(SamplesPluginImageManager.IMG_WIZBAN_REPORT_WINDOW));
    }
    
    /**
     * @see org.eclipse.hyades.ui.report.ReportGeneratorWizard#generate(org.eclipse.core.runtime.IProgressMonitor)
     */
    public IFile generate(IProgressMonitor monitor) throws Exception {
       
		IFile outputFile = getReportFile();
        
    	try {

    		monitor.beginTask("", 4); //$NON-NLS-1$             

    		initResultSelection();

    		monitor.worked(1);             

    		HitRateReport report = new HitRateReport(result);
    		
    		report.generate();

    		monitor.worked(1);             

    		ReportGraphConfiguration config = setupConfiguration();

    		IPath svgPath = outputFile.getFullPath(); 
    		svgPath.removeFileExtension().addFileExtension("svg");  //$NON-NLS-1$

    		monitor.worked(1);             

    		ReportGraph graph = new ReportGraph(report.getList(),config);		 

            if (outputFile.exists()) {
            	outputFile.delete(true, true, null);
            }
            
            outputFile.create(graph.generate(svgPath), true, null);
            
    		monitor.worked(1);             
    	} 
    	finally {           
            monitor.done();
        }

    	return outputFile;	
    }
    
    private ReportGraphConfiguration setupConfiguration()
	{
		
    	ReportGraphConfiguration config = new ReportGraphConfiguration();
		config.setTitle(SamplesPluginResourceBundle.HitRateReportGenerator_HIT_RATE); 
		config.setXTitle(SamplesPluginResourceBundle.HitRateReportGenerator_PAGE); 
		config.setYTitle(SamplesPluginResourceBundle.HitRateReportGenerator_HITS_SEC); 
		config.setLegendTitle(SamplesPluginResourceBundle.HitRateReportGenerator_LEGEND); 
		config.setTimeStampPrefix(""); //$NON-NLS-1$
		config.setMinWidth(800);
		config.setHeight(500);
		config.setID("org.eclipse.hyades.test.ui.URLTest.HitRateReport");
		
		return config;
	}
}
