/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: SamplesPlugin.java,v 1.13 2008/02/29 01:45:14 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.tptp.test.samples;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.StylesInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The main plug-in class to be used in the desktop.
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @version     February 28, 2008
 * @since       June 6, 2005
 */
public class SamplesPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static SamplesPlugin plugin;
    
	//Resource bundle.
	private ResourceBundle resourceBundle;
    public static final String PLUGIN_ID = "org.eclipse.tptp.test.samples"; //$NON-NLS-1$
	
	/**
	 * The constructor.
	 */
	public SamplesPlugin() {
		//super();
		plugin = this;
	}

    /**
     * Returns the instance of this class created by the eclipse framework.
     * @return HyadesUIPlugin
     */
    public static SamplesPlugin getInstance()
    {
        return plugin;
    }
    
	/**
	 * Returns the shared instance.
	 */
	public static SamplesPlugin getDefault() {
		return plugin;
	}

    /**
     * Resolves the localized message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * Noteworthy, the resultant message is not formatted (e.g. no message parameter substitution). 
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = SamplesPlugin.getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Resolves the plugin's resource bundle.
     * <p>
     * If the plugin's resource bundle can not be resolved, <code>null</code> is returned.
     * <p>
     * IMPORTANT: Do not use this method to retrieve values from the resource bundle.  This method 
     * is provided so this plugin's resource bundle can be used as the parent of another plugin's 
     * resource bundle.
     * <p>
     * 
     * @return The plugin's resource bundle, otherwise <code>null</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null)
                resourceBundle   = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
        return resourceBundle;
    }
    
    /**
     * Resolves the localized message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * Noteworthy, the resultant message is not formatted (e.g. no message parameter substitution). 
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getString(String key)
    {
        return getResourceString(key);
    }
    
    /**
     * Resolves the localized and formatted message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * Message formatting is done by the {@link org.eclipse.osgi.util.NLS} class using the 
     * default locale. 
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @param argument The first message parameter for formatting in the localized and formatted message.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getString(String key, String argument)
    {
        return getString(key, new String[] {argument});
    }   

    /**
     * Resolves the localized and formatted message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * Message formatting is done by the {@link org.eclipse.osgi.util.NLS} class using the 
     * default locale. 
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @param arguments The array of message parameters for formatting in the localized and formatted message.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getString(String key, String[] arguments)
    {
        return NLS.bind(getString(key), ((Object[])(arguments)));
    }
    
    /**
     * Logs an error described by a throwable.
     * 
     * <p>This method should be used whenever a class in this plugin
     * has to log an error since it adheres to the global logging
     * strategy.
     * 
     * @param throwable
     */
    public static void logError(Throwable exc)
    {
        Status status = new Status(1, getID(), 0, exc.toString(), exc);
        getDefault().getLog().log(status);
    }
    
    /**
     * Logs an error described by a text.
     * 
     * <p>This method should be whenever a class in this plugin
     * has to log an error since it adheres to the global logging
     * strategy.
     * 
     * @param text
     */
    public static void logError(String text)
    {
        logError(new Throwable(text));
    }
    
    /**
     * Returns this plugin's id.
     * @return String
     */
    public static String getID()
    {
        return PLUGIN_ID;
    }
    
    /** initialise default preference store */
    protected void initializeDefaultPreferences(IPreferenceStore store)
    {
        StylesInitializer.initializeDefaultPreferences(store);
    }
}
