/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SamplesPluginImageManager.java,v 1.1 2008/03/14 18:49:54 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.test.samples.internal.resources;

import java.net.URL;

import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.tptp.test.samples.SamplesPlugin;

/**
 *  Sample plug-in image manager.
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @version     March 14, 2008
 * @since       March 14, 2008
 */
public class SamplesPluginImageManager extends ImageManager
{
	/**
	 * Singleton instance.
	 */
	private static SamplesPluginImageManager instance = null;
	
	private SamplesPluginImageManager(){
		//No-operation since a privatized constructor.
	}
	
	public static SamplesPluginImageManager getInstance(){
		
		if(instance == null){
			
			instance = new SamplesPluginImageManager();

			try	{
	            instance.initialize(new URL(SamplesPlugin.getDefault().getBundle().getEntry("/"), "icons/full/"), SamplesPlugin.getDefault().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
			}
			catch(Exception e) {
				SamplesPlugin.logError(e);
			}
		}
		
		return instance;
	}
	
	public static final String IMG_WIZBAN_REPORT_WINDOW = "report_window_wiz.gif"; //$NON-NLS-1$
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_WIZBAN, IMG_WIZBAN_REPORT_WINDOW);
	}	
}
