/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: PrimaryTestAgent.java,v 1.1 2006/05/10 15:42:57 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.common.agent;

/**
 * This class acts as a static container of the primary test agent during a
 * test execution.  The TPTP Test execution framework supports multiple 
 * ComptestAgents in a given run, but only one of those ComptestAgents is
 * bound to the primary XMLExecutionDataProcessor on the workbench.  The
 * control channel for this primary agent can be used for service invocations,
 * and the data channel can currently be used to send XML fragments for loading
 * in the execution history data model which is generated as a result of this
 * test exection.
 * 
 * Plans are underway to enhance the XMLExecutionDataProcessor to accept other
 * XML fragments for loading into different TPTP data models.  This 
 * documentation will be updated when those enhancements are complete.
 *   
 * @author jtoomey
 * @provisional
 */
public class PrimaryTestAgent {

	private static ComptestAgent comptestAgent = null;

	/**
	 * @return the comptestAgent
	 */
	public static ComptestAgent getComptestAgent() {
		return comptestAgent;
	}

	/**
	 * @param comptestAgent the comptestAgent to set
	 */
	public static void setComptestAgent(ComptestAgent comptestAgent) {
		PrimaryTestAgent.comptestAgent = comptestAgent;
	}
	
}
