/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ServiceCommandHandler.java,v 1.4 2006/05/10 15:42:57 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.common.agent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.hyades.execution.local.testservices.ITestService;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;

/**
 * @author jtoomey
 * @provisional
 */
public class ServiceCommandHandler implements CustomCommandHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.remote.CustomCommandHandler#handleCommand(org.eclipse.hyades.internal.execution.local.common.CustomCommand)
	 */
	public void handleCommand(CustomCommand command) {
		
		if (command instanceof CustomCommand) {
			CustomCommand customCommand = (CustomCommand) command;
			String message = customCommand.getData();
			// Quickly determine if this command is interesting
			if ( message.startsWith(ITestService.TEST_SERVICE_PREFIX)) {
				// We received a response from an invoked test service.
				// Interpret and queue the response.
				Pattern pattern = Pattern.compile(ITestService.TEST_SERVICE_RETURN_PATTERN);
				Matcher matcher = pattern.matcher(message);
				if (matcher.find()) {
					String id = matcher.group(1);
					String result = matcher.group(2);
					int i = Integer.parseInt(id);
					ServiceInvoker.pushResult(i, result);
				}
				else {
					pattern = Pattern.compile(ITestService.TEST_SERVICE_UNKNOWN_PATTERN);
					matcher = pattern.matcher(message);
					if (matcher.find()) {
						String id = matcher.group(1);
						int i = Integer.parseInt(id);
						ServiceInvoker.pushUnknown(i);
					}
					else if (message.startsWith(ITestService.TEST_SERVICE_MALFORMED_PREFIX)) {
						System.out.println("Malformed Test service!");
						ServiceInvoker.notifyMalformed();
					}
				}
			}
		}
	}

}
