/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ServiceInvoker.java,v 1.3 2006/05/10 15:42:57 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.common.agent;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.hyades.execution.local.testservices.ITestService;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;

/**
 * @author jtoomey
 * @provisional
 */
public class ServiceInvoker {

	private static Map returnMap = new HashMap();
	private static int idCounter = 0;
	private static Object idCounterLock = new Object();

	public static String invokeService(String serviceName, String args) throws 
		UnknownTestServiceException, UnconfiguredComptestAgentException
	{
		String returnCommand = null;
		int invocationID;
		
		synchronized (idCounterLock) {
			// If we are about to exceed max int, start over at zero.
			// it's fairly certain that all old service requests have already been
			// serviced, or will not be serviced.
			if (idCounter == Integer.MAX_VALUE)
				idCounter = 0;
			idCounter++;
			invocationID = idCounter;
		}
		
		StringBuffer commandData = new StringBuffer();
		commandData.append(ITestService.TEST_SERVICE_INVOCATION_PREFIX);
		commandData.append(serviceName);
		commandData.append(ITestService.TEST_SERVICE_SEPARATOR);
		commandData.append(Integer.toString(invocationID));
		commandData.append(ITestService.TEST_SERVICE_SEPARATOR);
		commandData.append(args);
		
		CustomCommand command = new CustomCommand();
		command.setData(commandData.toString());
		
		invokeCustomCommand(command);
		
		returnCommand = waitForReturn(invocationID);
		if (returnCommand != null && 
			returnCommand.equalsIgnoreCase(ITestService.TEST_SERVICE_UNKNOWN_PREFIX))
			throw new UnknownTestServiceException(serviceName);
		
		return returnCommand;
	}

	/**
	 * @param serviceName
	 */
	private static String waitForReturn(int invocationID) {
		String returnValue = null;
		Object value = null;
		Integer id = new Integer(invocationID);
		
		synchronized (returnMap) {
			while(!returnMap.containsKey(id)) {
				try {
					returnMap.wait();
				} catch (InterruptedException e) {
				}
			}
			value = returnMap.get(id);
			if (value instanceof String) {
				returnValue = (String)value;
			}
			returnMap.remove(id);
		}
		
		return returnValue;
	}

	/**
	 * @param agent
	 * @param command
	 * @throws UnconfiguredComptestAgentException 
	 */
	protected static void invokeCustomCommand(CustomCommand command) throws UnconfiguredComptestAgentException {
		if (PrimaryTestAgent.getComptestAgent() != null) {
			PrimaryTestAgent.getComptestAgent().sendMessage(command.getData());
		}
		else {
			throw new UnconfiguredComptestAgentException();
		}
	}

	/**
	 * @param service
	 * @param result
	 */
	public static void pushResult(int id, String result) {
		synchronized (returnMap) {
			returnMap.put(new Integer(id), result);
			returnMap.notifyAll();
		}
	}

	/**
	 * @param service
	 */
	public static synchronized void pushUnknown(int id) {
		synchronized (returnMap) {
			returnMap.put(new Integer(id), ITestService.TEST_SERVICE_UNKNOWN_PREFIX);
			returnMap.notifyAll();
		}
	}

	/**
	 * 
	 */
	public static void notifyMalformed() {
		// TODO JPT: Handle by ID if possible
		
	}
}
